#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#include "sockets.h"
#include "logger.h"
#include "connect.h"

#define TCP_OK 0
void
close_socket (int *s, int how)
{
  if ((!s) || (*s < 0))
    return;
  /*
     DESCRIPTION       
     The shutdown call causes all or part of a full-duplex con-
     nection on the socket associated with s to be  shut  down. 
     If  how is 0, further receives will be disallowed.  If how 
     is 1, further sends will be disallowed.  If how is 2, fur-
     ther sends and receives will be disallowed.
   */
  if (how >= 0)
    shutdown (*s, how);
  close (*s);
  *s = -1;
}
int
tcpConnect (int *s, char *host_name, int port)
{
  struct sockaddr_in sin;
  struct hostent *phe;
  int r = -1;

  bzero (&sin, sizeof (sin));
  sin.sin_family = AF_INET;
  sin.sin_port = htons (port);
  if (!(phe = gethostbyname (host_name))) {
    logherror (LC_NONFATAL, "asockets:create_n_connect:gethostbyname");
    return (-1);
  }
  memcpy ((char *) &sin.sin_addr, phe->h_addr, phe->h_length);
  if ((*s = socket (PF_INET, SOCK_STREAM, IPPROTO_TCP)) == -1) {
    logerror (LC_FATAL, "asockets:create_n_connect:socket");
    return (-1);
  }
  if ((r = advconnect (*s, (struct sockaddr *) &sin, sizeof (sin))) != TCP_OK)
    close_socket (s, 2);
  return (r);
}
