#include <stdio.h>
#include <string.h>

#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <signal.h>
#include <stdlib.h>
#include <ctype.h>
#include "libtcp.h"
/*
 * 0.32 FIXED a ugly bug (the response was parsed false) 
 * 	But there are still some around in the parse routine
 */

void
handler (int test)
{
  printf ("Got Signal %i", test);
}

/*
 * stripHTML:  pointer        a null-terminated string that contains the html-page
 *                      
 *          RETURN      
 */

int
stripHTML (char *pointer)
{
  /* This Code simply throws out all HTML tags 
   * Assumption: The HTML Page is correct coded
   */
  char *source = pointer;
  char *dest = pointer;
  int eatit = 0;
  while (*source != 0) {
    if (*source == '<')
      eatit = 1;

    if (eatit);
    else
      *dest++ = *source;

    if (*source == '>' && eatit == 1)
      eatit = 0;

    source++;
  }
  *dest = 0;
  return (0);
}
/* Note we could do this in stripHTML, but
   this has nothing to do with stripping HTML tags
   Pure KIS (Keep It simple) theory
*/
int 
stripReturn(char *pointer)
{
	char *source =pointer;
	char *dest = pointer;
	
	while ( *source != 0 ) {
	
	if ( *source != '\r' ) *dest++ = *source;
	
	source++;
	}

}

char protocol[1024];
char text[1024];
int status;

#define HTTP_OK 200

/*
 * A damn getLine Routine
 */
char *getLine (char *pointer, char *buffer, int buflen);

int
parseResponseHeader (const char *pointer, char *&beginofhtml)
{
  sscanf (pointer, "%s%i%1024[^\r\n]", (char *) &protocol,
	  &status,
	  (char *) &text);
  /* Find end of Header 
   * end of header == one empty line 
   */
  char buffer[8192];
  char *run = (char *) pointer;
  do {
    run = getLine (run, (char *) &buffer, 8192);
    fprintf (stderr, "*%s*\n", (char *) &buffer);
  }
  while (buffer[0] != 0);
  beginofhtml = run;
  /* Copy this thing to the beginning */
  char *run2 = pointer;
  while (*run != 0) {
    *run2++ = *run++;
  }
  *run = 0;
  return (status);
}
/*
 * A goddamn getLine routine
 */

char *
getLine (char *pointer, char *buffer, int buflen)
{
  char *run = pointer;
  int skip;			// Skip "\r\n" or "\n" skip=1 or skip=2

  while (*run++ != 0) {
    if (*run == '\n') {
      if (*(--run) == '\r') {
	skip = 2;
	break;
      }
      else {
	skip = 1;
	run++;
	break;
      }
    }
  }

  int stringlen = run - pointer;
  if (stringlen > buflen)
    return 0L;
 //printf("Stringlen = %i\n", stringlen);
  strncpy (buffer, pointer, stringlen);
  buffer[stringlen] = 0;	// Mark Bufferend

  if (skip == 2) {
    run++;
    run++;
  }

  else
    run++;
  return run;
}

int
sendRequest (char *machine, int port, char *request, char *buffer, int buflen)
{
  int socket, error, len;
  char *run;
  run = buffer;
  buflen = 1024;
  tcpOpenLogFile ("./.logfile");
  error = tcpConnect (&socket, machine, port);
  if (error != 0)
    return 1;
  error = send (socket, request, strlen (request), 0);
  // printf("test\n");

  do {
    len = recv (socket, run, buflen, 0);
    //    printf("\n****len = %i %sxx", len,run);
    run += len;
  }
  while (!(len <= 0));

  return (run - ((char *) &buffer));
}

int
parseNorway (char *pointer, char *searchfile)
{
  stripHTML (pointer);

  // printf("*%s*",pointer);
  char *find;
  char *dest = pointer;
  int hits;

  find = strstr (pointer, "No hits");
  if (find != 0) {
    printf ("ERROR NO HITS\n");
    return (1);
  }

  find = strstr (pointer, "reported hit");	// search not for  "reported hits"

  /* Now extract the number left of reported hits */
  /* No, it isn't at the beginning of the line sometimes */
  if (find == 0)
    return (1);
  find--;
  while (isdigit (*find) | *find == ' ')
    find--;
  find++;

  sscanf (find, "%i", &hits);
  printf ("OK %i HITS\n", hits);
  if (hits == 0) {
    printf ("ERROR NO HITS\n");
    return 0;			// No hits at all

  }

  /* Search for the first occurence of searchfile 
   * We use this point as start point for our scanning 
   */
  find = strstr (pointer, searchfile);
  if (find == 0) {
    printf ("ERROR BAD/CHANGED REPLY FORMAT\n");
    return (1);
  }
  int i;
  int number;
  int number2;
  char linebuf[8192];
  char pathbuf[8192];
  char hostbuf[8192];
  char ergebnis[8192];

  /* Remark at the first iteration we skip the head and hope that there are no
     empty lines between this request */
  for (int z = 0; z < hits+1; z++) {
    memset(&linebuf,0,8192);
    memset(&pathbuf,0,8192);
    memset(&hostbuf,0,8192);
    memset(&ergebnis,0,8192);
       
    find = getLine (find, (char *) &linebuf, 8192);
    i = sscanf ((char *) &linebuf, "%i%i%s%s", &number, &number2, (char *) &hostbuf, (char *) &pathbuf);
 //   i = sscanf ((char *) &linebuf, "%i%i%s", &number, &number2, (char *) &pathbuf);
 
    /* Some correction are needed for the end of the line 
     * Strip html sometimes works to good an the nextline hangs on the end off
     * pathbuf
     * 
     */
    if ( i == 4 )
    printf ("%i %i ftp://%s%s\n", number, number2, (char *) &hostbuf, (char *) pathbuf);
//	printf ("%i %i ftp://%s\n", number, number2, (char *) &pathbuf);
 
    sprintf ((char *) &ergebnis, "%i %i ftp://%s%s\n", number, number2, (char *) &hostbuf, (char *) pathbuf);
    i = 0;
    while (ergebnis[i] != 0) {
      *dest++ = ergebnis[i];
      i++;
    }
  }
  *dest = 0;
}

#define NORWAY 1
void
parseFTPSearchanswer (int type, char *pointer, char *searchfile)
{

  parseNorway (pointer, searchfile);
/*
   switch ( type ) {
   case NORWAY: 
   parseNorway(pointer, searchfile);
   break; 
   case default:
   }

 */
}

void
search (char *file, char *buffer, int buflen)
{
  char get[2048];
  char *run;
  char *limitdomain="de";

  sprintf ((char *) &get,
	   ("GET /cgi-bin/search"
	    "?query=%s&"
	    "doit=Search&type=Exact+search&doexact=on&"
	    "hits=50&matches=&hitsprmatch=&"
	    "limdom=%s&"
	    "limpath=&f1=Count&f2=Len&"
	    "f3=Host&f4=Path&f5=-&f6=-&header=none&sort=none&trlen=20"
	    " HTTP/1.0"
	    "\n\n"), file, limitdomain);

  //printf("%s", get);

  //"http://ftpsearch.ntnu.no"

//#define HOME 1
#ifdef HOME
  sendRequest ("192.168.100.2", 80, (char *) &get, buffer, buflen);
#else
  sendRequest ("ftpsearch.ntnu.no", 80, (char *) &get, buffer, buflen);
#endif
  parseResponseHeader (buffer, run);

  //printf("%s",buffer);
  parseFTPSearchanswer (NORWAY, buffer, file);
}

#define ENUF(msg, value) { perror(msg); exit(value); }

int fd[2];

int
do_fork (char *file)
{
  int i, pid;
  char send[80], receive[80], *gets ();

  if (pipe (fd) != 0)
    ENUF ("pipe creation error", 1);
  i = 0;
  while ((pid = fork ()) == -1)	/* try a few times before giving up */
    if (++i > 5)
      printf ("can not fork after 5 attempts", 1);
    else
      sleep (5);
  if (pid == 0) {		/* CHILD process */
    fprintf (stdout, " Child pipe file descriptors: fd[0] %d, fd[1] %d \n", fd[0], fd[1]);
    close (fd[0]);
    /* close read end of pipe  (fd=3) */
    char *pointer = (char *) malloc (100 * 1024);
    search (file, pointer, 100 * 1024);
    write (fd[1], pointer, strlen (pointer));
    free (pointer);
    /* bounce message back */
    close (fd[1]);		/* close write end of pipe (fd=4) */
    exit (0);
  }
  else {
    /* PARENT process */
    close (fd[1]);		/* close write end of pipe (fd=4) */

//              i = read (fd[0], receive, 80); /* get message from child */
    //              receive[i] = '\0';
    //              close (fd[0]);  /* close read end of pipe  (fd=3) */
    //              fprintf (stdout, "\nParent received the following message: %s \n", receive);
    //waitpid (pid,0L,0);
    return (pid);
  }

}
