/***************************************************************************
                          article.cpp  -  description                              
                             -------------------                                         
    begin                : Tue Jun 15 1999                                           
    copyright            : (C) 1999 by Roberto Alsina                         
    email                : ralsina@unl.edu.ar                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <stdlib.h>

#include "article.h"
#include "kfileio.h"
#include "util.h"
#include <qstrlist.h>
#include <qfile.h>
#include <kapp.h>
#include <kstring.h>
#include "resource.h"


Article::Article(const char *data,int OffsetID,int OffsetFrom, int OffsetSubject,
                 int OffsetLines,int OffsetDate,int OffsetRef,int OffsetRead)
{
debug ("deprecated constructor");
//    parseData(data,OffsetID,OffsetFrom,OffsetSubject,OffsetLines,OffsetDate,OffsetRef,OffsetRead);
}


Article::Article (const char *_ID)
{
		dbCursor <Article> cursor;
		dbQuery q;
		q="ID=",_ID;
		if (cursor.select(q)>0)
		{
			ID=qstrdup(cursor->ID);
			From=qstrdup(cursor->From);
			Subject=qstrdup(cursor->Subject);
			Date=qstrdup(cursor->Date);
			Ref=qstrdup(cursor->Ref);
			Lines=cursor->Lines;
			Read=cursor->Read;
		}
}
void Article::parseData(const char *data,int OffsetID,int OffsetFrom, int OffsetSubject,
                        int OffsetLines,int OffsetDate,int OffsetRef,int OffsetRead)
{
debug ("deprecated parsedata");
}

void Article::save()
{
    dbCursor <Article> cursor(dbCursorForUpdate);
    insert (*this);
    debug ("article inserted");
    db.commit();
    debug ("db comitted");
}

Article::~Article()
{
//	delete From;
// delete Date;
//	delete ID;
//	delete Ref;
//	delete Subject;
}



ArtTreeNodeList *ArticleList::threaded()
{
    QDict <ArtTreeNode> artdict;
    artdict.setAutoDelete(false);
    ArtTreeNodeList *atnl=new ArtTreeNodeList;
    QListIterator <Article> it(*this);
    for (;it.current();++it)
    {
        //See if there is a place reserved for this article
        ArtTreeNode *n=artdict.find(it.current()->ID);
        if (n)
        {
            n->art=it.current();
            n->subject=it.current()->Subject;
            continue;
        }
        else //have to add a subthread
        {
            //First get a list of references, oldest first
            QStrList refs;
            QStringSplit(it.current()->Ref,' ',refs);
            //Create a node for the article
            ArtTreeNode *atn=new ArtTreeNode;
            atn->art=it.current();
            atn->parent=0;
            atn->subject=it.current()->Subject;
            //Take note of the node
            artdict.insert(it.current()->ID,atn);
            
            //For each reference, starting with the new ones, try to
            //attach to the reference tree
            QStrListIterator refit (refs);
            for (refit.toLast();refit.current();--refit)
            {
                ArtTreeNode *n=artdict.find(refit.current());
                if (n) //Found the tree
                {
                    //Mark the subthread as child of that node
                    //and that's it
                    n->children.append(atn);
                    atn->parent=n;
                    //Now, keep backtracking... as long as it doesn't
                    //introduce incoherent threading information.
                    //Basically create a thread, *forward* from my
                    //oldest reference, until meeting the tree again
                    //This may create a slightly not correct tree, but always a tree :-)
                    atn=0;
                    for (refit.toFirst();refit.current();++refit)
                    {
                        ArtTreeNode *n2=artdict.find(refit.current());
                        if (n2) //it's there, mark it as child of this
                                //subthread, and leave
                        {
                            if (n2->parent) //uh? It already has a parent
                            {
                                while (atn) //delete this thread because it's incoherent
                                {
                                    ArtTreeNode *tmp=atn->parent;
                                    delete atn;
                                    atn=tmp;
                                }
                            }
                            else //it doesn't have a parent
                            {
                                if (atn) //If I have a subthread created
                                {
                                    n2->parent=atn;
                                    atn->children.append(n2);
                                }
                            }
                            //backpropagate the older subject
                            atn=n2;
                            while (atn)
                            {
                                if (atn->parent)
                                {
                                    atn->parent->subject=atn->subject;
                                }
                                atn=atn->parent;
                            }
                            //and leave
                            break;
                        }
                        else //This node doesn't exist yet. Create it.
                        {
                            ArtTreeNode *atnolder=atn;
                            atn=new ArtTreeNode;
                            atn->art=0;
                            atn->parent=atnolder;
                            artdict.insert(refit.current(),atn);
                            if (atnolder) //I mean, if not 0
                            {
                                atnolder->children.append(atn);
                            }
                        }
                    }
                    break;
                }
                else //have to keep backtracking
                {
                    ArtTreeNode *atnolder=new ArtTreeNode;
                    artdict.insert(refit.current(),atnolder);
                    atnolder->parent=0;
                    atnolder->art=0;
                    atnolder->children.append(atn);
                    atnolder->subject=atn->subject;
                    atn->parent=atnolder;
                    atn=atnolder;
                    //and take note of the placeholding node
                }
            }
        }
    }

    //Now go over the list of nodes, and put all roots in the list
    QDictIterator <ArtTreeNode> dit (artdict);
    for (dit.toFirst();dit.current();++dit)
    {
        if (!(dit.current()->parent)) //root
            atnl->append(dit.current());
    }

    // FIXME atnl should be sorted by simplified subject to make
    // for better threading
    
    return atnl;
}







