/***************************************************************************
                          kmtprotocolclient.cpp  -  description                              
                             -------------------                                         
    begin                : Tue Jun 8 1999                                           
    copyright            : (C) 1999 by Roberto Alsina                         
    email                : ralsina@unl.edu.ar                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <string.h>
#include <errno.h>
#include <sys/time.h>

#include <pth.h>

#include "kmtprotocolclient.h"

#include <qglobal.h>

static const char* get_error_text(int aErrorCode)
{
    const char* msg = "";
    switch (aErrorCode)
    {
    case DwProtocolClient::kErrNoError:
        msg = "No error";
        break;
    case DwProtocolClient::kErrUnknownError:
        msg = "Unknown error";
        break;
    case DwProtocolClient::kErrBadParameter:
        msg = "(MIME++) bad parameter passed to function";
        break;
    case DwProtocolClient::kErrBadUsage:
        msg = "(MIME++) bad library usage";
        break;
    case DwProtocolClient::kErrNoWinsock:
        msg = "(MIME++) incompatible Winsock version";
        break;
    case DwProtocolClient::kErrHostNotFound:
        msg = "Host not found";
        break;
    case DwProtocolClient::kErrTryAgain:
        msg = "Nonauthoritative host not found";
        break;
    case DwProtocolClient::kErrNoRecovery:
        msg = "Nonrecoverable errors: FORMERR, REFUSED, NOTIMP";
        break;
    case DwProtocolClient::kErrNoData:
        msg = "Valid name, no data record of requested type";
        break;
    case DwProtocolClient::kErrNoAddress:
        msg = "No address, look for MX record";
        break;
    default:
        msg = strerror(aErrorCode);
        break;
    }
    return msg;
}

KMTProtocolClient::KMTProtocolClient()
{
    busy=0;
    taken=0;
}
KMTProtocolClient::~KMTProtocolClient()
{
}

int KMTProtocolClient::PSend(const char* aBuf, int aBufLen)
{
    mFailureCode = kFailNoFailure;
    mFailureStr  = "";
    mErrorCode   = kErrNoError;
    mErrorStr    = get_error_text(mErrorCode);

    if (! mIsOpen)
    {
        // error!
        mErrorCode = kErrBadUsage;
        mErrorStr = get_error_text(mErrorCode);
        return 0;
    }
    int ret;
    int numToSend = aBufLen;
    int numSent = 0;
    while (numToSend > 0)
    {
        ret = pth_write(mSocket, &aBuf[numSent], numToSend);
        if (ret == -1)
        {
            // error!
            int err = errno;
            HandleError(err, ksend);
            break;
        }
        else
        {
            numSent += ret;
            numToSend -= ret;
        }
    }
    return numSent;
}

int KMTProtocolClient::PReceive(char* aBuf, int aBufSize)
{
    mFailureCode = kFailNoFailure;
    mFailureStr  = "";
    mErrorCode   = kErrNoError;
    mErrorStr    = get_error_text(mErrorCode);

    int numReceived=0;

    if (! mIsOpen)
    {
        // error!
        mErrorCode = kErrBadUsage;
        mErrorStr = get_error_text(mErrorCode);
        return 0;
    }

    // Suspend until there's input to read

    fd_set readfds;
    FD_ZERO(&readfds);
    FD_SET(mSocket, &readfds);
    struct timeval timeout;
    timeout.tv_sec = mReceiveTimeout;
    timeout.tv_usec = 0;
    int ret = pth_read(mSocket, aBuf, aBufSize);
    if (ret == -1)
    {
        // error!
        int err = errno;
        HandleError(err, krecv);
        numReceived = 0;
    }
    else /* if (ret != -1) */
    {
        numReceived = ret;
    }

    return numReceived;
}
