/***************************************************************************
 main.cpp  -  description                              
 -------------------                                         
 begin                : Tue Jun  8 20:40:39 /etc/localtime 1999
 
 copyright            : (C) 1999 by Roberto Alsina                         
 email                : ralsina@unl.edu.ar                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <fcntl.h>
#include <unistd.h>

#include <pth.h>
#include "util.h"

#include "newkrn.h"
#include "connmgr.h"
#include "fastdb/fastdb.h"
#include "article.h"

ConnMgr *connmgr=0;
pth_attr_t attr;

REGISTER(Article);
REGISTER(GroupItem);

int main(int argc, char* argv[])

{
    pth_init();
    pth_attr_init (attr);
    pth_attr_set (attr,PTH_ATTR_STACK_SIZE,256*1024);
    KMTApplication app(argc,argv,"newkrn");
    connmgr=new ConnMgr();
    pth_spawn(attr,thr_Reaper,NULL);
    pth_spawn(attr,thr_UpdateStatuses,NULL);

    testDir( "/share" );
    testDir( "/share/config" );
    testDir( "/share/apps" );
    testDir( "/share/apps/newkrn" );
    testDir( "/share/apps/newkrn/servers.active" );
    testDir( "/share/apps/newkrn/servers" );
    testDir("/share/apps/newkrn/groupinfo");
    testDir("/share/apps/newkrn/cache");
    testDir("/share/apps/newkrn/Folders");
    //  testDir( "/share/apps/newkrn/outgoing" );
    int res=db.open("articles",KApplication::localkdedir()+"/share/apps/newkrn/articles.fdb");
    debug ("db.open-->%d",res);
    if (!res)
    {
        exit(1);
    }
    
    if (app.isRestored())
    {
        RESTORE(NewKrnApp);
    }
    else
    {
        NewKrnApp* newkrn = new NewKrnApp;
        connmgr->widget=newkrn->view->connections;
        newkrn->show();
    }
    app.exec();
    db.close();
    return 0;
}











