/***************************************************************************
                          faxnumber.cpp  -  description
                             -------------------
    begin                : Mon Feb 7 2000
    copyright            : (C) 2000 by Michael Sabielny
    email                : sabielny@tu-harburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "faxnumber.h"

// Constructor
FaxNumber::FaxNumber(QWidget* parent,const char* name) : QLCDNumber(parent,name){
	
	// allow focus
	// setFocusPolicy(QWidget::StrongFocus);
	// set init-value
	QLCDNumber::display("");
}

// Destructor
FaxNumber::~FaxNumber()
{}

// Method set_the_display
void FaxNumber::setFaxNumber(QString number){

	// set the currentNumber
	currentNumber = number;	
		
	// inform Widget about the length of the current number
	QLCDNumber::setNumDigits( (int)currentNumber.length() );
	
	// display this Number
	QLCDNumber::display(currentNumber);

		
	// emit signal
	// signal-implementation
	if (currentNumber.length() == 0)
	{
		// if the current faxnumber does not exist, emit TRUE...
		emit numberIsSet(-1,0);
	}
	else
	{
		// ...else emit FALSE.
		emit numberIsSet(-1,1);
	}
}
	
// Method: return_the_fax_number
QString FaxNumber::getFaxNumber(){
	
	return (currentNumber);
}

// Method: clear_the_display
void FaxNumber::clearFaxNumber(){

	currentNumber = "";
	QLCDNumber::display(currentNumber);
	
	// emit the displayIsEmpty signal
	emit numberIsSet(-1,0);
}