/***************************************************************************
                          optiondialog.cpp  -  description
                             -------------------
    begin                : Mon Feb 28 2000
    copyright            : (C) 2000 by Michael Sabielny
    email                : sabielny@tu-harburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kapp.h> // mainly for the i18n()-macros
#include "globaldata.h"
#include "optiondialog.h"
#include <qwidget.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qlayout.h>
#include <qfontmetrics.h>
#include <qradiobutton.h>

OptionDialog::OptionDialog(QWidget* parent = 0,const char* name = 0, bool modal) : QTabDialog(parent, name, modal)
{
	// set the global geometric parameters
	// trick: set an impossible value....
	resize(10,10);
	setCaption(i18n("sendfaKs Options"));

	// base of the fist tab
	QWidget *sideOne = new QWidget(this);
	// grid for placing the widgets in this tab
	QVBoxLayout *sideOneLayout = new QVBoxLayout(sideOne,15);

		
	QGroupBox *identityBox = new QGroupBox(sideOne);
	identityBox->setTitle(i18n("Please fill out these fields."));
	sideOneLayout->addWidget(identityBox);
	
	QVBoxLayout *subLayout = new QVBoxLayout(identityBox,15);	
	QFontMetrics fm1 = identityBox->fontMetrics();
	subLayout->addSpacing(fm1.height());
	
	// label username
	QLabel *labelUserName = new QLabel(i18n("Your Name:"), identityBox);
	labelUserName->setFixedHeight(labelUserName->sizeHint().height());
	labelUserName->setAlignment(AlignHCenter);
	subLayout->addWidget(labelUserName);
	
	// inputfield username
	nameDisplay = new QLineEdit(identityBox);
	nameDisplay->setFixedHeight(nameDisplay->sizeHint().height());
	subLayout->addWidget(nameDisplay);
	
	//label email-address
	QLabel *labelUserEmail = new QLabel(i18n("Your e-Mail Address:"), identityBox);
	labelUserEmail->setFixedHeight(labelUserEmail->sizeHint().height());
	labelUserEmail->setAlignment(AlignHCenter);
	subLayout->addWidget(labelUserEmail);	
	
	// inputfield email-address
	emailDisplay = new QLineEdit(identityBox);
	emailDisplay->setEnabled(FALSE);
	emailDisplay->setFixedHeight(emailDisplay->sizeHint().height());
	subLayout->addWidget(emailDisplay);	
	
	addTab(sideOne, i18n("&Identity"));
	
	//////////////////////////////////////////////////////////////
	// second Tab
	
	// base for the second tab	
	QWidget *sideTwo = new QWidget(this);
	// this is the main layout for this tab
	QVBoxLayout *sideTwoLayout = new QVBoxLayout(sideTwo, 15);	
		
	// creates a group for the buttons
	headerGroup = new QButtonGroup(sideTwo);
	headerGroup->setTitle(i18n("Please choose your desired faxheader."));
	// adds the group to the main layout
	sideTwoLayout->addWidget(headerGroup);
	
	// this layout works inside the button group
	QVBoxLayout *headerLayout = new QVBoxLayout(headerGroup,15);
	QFontMetrics fm2 = headerGroup->fontMetrics();
 	headerLayout->addSpacing(fm2.height());
	// define a pointer to a button
	QRadioButton *header;
	// creates the first button and names it
	header = new QRadioButton(headerGroup);
	header->setText(i18n("No Faxheader")); // has id=0
	// adds this button to the layout inside of the button group
	headerLayout->addWidget(header);
	
	// use the same pointer for all following buttons
	header = new QRadioButton(headerGroup);
	header->setText(i18n("Standard Faxheader")); // has id=1
	// add the button to the layout
	headerLayout->addWidget(header);
	
	// and the same again for the third button
	header = new QRadioButton(headerGroup);
	header->setText(i18n("Custom Faxheader")); // has id=2
	headerLayout->addWidget(header);
	
	// this creates a Widget for a user defined Faxheader
	headerDisplay = new QLineEdit(sideTwo);
	headerDisplay->setEnabled(FALSE);
	headerDisplay->setText( customHeader );
	headerDisplay->setFixedHeight(headerDisplay->sizeHint().height());
	// add this widget to the main layout again (outside the button group)
	sideTwoLayout->addWidget(headerDisplay);
	
	// activate all layouts and add the tab
	//headerLayout->activate();
	//sideTwoLayout->activate();	
	addTab(sideTwo, i18n("&Faxheader"));

	// sets all the buttons and connects them
	setOkButton(i18n("OK"));
	setApplyButton(i18n("Apply"));
	setCancelButton(i18n("&Cancel"));
	connect(this,SIGNAL(applyButtonPressed()),this, SLOT(slotSetConfig()));
	connect(headerGroup,SIGNAL(clicked(int)), this, SLOT(slotEnableHeaderDisplay(int)));
	
	// now get the current config
	this->slotGetConfig();
}

OptionDialog::~OptionDialog(){
}


void OptionDialog::slotGetConfig()
{
	// shows the current set userName
	nameDisplay->setText( userName );
			
	// this sets the current active button
	lastButtonId = userHeader;	
	headerGroup->setButton( lastButtonId );
	if ( lastButtonId == 2 )
	{
		headerDisplay->setEnabled(TRUE);
		headerDisplay->setText( customHeader );			
	}
	else
	{
		headerDisplay->setEnabled(FALSE);
	}					
}

void OptionDialog::slotEnableHeaderDisplay(int id_)
{
	// automatically set lastButtonId if any radiobutton is clicked
	lastButtonId = id_;

	// this is for the headerDisplay
	switch (lastButtonId)
	{
		case 2:
			headerDisplay->setEnabled(TRUE);
			headerDisplay->setText( customHeader );
			break;
		
		default:
			headerDisplay->setEnabled(FALSE);
			break;
	}
}


void OptionDialog::slotSetConfig()
{
	// set the new userName
	userName = nameDisplay->text();
	
	// get the new custom header
	customHeader = headerDisplay->text();
	
	// set the current userHeader
	userHeader = lastButtonId;
}

