/***************************************************************************
                          sendnfaks.cpp  -  description
                             -------------------
    begin                : Fri Jan 28 16:21:57 CET 2000
    copyright            : (C) 2000 by Michael Sabielny
    email                : sabielny@tu-harburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for QT
#include <qwidget.h>
#include <qdir.h>
#include <qstrlist.h>
#include <qfile.h>
#include <qstring.h>

// include files for KDE
#include <kiconloader.h>
#include <kmsgbox.h>
#include <kfiledialog.h>

// application specific includes
#include "globaldata.h"
#include "sendfaks.h"
#include "sendfaksview.h"
#include "resource.h"
#include "faxnumber.h"
#include "qkeycode.h"
#include "optiondialog.h"

/////////////////////////////////////////////////////////////////////
// storage allocation of the global data, check globaldata.h
QString userName;
QString userEmail;
QString customHeader;
unsigned int userHeader;
/////////////////////////////////////////////////////////////////////



SendfaKsApp::SendfaKsApp()
{
	config=kapp->getConfig();

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initMenuBar();
  initToolBar();
  initStatusBar();
  initKeyAccel();
  initView();
  initProcs();
	
  readOptions();
  checkOptions();

  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar items at startup
  disableCommand(ID_FAX_SEND);
  disableCommand(ID_FAX_POLL);
	disableCommand(ID_LIST_DELETE);
	disableCommand(ID_LIST_UP);
	disableCommand(ID_LIST_DOWN);
	// other inits
	faxNumberIsSet = FALSE;
	fileListHasItems = FALSE;
}

SendfaKsApp::~SendfaKsApp()
{

}

void SendfaKsApp::initKeyAccel()
{
  keyAccel = new KAccel(this);
	
  // Std-Accelerator FILE->QUIT
  keyAccel->connectItem(KAccel::Quit, this, SLOT(slotFaxQuit()));
  keyAccel->changeMenuAccel(faxMenu, ID_FAX_QUIT, KAccel::Quit);

  // Std-Accelerator LIST->OPEN
  keyAccel->connectItem(KAccel::Open, this, SLOT(slotListOpen()));
  keyAccel->changeMenuAccel(listMenu, ID_LIST_OPEN, KAccel::Open);

  // Std-Accelerator HELP->
  keyAccel->connectItem(KAccel::Help, kapp, SLOT(appHelpActivated()));

  // Accelerator FILE->SEND
  // define a new Item for sending the fax
  //                   description  action         key
  keyAccel->insertItem("Send Fax",  "Send",  CTRL+Key_Return);
  // must not be connected here like the other accelerators,
  // check enableCOmmand() or disableCommand() !!!
	// update the menuEntry
	keyAccel->changeMenuAccel(faxMenu, ID_FAX_SEND, "Send");

  // Accelerator FILE->POLL
  // define a new Item for sending the fax
  //                   description  action         key
  keyAccel->insertItem("Poll Fax",  "Poll",  ALT+Key_Return);
  // must not be connected here like the other accelerators,
  // check enableCOmmand() or disableCommand() !!!
	// update the menuEntry
	keyAccel->changeMenuAccel(faxMenu, ID_FAX_POLL, "Poll");
	
	
  keyAccel->readSettings();	
}

//=======================================================================================//


void SendfaKsApp::initMenuBar()
{
  ///////////////////////////////////////////////////////////////////
  // MENUBAR
  recentFilesMenu = new QPopupMenu();
  connect(recentFilesMenu, SIGNAL(activated(int)), SLOT(slotListOpenRecent(int)));

  ///////////////////////////////////////////////////////////////////
  // menuBar entry faxMenu
  faxMenu = new QPopupMenu();
  faxMenu->insertItem(Icon("send.xpm"), i18n("&Send"),ID_FAX_SEND);
  faxMenu->insertItem(Icon("lassoo.xpm"), i18n("&Poll"),ID_FAX_POLL);
	faxMenu->insertItem(Icon("tick.xpm"), i18n("Sta&tus"), ID_FAX_STATUS);
	faxMenu->insertItem(Icon("filedel.xpm"), i18n("&Delete"), ID_FAX_DELETE);
  faxMenu->insertSeparator();
  faxMenu->insertItem(i18n("E&xit"), ID_FAX_QUIT);
	
  ///////////////////////////////////////////////////////////////////
  // menuBar entry listMenu
  listMenu = new QPopupMenu();
  listMenu->insertItem(Icon("fileopen.xpm"), i18n("&Open..."), ID_LIST_OPEN);
  listMenu->insertItem(Icon("fileopen.xpm"), i18n("Open &recent"), recentFilesMenu, ID_LIST_OPEN_RECENT);
  listMenu->insertItem(Icon("eraser.xpm"), i18n("Delete"), ID_LIST_DELETE);
  listMenu->insertItem(Icon("up.xpm"), i18n("Move Up"), ID_LIST_UP);
	listMenu->insertItem(Icon("down.xpm"), i18n("Move Down"), ID_LIST_DOWN);


  ///////////////////////////////////////////////////////////////////
  // menuBar entry viewMenu
  viewMenu = new QPopupMenu();
  viewMenu->setCheckable(true);
  viewMenu->insertItem(i18n("&Toolbar"), ID_VIEW_TOOLBAR);
  viewMenu->insertItem(i18n("&Statusbar"), ID_VIEW_STATUSBAR);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry listMenu
  setupMenu = new QPopupMenu();
	setupMenu->insertItem(Icon("configure.xpm"), i18n("&Options"), ID_SETUP_OPTIONS);


  ///////////////////////////////////////////////////////////////////
  // menuBar entry helpMenu
  const char *aboutstring=i18n("sendfaKs "VERSION"\n"
  											       "A new interface to sendfax\n"
   														 "by Michael Sabielny.\n\n"
   														 "Get the latest version from:\n"
   														 "http://members.xoom.com/sendfaKs/");

  helpMenu = new QPopupMenu();
  helpMenu = kapp->getHelpMenu(true, aboutstring);


  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // insert your popup menus with the according menubar entries in the order
  // they will appear later from left to right
  menuBar()->insertItem(i18n("&Fax"), faxMenu);
  menuBar()->insertItem(i18n("&List"), listMenu);
  menuBar()->insertItem(i18n("&View"), viewMenu);
  menuBar()->insertItem(i18n("&Setup"), setupMenu);

  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&Help"), helpMenu);

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE MENU SLOTS WITH SIGNALS
  // for execution slots and statusbar messages

  connect(faxMenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));
  connect(faxMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));

  connect(listMenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));
  connect(listMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));

  connect(viewMenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));
  connect(viewMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));

  connect(setupMenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));
  connect(setupMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));

}

//=======================================================================================//

void SendfaKsApp::initToolBar()
{

  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  toolBar()->insertButton(Icon("send.xpm"), ID_FAX_SEND, true, i18n("Send Fax"));
	toolBar()->insertButton(Icon("lassoo.xpm"), ID_FAX_POLL, true, i18n("Poll Fax"));
	toolBar()->insertButton(Icon("tick.xpm"), ID_FAX_STATUS, true, i18n("Faxdaemon Status"));
	toolBar()->insertButton(Icon("filedel.xpm"), ID_FAX_DELETE, true, i18n("Delete Job"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("fileopen.xpm"), ID_LIST_OPEN, true, i18n("Open File"));
  toolBar()->insertButton(Icon("eraser.xpm"), ID_LIST_DELETE, true, i18n("Delete Entry"));
  toolBar()->insertButton(Icon("up.xpm"), ID_LIST_UP, true, i18n("Move Entry Up"));
	toolBar()->insertButton(Icon("down.xpm"), ID_LIST_DOWN, true, i18n("Move Entry Down"));

  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("configure.xpm"), ID_SETUP_OPTIONS, true, i18n("Edit Options"));
  toolBar()->insertButton(Icon("help.xpm"), ID_HELP_CONTENTS, SIGNAL(clicked()),
  				kapp, SLOT(appHelpActivated()), true,i18n("Help"));

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC TOOLBARS HERE WITH toolBar(n)


  ///////////////////////////////////////////////////////////////////
  // CONNECT THE TOOLBAR SLOTS WITH SIGNALS - add new created toolbars by their according number
  // connect for invoking the slot actions
  connect(toolBar(), SIGNAL(clicked(int)), SLOT(commandCallback(int)));
  // connect for the status help on holing icons pressed with the mouse button
  connect(toolBar(), SIGNAL(pressed(int)), SLOT(statusCallback(int)));

}

//=======================================================================================//

void SendfaKsApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  // STATUSBAR
  // TODO: add your own items you need for displaying current application status.
  statusBar()->insertItem(i18n("Welcome to sendfaKs!"), ID_STATUS_MSG);
}

//=======================================================================================//


void SendfaKsApp::initView()
{
  ////////////////////////////////////////////////////////////////////
  // create the main widget here that is managed by KTMainWindow's view-region and
  // connect the widget to your document to display document contents.

  view = new SendfaKsView(this);
  view->setFixedSize(420,220);
	
	// ceates Tab-Environment
	mainSelect = new AutoTab(view);
	mainSelect->setGeometry(10,10,400,200);
	
	// underlaying widgets in every tab for a better view
	QWidget *baseServerListBox = new QWidget(mainSelect);
	QWidget *baseFaxNumber = new QWidget(mainSelect);
	QWidget *baseFileListBox = new QWidget(mainSelect);
	QWidget *baseMessageListBox = new QWidget(mainSelect);
	// listboxes as childs of their bases
	serverListBox = new QListBox(baseServerListBox);
	serverListBox->setGeometry(8,10,380,150);
	fileListBox = new ListBox(baseFileListBox);
	fileListBox->setGeometry(8,10,380,150);
	
	faxNumberDisplay = new FaxNumber(baseFaxNumber);
	faxNumberDisplay->setGeometry(48,58,300,50);
	messageListBox = new QListBox(baseMessageListBox);
	messageListBox->setGeometry(8,10,380,150);
	
	// adding Tabs, do not mix up the tab-sequence without updating resoures.h!
	mainSelect->addTab( baseServerListBox, i18n("Faxserver")); 	// id=ID_TAB_FAXSERVER
	mainSelect->addTab( baseFileListBox, i18n("Filelist"));			// id=ID_TAB_FILELIST
	mainSelect->addTab( baseFaxNumber, i18n("Faxnumber"));			// id=ID_TAB_FAXNUMBER
	mainSelect->addTab( baseMessageListBox, i18n("Messages"));	// id=ID_TAB_MESSAGES
	
		
  setView(view);
  // name and version
  QString caption="sendfaKs "VERSION;
  setCaption(caption);

}
//=======================================================================================//

void SendfaKsApp::initProcs()
{
	// create new kprocess-object for acquirering the fax-daemon status using "faxq"
	procGetFaxStatus = new KProcess();
	// connects proc_stdout_output <-> slotProcessOutput
	connect(procGetFaxStatus, SIGNAL(receivedStdout(KProcess*, char*, int)),
					this, SLOT(slotProcessOutput(KProcess*, char*, int)));
	// connects proc_stderr_output <-> slotProcessOutput
	connect(procGetFaxStatus, SIGNAL(receivedStderr(KProcess*, char*, int)),
					this, SLOT(slotProcessOutput(KProcess*, char*, int)));
	// connects proc_exit <-> slotProcessExit
	connect(procGetFaxStatus, SIGNAL(processExited(KProcess*)), this, SLOT(slotProcessExit(KProcess*)));
										
	
	
	// create new kprocess-object for queueing the fax-document(s) using "faxspool <args>"
	procSendFax = new KProcess();
	// connects proc_stdout_output <-> slotProcessOutput
	connect(procSendFax, SIGNAL(receivedStdout(KProcess*, char*, int)),
					this, SLOT(slotProcessOutput(KProcess*, char*, int)));
	// connects proc_stderr_output <-> slotProcessOutput
	connect(procSendFax, SIGNAL(receivedStderr(KProcess*, char*, int)),
					this, SLOT(slotProcessOutput(KProcess*, char*, int)));
	// connects proc_exit <-> slotProcessExit
	connect(procSendFax, SIGNAL(processExited(KProcess*)), this, SLOT(slotProcessExit(KProcess*)));
	
	
	
	// create new kprocess-object for polling a fax using "faxspool -p <number>"
	procPollFax = new KProcess();
	// connects proc_stdout_output <-> slotProcessOutput
	connect(procPollFax, SIGNAL(receivedStdout(KProcess*, char*, int)),
					this, SLOT(slotProcessOutput(KProcess*, char*, int)));
	// connects proc_stderr_output <-> slotProcessOutput
	connect(procPollFax, SIGNAL(receivedStderr(KProcess*, char*, int)),
					this, SLOT(slotProcessOutput(KProcess*, char*, int)));
	// connects proc_exit <-> slotProcessExit
	connect(procPollFax, SIGNAL(processExited(KProcess*)), this, SLOT(slotProcessExit(KProcess*)));
	
	
	
	// create new kprocess-object for removing jobs
	procRemoveFax = new KProcess();
	// connects proc_stdout_output <-> slotProcessOutput
	connect(procRemoveFax, SIGNAL(receivedStdout(KProcess*, char*, int)),
					this, SLOT(slotProcessOutput(KProcess*, char*, int)));
	// connects proc_stderr_output <-> slotProcessOutput
	connect(procRemoveFax, SIGNAL(receivedStderr(KProcess*, char*, int)),
					this, SLOT(slotProcessOutput(KProcess*, char*, int)));
	// connects proc_exit <-> slotProcessExit
	connect(procRemoveFax, SIGNAL(processExited(KProcess*)), this, SLOT(slotProcessExit(KProcess*)));
	
	
	
	// provides information of the current fax-number, the button send_fax depends on this for error-protection
	connect(faxNumberDisplay, SIGNAL(numberIsSet(int,int)), this, SLOT(slotEnableSendPoll(int,int)));
	connect(fileListBox, SIGNAL(listBoxHasItems(int,int)), this, SLOT(slotEnableSendPoll(int,int)));
	
	// provides information for ebableing/disableing the move_ and delete buttons (error protection)
	connect(fileListBox, SIGNAL(listBoxStatus(bool,bool,bool)), this, SLOT(slotListButtons(bool,bool,bool)));
	
	// makes a faxdaemon auto-check at startup
	this->slotFaxStatus();				
}

void SendfaKsApp::enableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // enable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_, true);
  toolBar()->setItemEnabled(id_, true);

  // special assignments to the key-accelerators
	switch (id_)
	{
		case ID_FAX_SEND:
			// when ID_FAX_SEND is enabled, connect the belonging accelerator
			keyAccel->connectItem("Send", this, SLOT(slotFaxSend()));
			break;
		
		case ID_FAX_POLL:
			// when ID_FAX_SEND is enabled, connect the belonging accelerator
			keyAccel->connectItem("Poll", this, SLOT(slotFaxPoll()));
			break;
		
		default:
			break;
	}
}

//=======================================================================================//

void SendfaKsApp::disableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_, false);
  toolBar()->setItemEnabled(id_, false);

  // special assignments to the key-accelerators
	switch (id_)
	{
	
		case ID_FAX_SEND:
			// when ID_FAX_SEND is enabled, disconnect the belonging accelerator
			keyAccel->disconnectItem("Send", this, SLOT(slotFaxSend()));
			break;
		
		case ID_FAX_POLL:
			// when ID_FAX_SEND is enabled, disconnect the belonging accelerator
			keyAccel->disconnectItem("Poll", this, SLOT(slotFaxPoll()));
			break;
		
		default:
			break;
	}
}

//=======================================================================================//

void SendfaKsApp::addRecentFile(const QString &file)
{
  if(recentFiles.find(file) == -1)
  {
    if( recentFiles.count() < 5)
    {
      recentFiles.insert(0, file);
    }
    else
    {
      recentFiles.remove(4);
      recentFiles.insert(0, file);
    }
    recentFilesMenu->clear();
    for ( int i=0 ; i < (int) recentFiles.count(); i++)
    {
      recentFilesMenu->insertItem(recentFiles.at(i));
    }
  }
}

//=======================================================================================//

void SendfaKsApp::saveOptions()
{	
  config->setGroup("General Options");
  config->writeEntry("Geometry", size());
  config->writeEntry("Show Toolbar", toolBar()->isVisible());
  config->writeEntry("Show Statusbar",statusBar()->isVisible());
  config->writeEntry("MenuBarPos", (int) menuBar()->menuBarPos());
  config->writeEntry("ToolBarPos", (int) toolBar()->barPos());
  config->writeEntry("Recent Files", recentFiles);
  // new entries
  config->setGroup("User Options");
  config->writeEntry("Name", userName);
  config->writeEntry("Email", userEmail);
	config->writeEntry("Faxheader", userHeader);
	config->writeEntry("Custom Header", customHeader);
	
	config->sync();
}

//=======================================================================================//


void SendfaKsApp::readOptions()
{
	
  config->setGroup("General Options");

  // bar status settings
  bool bViewToolbar = config->readBoolEntry("Show Toolbar", true);
  viewMenu->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
  if(!bViewToolbar)
  {
     enableToolBar(KToolBar::Hide);
  }
	
  bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
  viewMenu->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);
  if(!bViewStatusbar)
  {
    enableStatusBar(KStatusBar::Hide);
  }

  // bar position settings
  KMenuBar::menuPosition menuBarPos;
  menuBarPos=(KMenuBar::menuPosition) config->readNumEntry("MenuBarPos", KMenuBar::Top);

  KToolBar::BarPosition toolBarPos;
  toolBarPos=(KToolBar::BarPosition) config->readNumEntry("ToolBarPos", KToolBar::Top);

  menuBar()->setMenuBarPos(menuBarPos);
  toolBar()->setBarPos(toolBarPos);
	
  // initialize the recent file list
  recentFiles.setAutoDelete(TRUE);
  config->readListEntry("Recent Files", recentFiles);
	
  recentFilesMenu->clear();
  for (int i=0; i < (int) recentFiles.count(); i++)
  {
    recentFilesMenu->insertItem(recentFiles.at(i));
  }

  QSize size=config->readSizeEntry("Geometry");
  if(!size.isEmpty())
  {
    resize(size);
  }

  // initialize user-options
  config->setGroup("User Options");
  // get the keys, if they don't exist, default is ""
  userName = config->readEntry("Name", "");
  userEmail = config->readEntry("Email", "");
  userHeader = config->readUnsignedNumEntry("Faxheader",0);
  // this is the default implementation of a customHeader, only used, if no other version exists
  customHeader = config->readEntry("Custom Header");
  if ( customHeader.isEmpty() )
  {
  	// set to default value
		customHeader="FAX FROM: @N@  @ID@  TO: @T@  PAGE: @P@ OF @M@";
  }
}

void SendfaKsApp::checkOptions()
{
	// this method checks all user specific options and calls a option dialog,
	// if something fails
	if ( userName == "")
	{
		this->slotSetupOptions();		
	}
}

QString SendfaKsApp::createCustomHeaderFile()
{
	QString fileName = ".myfaxheader.asc";
	// create an external sratch file in the homedirectory
	QFile myHeader(fileName);
	if ( myHeader.open(IO_WriteOnly) )
	{
		myHeader.writeBlock(customHeader, customHeader.length());
		myHeader.close();
	}
	else
	{
		debug("Error: can not open "+fileName);
	}
	
	return(fileName);
}

void SendfaKsApp::removeCustomHeaderFile()
{
	QFile myHeader(".myfaxheader.asc");
	if ( myHeader.exists() )
	{
		myHeader.remove();
	}	
}

// implementation of the keyPressEvent
void SendfaKsApp::keyPressEvent(QKeyEvent *ev){
	
	// first of all, accept the key_event
	ev->accept();	

	// get the actual faxNumber
	QString faxNumber = faxNumberDisplay->getFaxNumber();
		
	// ok, so lets see what happens to the keys...
	QString digit;
	switch (ev->key())
	{
		case Key_0 : digit = "0";
				 break;
		case Key_1 : digit = "1";
				 break;
		case Key_2 : digit = "2";
				 break;
		case Key_3 : digit = "3";
				 break;
		case Key_4 : digit = "4";
				 break;
		case Key_5 : digit = "5";
				 break;
		case Key_6 : digit = "6";
				 break;
		case Key_7 : digit = "7";
				 break;
		case Key_8 : digit = "8";
				 break;
		case Key_9 : digit = "9";
				 break;
		case Key_Backspace : digit = "Backspace";
				 break;
		
		// ignore any other key
		default : ev->ignore();
	}
	
	// if the event is accepted...
	
	if (ev->isAccepted())
	{	
		// raise the Faxnumber-Tab
		mainSelect->raiseTab(ID_TAB_FAXNUMBER);
		
		if (digit == "Backspace")
		{
			// remove last digit as long as there is at least one digit
			if ( faxNumber.length() > 0 )
			{
				faxNumber.truncate( (int)faxNumber.length() -1);
				// now set the actual faxnumber in the display
				faxNumberDisplay->setFaxNumber(faxNumber);
			}
		}
		else
		{
			// append the new "dialed" number
			faxNumber.append(digit);
			// now set the actual faxnumber in the display
			faxNumberDisplay->setFaxNumber(faxNumber);			
		}
	}
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////



void SendfaKsApp::slotCommandLine(const QString command){

	// command-line parameter is a faxnumber
	faxNumberDisplay->setFaxNumber(command);

}

void SendfaKsApp::slotListButtons(bool remove,bool moveUp,bool moveDown){

	// this callback-function enables/disables the faxList-buttons
	// according to the state of the faxList
	if ( remove )
	{
		enableCommand(ID_LIST_DELETE);
	}
	else
	{
		disableCommand(ID_LIST_DELETE);
	}
	
	if ( moveUp )
	{
		enableCommand(ID_LIST_UP);
	}
	else
	{
		disableCommand(ID_LIST_UP);
	}
	
	if ( moveDown )
	{
		enableCommand(ID_LIST_DOWN);
	}
	else
	{
		disableCommand(ID_LIST_DOWN);
	}
}

void SendfaKsApp::slotEnableSendPoll(int statList, int statNumber){

	// modify the attributes fileListHasItems faxNumberIsSet
	if (statList == 1)
		{ fileListHasItems = TRUE; }
	else if (statList == 0)
		{ fileListHasItems = FALSE;}
	else
		{/* do nothing on every other input*/}
	if (statNumber == 1)
		{ faxNumberIsSet = TRUE; }
	else if (statNumber == 0)
		{ faxNumberIsSet = FALSE;}
	else
	 	{/* do nothing on every other input*/}
	 			
	// this enables/disables the send/poll buttons
	if ( fileListHasItems && faxNumberIsSet )	 	
		{ enableCommand(ID_FAX_SEND); }
	else
		{ disableCommand(ID_FAX_SEND);}
	if ( !fileListHasItems && faxNumberIsSet )
		{ enableCommand(ID_FAX_POLL); }
	else
		{ disableCommand(ID_FAX_POLL); }
		
	//debug("listHasItems %i | numberIsSet %i",fileListHasItems,faxNumberIsSet);
}

void SendfaKsApp::slotProcessExit(KProcess *proc)
{
	// performs specific actions after the end of a KProcess according to the
	// sender of the Exit-Signal
	
	
	// after execution of procSendFax make this:
	if (this->sender() == procSendFax)
	{
		// remove the scratchfile if exists...
		this->removeCustomHeaderFile();		
		// get new faxserver-status automatically
		this->slotFaxStatus();
		// clear the number-Display
		faxNumberDisplay->clearFaxNumber();
	}

	// after execution of procPollFax make this:
	if (this->sender() == procPollFax)
	{
		// wait 1 second, so that the user can read the messages
		//sleep(1);
		// get new faxserver-status automatically
		this->slotFaxStatus();
		// clear the number-Display
		faxNumberDisplay->clearFaxNumber();
	}

	// after execution of procRemoveFax make this:
	if( this->sender() == procRemoveFax )
	{
		// wait 1 second, so that the user can read the messages
		//sleep(1);
		// get new faxserver-status automatically
		this->slotFaxStatus();
	}
	
	// after execution of procGetFileStatus make this:
	if( this->sender() == procGetFaxStatus )
	{	
		// enable/disable delete_job items, only if jobs exist is "Delete job" activated
		QString str = serverListBox->text(0);
		// "no jobs." is the standard output of faxq, when there are no jobs
		if( str == "no jobs.")
		{
			disableCommand(ID_FAX_DELETE);
			// remove selection if no jobs exist
			serverListBox->clearSelection();
		}
		else
		{
			enableCommand(ID_FAX_DELETE);
    	// highlight last entry
    	serverListBox->setSelected((serverListBox->count())-1, TRUE);
		}
		// raise the base FileListBox Widget to see the input
		mainSelect->raiseTab(ID_TAB_FAXSERVER);
	}
}

void SendfaKsApp::slotProcessOutput(KProcess *proc, char *buffer, int buflen)
{	
	// puts the stdout/stderr-output of the external processes on the apropriate ListBox-Widget,
	// detects newline characters and automatically forms listitems
	
	// local variables
	unsigned int i;				// counter
	unsigned int len;     // length of procMessage
	QString atom;					// a single character from procMessage
	QString line = "";		// a textline with the content of one listitem
	QString procMessage;	// message from the external process

	//debug("buflen = %i", buflen);
	// copy buffer
	procMessage = buffer;
	// truncate the string to show only useful information
	procMessage.truncate(buflen);	
	// reports the length of procMessage without the \0 terminator
	len = procMessage.length();
	
	// detection....
	for(i=0; i < len; i++)
	{
		//reads from procMessage the character at index i
		atom = procMessage.mid(i,1);
		
		// if atom is a newline character, append list to messageListBox and clear line
		if(atom == "\n")
		{	
			// direct the current line to the right ListBox
			// if procGetFaxStatus causes the stdout-output...
			if (this->sender() == procGetFaxStatus)
			{
				// append line to serverListBox
				serverListBox->insertItem(line,-1);
			}
			// if procRemoveFax, procSendFax or procPollFax causes the stdout-output...
			else
			{
				// append line to messageListBox
				messageListBox->insertItem(line,-1);
				messageListBox->setBottomItem(messageListBox->count());
			}
			
			// clear line
			line = line.truncate(0);
		}
		// append any other character in atom to line
		else
		{
			line += atom;
		}
	}
}



void SendfaKsApp::slotListOpen()
{
	slotStatusMsg(i18n("Opening file..."));
	
  QString fileToOpen=KFileDialog::getOpenFileName(QDir::homeDirPath(),i18n("*.ps *.PS *.tif *.TIF *.tiff *.TIFF"),
  this, i18n("Open File..."));

  if(!fileToOpen.isEmpty())
  {
    addRecentFile(fileToOpen);
		// raise the base FileListBox Widget to see the input
		mainSelect->raiseTab(ID_TAB_FILELIST);
    // append new filename to list
    fileListBox->appendNewEntry(fileToOpen);
  }

  slotStatusMsg(i18n("Welcome to sendfaKs!"));
}

void SendfaKsApp::slotFaxSend()
{
	// first check the options
	this->checkOptions();
	// then continue with sending...
	slotStatusMsg(i18n("Sending file..."));

	// raise the messageListBox Widget to see the faxspool-output
	mainSelect->raiseTab(ID_TAB_MESSAGES);	
	// clear faxspool args
	procSendFax->clearArguments();
	// first input on commandline: the program plus dial-number
	switch (userHeader)
	{
		case 0:
			// without a faxheader
			(*procSendFax) << "faxspool" << "-h" << "-" << (faxNumberDisplay->getFaxNumber());
			break;
	
		case 1:
			// with std-faxheader from     /etc/mgetty+sendfax/faxheader
			(*procSendFax) << "faxspool" << (faxNumberDisplay->getFaxNumber());
			break;
			
		case 2:
			// with user-defined faxheader
			(*procSendFax) << "faxspool" << "-h" << (createCustomHeaderFile()) << "-F" << (userName) << (faxNumberDisplay->getFaxNumber());
			break;
			
		default:
			debug("Error: impossible Faxheader Button pressed.");
			slotFaxQuit();
			break;
	}
	
	// then input on command line: the args
	int j = (int)fileListBox->count();
	for( int i=0; i < j; i++ )
	{
		// add its content to the command line queue
		(*procSendFax) << (fileListBox->text(i));
	}
	// now clear the fileList
	fileListBox->removeAll();
	// start the faxspool-process
	procSendFax->start(KProcess::NotifyOnExit, KProcess::AllOutput);	
			
	slotStatusMsg(i18n("Welcome to sendfaKs!"));
}

void SendfaKsApp::slotFaxPoll()
{
	slotStatusMsg(i18n("Polling file..."));

	// raise the messageListBox Widget to see the faxspool-output
	mainSelect->raiseTab(ID_TAB_MESSAGES);	
	// clear faxspool args
	procPollFax->clearArguments();
	// input on commandline: the program plus dial-number
	(*procPollFax) << "faxspool" << "-p" << (faxNumberDisplay->getFaxNumber());
	// start the faxspool-process
	procPollFax->start(KProcess::NotifyOnExit, KProcess::AllOutput);	
	
	slotStatusMsg(i18n("Welcome to sendfaKs!"));
}


void SendfaKsApp::slotFaxStatus()
{
	slotStatusMsg(i18n("Acquirering Faxdaemon Status..."));
	// clear ListBox
	serverListBox->clear();
	// clear all arguments of the faxq-command
	procGetFaxStatus->clearArguments();
	// shell-command and parameter for fax-status with verbose information
	(*procGetFaxStatus) << "faxq";
	// start external process
	procGetFaxStatus->start(KProcess::NotifyOnExit, KProcess::AllOutput);
	
	slotStatusMsg(i18n("Welcome to sendfaKs!"));
}


void SendfaKsApp::slotFaxDelete()
{
	slotStatusMsg(i18n("Deleting job..."));
	
	// get the selected job in serverListBox as a textline and truncate it
	// to 7 characters + \0
	// faxq-info-form:    Fxxxxxx/JOB: ...
	//                    ^^^^^^^
	//                    |||||||  <- This is the fax-id.
	
	// initiate str from the text of the highlighted entry in serverListBox and
	// limit the length to 7 characters + \0
	const char* test = serverListBox->text(serverListBox->currentItem());
	debug("test = %s",test);
	QString str(serverListBox->text(serverListBox->currentItem()),8);
	// raise the base messageListBox Widget to see the output
	mainSelect->raiseTab(ID_TAB_MESSAGES);	
	// clear argument list
	procGetFaxStatus->clearArguments();
	// shell-command and parameter
	(*procRemoveFax) << "faxrm" << (str);	
	// start external process
	procRemoveFax->start(KProcess::NotifyOnExit, KProcess::AllOutput);
			
	slotStatusMsg(i18n("Welcome to sendfaKs!"));
}

void SendfaKsApp::slotListOpenRecent(int id_)
{
  slotStatusMsg(i18n("Opening file..."));
	
  const char *filename = recentFiles.at(id_);
  	
	// raise the base FileListBox Widget to see the input
	mainSelect->raiseTab(ID_TAB_FILELIST);
  // append new filename to list
  fileListBox->appendNewEntry(filename);

  slotStatusMsg(i18n("Welcome to sendfaKs!"));
}


void SendfaKsApp::slotFaxQuit()
{
  slotStatusMsg(i18n("Exiting..."));
  saveOptions();
  // close the first window, the list makes the next one the first again.
  // This ensures that queryClose() is called on each window to ask for closing
  KTMainWindow* w;
  if(memberList)
  {
    for(w=memberList->first(); w!=0; w=memberList->first())
    {
      // only close the window if the closeEvent is accepted. If the user presses Cancel on the saveModified() dialog,
      // the window and the application stay open.
      if(!w->close())
	break;
    }
  }	
  slotStatusMsg(i18n("Welcome to sendfaKs!"));
}


void SendfaKsApp::slotSetupOptions()
{
	slotStatusMsg(i18n("Setting up..."));	
		
	// create new option-dialog that sets all the user options
	OptionDialog *optionDlg = new OptionDialog(0,"Options",TRUE);
	// shows the option dialog, stops the programm until the user is done with it
	optionDlg->show();
	// write back the config cache yet here
	config->sync();

	slotStatusMsg(i18n("Welcome to sendfaKs!"));
}


void SendfaKsApp::slotListDelete()
{
	slotStatusMsg(i18n("Deleting item..."));
	fileListBox->removeCurrentEntry();
	slotStatusMsg(i18n("Welcome to sendfaKs!"));
}

void SendfaKsApp::slotListUp()
{
	slotStatusMsg(i18n("Moving item..."));
	fileListBox->moveCurrentEntryUp();
	slotStatusMsg(i18n("Welcome to sendfaKs!"));
}

void SendfaKsApp::slotListDown()
{
	slotStatusMsg(i18n("Moving item..."));
	fileListBox->moveCurrentEntryDown();	
	slotStatusMsg(i18n("Welcome to sendfaKs!"));
}

void SendfaKsApp::slotViewToolBar()
{
  slotStatusMsg(i18n("Toggle the toolbar..."));
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  if( viewMenu->isItemChecked(ID_VIEW_TOOLBAR))
  {
    viewMenu->setItemChecked(ID_VIEW_TOOLBAR, false);
    enableToolBar(KToolBar::Hide);
  }
  else
  {
    viewMenu->setItemChecked(ID_VIEW_TOOLBAR, true);
    enableToolBar(KToolBar::Show);
  }		

  slotStatusMsg(i18n("Welcome to sendfaKs!"));
}

void SendfaKsApp::slotViewStatusBar()
{
  slotStatusMsg(i18n("Toggle the statusbar..."));
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  if( viewMenu->isItemChecked(ID_VIEW_STATUSBAR))
  {
    viewMenu->setItemChecked(ID_VIEW_STATUSBAR, false);
    enableStatusBar(KStatusBar::Hide);
  }
  else
  {
    viewMenu->setItemChecked(ID_VIEW_STATUSBAR, true);
    enableStatusBar(KStatusBar::Show);
  }

  slotStatusMsg(i18n("Welcome to sendfaKs!"));
}


void SendfaKsApp::slotStatusMsg(const QString &text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG);
}


void SendfaKsApp::slotStatusHelpMsg(const QString &text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}


//////////////////////////////////////////////////////////////////////////////////////////////////////////

void SendfaKsApp::commandCallback(int id_)
{	
  switch (id_)
  {
		case ID_FAX_SEND:
				 slotFaxSend();
				 break;
				
		case ID_FAX_POLL:
				 slotFaxPoll();
				 break;
				
		case ID_FAX_STATUS:
		     slotFaxStatus();
		     break;

		case ID_FAX_DELETE:
		     slotFaxDelete();
		     break;

	  case ID_FAX_QUIT:
         slotFaxQuit();
         break;

    case ID_LIST_OPEN:
         slotListOpen();
         break;

    case ID_LIST_DELETE:
    		 slotListDelete();
    		 break;

    case ID_LIST_UP:
    		 slotListUp();
    		 break;

    case ID_LIST_DOWN:
    		 slotListDown();
    		 break;
    		
    case ID_VIEW_TOOLBAR:
         slotViewToolBar();
         break;

    case ID_VIEW_STATUSBAR:
         slotViewStatusBar();
         break;
    		
    case ID_SETUP_OPTIONS:
         slotSetupOptions();
         break;
    		
    default:
         break;
  }
}


void SendfaKsApp::statusCallback(int id_)
{
  switch (id_)
  {

		case ID_FAX_SEND:
				 slotStatusHelpMsg(i18n("Sends the fax"));
				 break;

		case ID_FAX_POLL:
				 slotStatusHelpMsg(i18n("Polls a fax"));
				 break;

		case ID_FAX_STATUS:
				 slotStatusHelpMsg(i18n("Acquires the fax daemon status"));
				 break;

		case ID_FAX_DELETE:
				 slotStatusHelpMsg(i18n("Deletes a job"));
				 break;

    case ID_FAX_QUIT:
         slotStatusHelpMsg(i18n("Quits the application"));
         break;

    case ID_LIST_OPEN:
         slotStatusHelpMsg(i18n("Opens an existing file"));
         break;

    case ID_LIST_OPEN_RECENT:
         slotStatusHelpMsg(i18n("Opens a recently used file"));
         break;

		case ID_LIST_DELETE:
					slotStatusHelpMsg(i18n("Deletes an entry in the filelist"));
         break;

		case ID_LIST_UP:
					slotStatusHelpMsg(i18n("Moves an entry up"));
         break;

		case ID_LIST_DOWN:
					slotStatusHelpMsg(i18n("Moves an entry down"));
         break;

    case ID_VIEW_TOOLBAR:
         slotStatusHelpMsg(i18n("Enables/disables the toolbar"));
         break;

    case ID_VIEW_STATUSBAR:
         slotStatusHelpMsg(i18n("Enables/disables the statusbar"));
         break;

    case ID_SETUP_OPTIONS:
         slotStatusHelpMsg(i18n("Shows the options dialog"));
         break;

    default:
         break;
  }
}
