/***************************************************************************
                          kashdoc.h  -  description
                             -------------------
    begin                : Son Nov 21 15:23:42 CET 1999
    copyright            : (C) 1999 by Stephan Kahnt
    email                : stephan.kahnt@ipk.fhg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KASHDOC_H
#define KASHDOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for QT
#include <qobject.h>
#include <qstring.h>
#include <qlist.h>
#include <qdatetime.h>
#include <qstringlist.h> 

// application specific includes
#include "kashtransaction.h"

// forward declaration of the Kash classes
class KashView;
class KashAccount;

/**	KashDoc provides a document object for a document-view model.
  *
  * The KashDoc class provides a document object that can be used in conjunction with the classes KashApp and KashView
  * to create a document-view model for standard KDE applications based on KApplication and KTMainWindow. Thereby, the document object
  * is created by the KashApp instance and contains the document structure with the according methods for manipulation of the document
  * data by KashView objects. Also, KashDoc contains the methods for serialization of the document data from and to files.
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team. 	
  * @version KDevelop version 0.4 code generation
  */
class KashDoc : public QObject {
 Q_OBJECT
 public:
  /** Constructor for the fileclass of the application */
  KashDoc(QWidget *parent, const char *name=0);
  /** Destructor for the fileclass of the application */
  ~KashDoc();

  /** adds a view to the document which represents the document contents. Usually this is your main view. */
  void addView(KashView *view);
  /** removes a view from the list of currently connected views */
  void removeView(KashView *view);
  /** sets the modified flag for the document after a modifying action on the view connected to the document.*/
  void setModified( bool _m = true );
  /** returns if the document is modified or not. Use this to determine if your document needs saving by the user on closing.*/
  bool isModified(){ return modified; };
  /** "save modified" - asks the user for saving if the document is modified */
  bool saveModified();	
  /** deletes the document's contents */
  void deleteContents();
  /** initializes the document generally */
  bool newDocument();
  /** closes the acutal document */
  void closeDocument();
  /** loads the document by filename and format and emits the updateViews() signal */
  bool openDocument(const QString &filename, const char *format=0);
  /** saves the document under filename and format.*/	
  bool saveDocument(const QString &filename, const char *format=0);
  /** sets the path to the file connected with the document */
  void setAbsFilePath(const QString &filename);
  /** returns the pathname of the current document file*/
  const QString &getAbsFilePath() const;
  /** sets the filename of the document */
  void setTitle(const QString &_t);
  /** returns the title of the document */
  const QString &getTitle() const;
  
 public slots:
  /** calls repaint() on all views connected to the document object and is called by the view by which the document has been changed.
   * As this view normally repaints itself, it is excluded from the paintEvent.
   */
  void slotUpdateAllViews(KashView *sender);
 	
 public:	
  /** the list of the views currently connected to the document */
  static QList<KashView> *pViewList;	
 
  /** adds an account to the account list */
  void addAccount( const char* aName, const char* aType, 
		   const char* aNo = 0, const char* aDescr = 0 );
  
  /** remove an account form the acount list */
  void removeAccount( KashAccount* account );

  /** returns the active account */
  KashAccount* getActAccount() const;

  /** adds a transaction to the active account and returns an id
      for later identification */
  long addTransaction( StringVector& dataVec );  

  /** adds a transaction to the active account and returns an id
      for later identification */
  /*
  long addTransaction( const QDate& aDate, double amount, 
		       const char* aPayee = 0, const char* aCat = 0,
		       const char* aSubCat = 0, const char* aMemo  = 0,
		       const char* aNo = 0 );
  */
  /** updates a transaction of the acitive account and returns whether
      the update was succesfull or not */
  /*
  bool updateTransaction( long transId, const QDate& aDate, double amount, 
			  const char* aPayee, const char* aCat,
			  const char* aSubCat, const char* aMemo,
			  const char* aNo = 0 );
  */
  /** updates a transaction of the acitive account and returns whether
      the update was succesfull or not */
  bool updateTransaction( long transId, StringVector& dataVec );

  /** deletes a transaction of the acitive account and returns whether
      the process was succesfull or not */
  bool deleteTransaction( long transId );

 signals:
  void sigDelModel();

 private:
  /** the modified flag of the current document */
  bool modified;
  QString title;
  QString absFilePath;
  
  //** active account */
  KashAccount* account;
};

#endif // KASHDOC_H









