/***************************************************************************
                          kashtransaction.h  -  description
                             -------------------
    begin                : Sun Nov 21 1999
    copyright            : (C) 1999 by Stephan Kahnt
    email                : stephan.kahnt@ipk.fhg.de
 ***************************************************************************/

#ifndef KASHTRANSACTION_H
#define KASHTRANSACTION_H

// standard include
#include <vector.h>

// include files for Qt
#include <qstring.h>
#include <qdatetime.h>
#include <qtextstream.h> 
// #include <qstringlist.h>
// #include <qvector.h>
// #include <qarray.h>

// application specific includes
#include "resource.h"
/**
  *@author Stephan Kahnt
  */

typedef vector< QString > StringVector;

class KashTransaction {
 public: 
  KashTransaction();

  KashTransaction( StringVector& dataVec );
  
  ~KashTransaction();

  void setField( int idx, const char* aNo );

  void getTransaction( StringVector& dataVec );

  QString getField( int idx );

  friend bool operator >> ( QTextStream& s, KashTransaction& transaction );

  friend void operator << ( QTextStream& s, KashTransaction& transaction );

 private: // Private attributes
  /** the number of the account */
  QString number;
  /** the payee/reciever of the transaction  */
  QString payee;
  /** the category of the transaction */
  QString category;
  /** the sub category of the transaction */
  QString subCategory;
  /** the date of the transaction */
  QDate date;
  /** the amount of the transaction */
  double amount;
  /** the description of the transaction */
  QString memo;
  /** the state of the transaction */
  QString state;
};

#endif






