/* Copyright (C) 1999 Claus Wilke <claus.wilke@gmx.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qsplitter.h>
#include <qlayout.h>
#include <qtextview.h>
#include <qdom.h>
#include <kmessagebox.h>
#include <klocale.h>

#include <stdio.h>

#include "bibentrydialog.h"
#include "kbibliodoc.h"
#include "kbiblioshell.h"
#include "kbibliomainview.h"
#include "bibentrylistview.h"
#include "newentrydialog.h"
#include "entrymanipulator.h"




KBiblioMainView::KBiblioMainView( KBiblioShell *shell, QWidget *parent, const char *name )
    : QSplitter( Qt::Vertical, parent, name )
{
    mListView = 0;
    mEntryView = 0;

    mShell = shell;
    setup();
    connect( mShell, SIGNAL( newDocument() ), this, SLOT( newDocument() ) );

}


KBiblioMainView::~KBiblioMainView()
{
}


void
KBiblioMainView::setup()
{
    mDocument = mShell->document();

    mListView = new BibEntryListView( mShell, mDocument->entryListNode(), this );
    setResizeMode( mListView, QSplitter::KeepSize );

    mEntryView = new QTextView( this );
    //  mEntryView->setAlignment( Qt::AlignTop );
    mEntryView->setBackgroundMode( PaletteBase );

    connect( mListView, SIGNAL( doubleClicked( QListViewItem * ) ), SLOT( editSelected() ) );
    connect( mListView, SIGNAL( selectionChanged( QListViewItem* ) ), SLOT( displaySelected( QListViewItem* ) ) );

    displaySelected( mListView->currentItem() );
}


void
KBiblioMainView::newDocument()
{
    mDocument = mShell->document();
    mListView->newDocument( mDocument->entryListNode() );
}


void
KBiblioMainView::newEntry()
{
    NewEntryDialog *ned = new NewEntryDialog( mShell, 0 );
    ned->exec();
    if ( ned->result() == QDialog::Accepted ){
	QString entryType = ned->chosenType();
	if ( entryType != "" ){
	    QDomElement entry = mDocument->domDocument().createElement( entryType );
	    BibEntryDialog *ed = new BibEntryDialog ( entry, mShell, 0 );
	    ed->exec();
	    if ( ed->result() == QDialog::Accepted ){
		mDocument->addEntry( entry );
		mListView->add( entry );
	    }
	    delete ed;
	}
    }
    delete ned;
}

void
KBiblioMainView::copySelected()
{
    if ( KMessageBox::Cancel == KMessageBox::warningContinueCancel( 0, QString( i18n( "This doesn't work properly yet due to a bug in QDom.\n Proceed anyway?" ) ), "", i18n( "&Proceed" ) ) )
	return;

    BibEntryListViewItem *item;
    QDomElement entry, newEntry;

    item = ( BibEntryListViewItem* ) mListView->currentItem ();
    if ( 0 == item )
	printf("KBiblioMainView::editEntry: No entry selected!\n");
    else{
	printf("KBiblioMainView::copyEntry: Copying does not work correctly yet!\n  I think this is related to an error in QDom.\n");
	entry = item->entry();
	newEntry = entry.cloneNode( true ).toElement();
	mDocument->addEntry( newEntry );
	mListView->add( newEntry );
    }
}

void
KBiblioMainView::editSelected()
{
    BibEntryListViewItem *item;
    QDomElement entry;
    BibEntryDialog *ed = 0;

    item = ( BibEntryListViewItem* ) mListView->currentItem ();
    if ( 0 == item )
	printf("KBiblioMainView::editEntry: No entry selected!\n");
    else{
	entry = item->entry();
	ed = new BibEntryDialog ( entry, mShell, 0 );
	ed->exec();
	if ( ( ed->result() == QDialog::Accepted ) && ( ed->edited() ) ){
	    mListView->update( entry );
	    mDocument->setEdited( true );
	}
	delete ed;
    }
}


void
KBiblioMainView::deleteSelected()
{
    BibEntryListViewItem *item;
    QDomElement entry;

    item = ( BibEntryListViewItem* ) mListView->currentItem ();

    if ( 0 == item ){
	printf("KBiblioMainView::changeEntry: No entry selected!\n");
    }
    else{
	entry = item->entry();
	mListView->remove( item );
	mDocument->removeEntry( entry );
    }
}


void
KBiblioMainView::setSelected( QDomElement entry )
{
    BibEntryListViewItem* item = mListView->findItem( entry );
    
    if ( item != 0 )
	mListView->setSelected( item, true );

}

void
KBiblioMainView::displaySelected( QListViewItem* item )
{
    if ( !item )
	mEntryView->setText( "" );
    else{
	BibEntryListViewItem *castedItem = ( BibEntryListViewItem* ) item;
	QDomElement entry = castedItem->entry();
	
	EntryManipulator manip( entry, mShell );
	
	mEntryView->setText( manip.richDisplayText() );
    }
}


#include "kbibliomainview.moc"






