/* Copyright (C) 1999 Claus Wilke <claus.wilke@gmx.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <kdialogbase.h>
#include <klocale.h>

#include <kbiblioshell.h>
#include <kbibliodoc.h>
#include <prefdialog.h>


EditableChooser::EditableChooser( KBiblioShell *shell, QWidget *parent, const char *name )
    :  QButtonGroup ( 3, Qt::Horizontal, i18n( "Allow editing of fields whenever applicable" ), parent, name )
{
    mShell = shell;

    mFieldNames = mShell->document()->allFieldTypesNames();
    QStringList::Iterator it = mFieldNames.begin();	

    QCheckBox *button;
    QString descr;

    for ( ; it != mFieldNames.end(); ++it ) {
	descr = mShell->fieldDescription( *it );
	button = new QCheckBox ( descr, this );
	button->setChecked( mShell->fieldIsEditable( *it ) );	
    }		
    setMinimumSize( sizeHint() );
}


EditableChooser::~EditableChooser()
{
}


void
EditableChooser::saveChoices()
{
    QStringList::Iterator it = mFieldNames.begin();	
    int button = 0;
    for ( ; it != mFieldNames.end(); ++it ) {
	mShell->setFieldEditable( *it, ( ( QCheckBox* ) find( button ) )->isChecked() );
	button += 1;
    }
}


ViewableChooser::ViewableChooser( KBiblioShell *shell, QWidget *parent, const char *name )
    :  QButtonGroup ( 3, Qt::Horizontal, i18n( "This is not yet implemented" ), parent, name )
{
    QStringList fieldNames = shell->document()->allFieldTypesNames();
    QStringList::Iterator it = fieldNames.begin();	

    QCheckBox *button;
    QString descr;

    for ( ; it != fieldNames.end(); ++it ) {
	descr = shell->fieldDescription( *it );
	button = new QCheckBox ( descr, this );
	button->setChecked( shell->fieldIsViewable( *it ) );	
    }		

    setMinimumSize( sizeHint() );
}


ViewableChooser::~ViewableChooser()
{
}


PreferencesDialog::PreferencesDialog( KBiblioShell *shell, QWidget *parent, const char *name )
    :  KDialogBase( KDialogBase::Tabbed, i18n( "Preferences" ),
		    KDialogBase::Ok | KDialogBase::Cancel | KDialogBase::Apply,
		    KDialogBase::Ok, parent, name, false, false )
{
    QFrame *tab1 = addPage( i18n( "Editable Fields" ) );
    QFrame *tab2 = addPage( i18n( "Viewable Fields" ) );

    mEditableTab = new EditableChooser( shell, tab1 );
    tab1->setMinimumSize( mEditableTab->sizeHint() );
    mViewableTab = new ViewableChooser( shell, tab2 );
    tab2->setMinimumSize( mViewableTab->sizeHint() );

}

PreferencesDialog::~PreferencesDialog()
{
}



void
PreferencesDialog::slotOk()
{
    mEditableTab->saveChoices();
    accept();
}


void
PreferencesDialog::slotApply()
{
    mEditableTab->saveChoices();
}

#include "prefdialog.moc"




