// -*- C++ -*-
/* This file is part of
* ======================================================
* 
*           LyX, the High Level Word Processor
*        
*           Copyright (C) 1995 1996 Matthias Ettrich
*           and the LyX Team.
*
*======================================================*/

#ifndef _BUFFER_VIEW_H
#define _BUFFER_VIEW_H

#include <X11/Xlib.h>

class LyXView;
class Buffer;
class LyXScreen;
class BackStack;
class FontLoader;
class MiniBuffer;
class K_Canvas;
class QWidget;

///
class BufferView {
public:
	///
	BufferView(LyXView *owner, QWidget* parent);
        ///
        ~BufferView();
	///
	Buffer *currentBuffer() { return _buffer; }
	///
 	/// Same as setBuffer but takes care of the locking inset.
 	void switchBuffer(Buffer *);
  	///
 	void setBuffer(Buffer *b);
	///
	void resize();
	///
	void screenSettingsChanged();
	///
	void redraw();
	///
	void fitCursor();
	///
	void update();
	///
	void updateScrollbar();
	///
	void redoCurrentBuffer();
	///
	int resizeCurrentBuffer();
	///
	void gotoError();
	///
	void cursorPrevious();
	///
	void cursorNext();
	/// 
	bool available() const;
	///
	LyXView *getOwner() { return _owner; }
	///
	LyXScreen *getScreen() { return screen; }
        ///
        void savePosition();
        ///
        void restorePosition();

        /// A few callbacks for klyx
        void kScrollCB(int);
        int kButtonPress(int x, int y, int b);
        int kButtonRelease(int x, int y, int b);
        int kMouseMove(int x, int y);
        int kButtonDoubleClick(int x, int y, int b);
        void kCursorToggleCB(); 
        void kHideCursor(); 
        void kKeyPress(XEvent *ev);
        FontLoader* getFontloader();
        MiniBuffer* getMiniBuffer();
        K_Canvas* getKCanvas(){return k_canvas;}
        int getHeight();
        void startUpdateTimer(float timer);
        void stopUpdateTimer();
	void updateTimerTimeout();
	void setBufferInternal(Buffer *b, bool do_resize = false, long first_arg = -1);
	void PasteSelection(bool asParagraph);

private:
	/// Update pixmap of screen
	void updateScreen();
	///
	void create_view(int, int, int, int);
	///
	bool checkInsetHit(int &x, int &y);
	/// 
	LyXView *_owner;
	///
	K_Canvas *k_canvas;
	///
	Buffer *_buffer;
	///
	LyXScreen *screen;
	///
	long current_scrollbar_value;
	///
	int work_area_width;
	///
	bool lyx_focus;
	///
	bool work_area_focus;
        ///
        BackStack *backstack;
};

#endif
