// This file is part of KLyX, The Document Processor
//
// Copyright (C) 1995 Matthias Ettrich
// Copyright (C) 1997-1999 KLyX Team

#include "InsertBibitemDialog.h"
#include "LyXView.h"
#include "BufferView.h"
#include "insetcommand.h"

#include <qlabel.h>
#include <qlayout.h>
#include <qlined.h>
#include <qpushbt.h>

#include <kapp.h>
#include <kbuttonbox.h>
#include <klocale.h>


InsertBibitemDialog::InsertBibitemDialog( LyXView* view, QWidget * parent=0, 
					  const char * name=0, WFlags f=0 )
    : QDialog( parent, name, true, f ),
      _view( view )
{
    setCaption( i18n( "BibTeX" ) );
    QGridLayout *layout = new QGridLayout( this, 3, 2, 10 );

    firstLA = new QLabel( i18n( "Key:" ), this );
    firstLA->setAlignment( AlignVCenter | AlignRight );
    firstLA->setMinimumSize( firstLA->sizeHint() );
    layout->addWidget( firstLA, 0, 0, AlignRight );
    firstED = new QLineEdit( this );
    firstED->setFixedHeight( firstED->sizeHint().height() ); 
    firstED->setMinimumWidth( firstED->sizeHint().height() > 80 ? firstED->sizeHint().height() : 80 ); 
    layout->addWidget( firstED, 0, 1, AlignRight );

    secondLA = new QLabel( i18n( "Label:" ), this );
    secondLA->setAlignment( AlignVCenter | AlignRight );
    secondLA->setMinimumSize( secondLA->sizeHint() );
    layout->addWidget( secondLA, 1, 0, AlignRight );
    secondED = new QLineEdit( this );
    secondED->setFixedHeight( secondED->sizeHint().height() ); 
    secondED->setMinimumWidth( secondED->sizeHint().height() > 80 ? secondED->sizeHint().height() : 80 ); 
    layout->addWidget( secondED, 1, 1, AlignRight );

    KButtonBox *bbox = new KButtonBox( this );
    bbox->addStretch( 1 );
    QPushButton* okPB = bbox->addButton( i18n( "OK" ) );
    okPB->setMinimumSize( okPB->sizeHint() );
    okPB->setDefault( true );
    connect( okPB, SIGNAL( clicked() ), SLOT( okClicked() ) );
    bbox->addStretch( 1 );
    QPushButton* cancelPB = bbox->addButton( i18n( "Cancel" ) );
    cancelPB->setMinimumSize( cancelPB->sizeHint() );
    connect( cancelPB, SIGNAL( clicked() ), SLOT( reject() ) );
    bbox->addStretch( 1 );
    bbox->layout();
    layout->addMultiCellWidget( bbox, 2, 2, 0, 1 );

    layout->activate();
    setMinimumWidth( bbox->sizeHint().width() + 20 );
    resize( sizeHint() );
    return;
}



void InsertBibitemDialog::okClicked()
{
    if( ! _view->currentBuffer()->isReadonly() ) {
	inset->setContents( firstED->text() );
	inset->setOptions( secondED->text() );
	// Does look like a hack? It is! (but will change at 0.13)
	_view->currentBuffer()->text->RedoParagraph();
	_view->currentBuffer()->updateFull();
    }
    accept();
    return;
}



void InsertBibitemDialog::setFirstLabel( const char* newtext )
{
    firstLA->setText( newtext );
    firstLA->setMinimumSize( firstLA->sizeHint() );
    return;
}



void InsertBibitemDialog::setSecondLabel( const char* newtext )
{
    secondLA->setText( newtext );
    secondLA->setMinimumSize( secondLA->sizeHint() );
    return;
}



void InsertBibitemDialog::setFirstEdit( const char* newtext )
{
    firstED->setText( newtext );
    return;
}



void InsertBibitemDialog::setSecondEdit( const char* newtext )
{
    secondED->setText( newtext );
    return;
}


// Local Variables:
// mode: C++
// c-file-style: "Stroustrup"
// End:
