// This file is part of KLyX, The Document Processor
//
// Copyright (C) 1995 Matthias Ettrich
// Copyright (C) 1997-1999 KLyX Team

#ifndef _INSERTCITATIONREFERENCEDIALOG_H
#define _INSERTCITATIONREFERENCEDIALOG_H


#include <qdialog.h>

#include <map>
#include <set>
#include <string>

class InsetCommand;
class LyXView;
class QComboBox;
class QLineEdit;



class InsertCitationReferenceDialog : public QDialog
{
    Q_OBJECT

public:

    InsertCitationReferenceDialog ( LyXView *view, QWidget *parent=0, 
				    const char *name=0, WFlags f=0 );

    void setInset( InsetCommand *inset ) { _inset = inset; }

    void updateBibItems();

    /**
     * Make item the current item or insert it if it does not yet exist.
     */
    void ensureBibItem( const char *item );

    /**
     * Make remark the current remark.
     */
    void setRemark( const char *remark );

    
protected slots:

    /**
     * Empty the databases and keys container.
     */
    void cancelClicked();

    /**
     * New databse selected, update keyCB.
     */
    void newDatabase( const char * );

    /**
     * Change the current insets content.
     * Empty the databases and keys container.
     */
    void okClicked();

    
protected:

    LyXView       *_view;
    InsetCommand  *_inset;

    map< string, set< string > >  keys;
    
    QComboBox  *dbCB,  *keyCB;
    QLineEdit  *remarkED;
};



#endif


// Local Variables:
// mode: C++
// c-file-style: "Stroustrup"
// End:
