/*
 * $Id: InsertIncludeDialog.h,v 1.2 1998/03/02 21:13:43 kalle Exp $
 */

#ifndef _INSERTINCLUDEDIALOG_H
#define _INSERTINCLUDEDIALOG_H

#include <qdialog.h>

class QCheckBox;
class QLineEdit;
class QRadioButton;

class LyXView;
class InsetInclude;

class InsertIncludeDialog : public QDialog
{
friend class InsetInclude;

  Q_OBJECT

public:
  InsertIncludeDialog ( LyXView* view, QWidget * parent=0, 
						const char * name=0, WFlags f=0 );

  void setInset( InsetInclude* _inset ) { inset = _inset; }

private slots:
  void okClicked();
  void cancelClicked();
  void browseClicked();
  void loadClicked();
  void styleGroupClicked( int );

private:
  LyXView* _view;
  InsetInclude* inset;

  QLineEdit* filenameED;

  QRadioButton* includeRB;
  QRadioButton* inputRB;
  QRadioButton* verbatimRB;

  QCheckBox* donttypesetCB;
  QCheckBox* visiblespaceCB;
};

#endif

/*
 * $Log: InsertIncludeDialog.h,v $
 * Revision 1.2  1998/03/02 21:13:43  kalle
 * Kalle: Started to make dialogs more Qt-like
 *
 * Revision 1.1  1998/02/11 09:15:02  kalle
 * - added InsertBibitemDialog
 * - added InertIncludeDialog
 *
 */
