/* -*- mode: C++; c-file-style: "Stroustrup" -*-
 *
 * $Id: InsertLabelDialog.C,v 1.6 1999/01/28 10:14:00 kuepper Exp $
 */

#include <qlabel.h>
#include <qlayout.h>
#include <qlined.h>
#include <qpushbt.h>

#include <kapp.h>
#include <kbuttonbox.h>

#include "InsertLabelDialog.h"


InsertLabelDialog::InsertLabelDialog( QWidget * parent=0, const char * name=0, WFlags f=0 )
    : QDialog( parent, name, true, f )
{
    setCaption( i18n( "Insert Label" ) );
    QVBoxLayout *layout = new QVBoxLayout( this, 10 );

    QLabel* label = new QLabel( i18n( "Enter new label to insert:" ), this );
    label->setMinimumSize( label->sizeHint() );
    layout->addWidget( label );
    edit = new QLineEdit( this );
    edit->setFixedHeight( edit->sizeHint().height() );
    layout->addWidget( edit );
    layout->addSpacing( 5 );

    KButtonBox *bbox = new KButtonBox( this );
    bbox->addStretch( 5 );
    QPushButton* okPB = bbox->addButton( i18n( "OK" ) );
    okPB->setDefault( true );
    connect( okPB, SIGNAL( clicked() ), SLOT( accept() ) );
    bbox->addStretch( 10 );
    QPushButton* cancelPB = bbox->addButton( i18n( "Cancel" ) );
    connect( cancelPB, SIGNAL( clicked() ), SLOT( reject() ) );
    bbox->addStretch( 10 );
    QPushButton* clearPB = bbox->addButton( i18n( "Clear" ) );
    connect( clearPB, SIGNAL( clicked() ), SLOT( clearClicked() ) );
    bbox->addStretch( 5 );
    bbox->layout();
    layout->addWidget( bbox );
    layout->activate();
    resize( sizeHint() );
}



void InsertLabelDialog::clearClicked()
{
    edit->setText( "" );
}



QString InsertLabelDialog::getLabel() const
{
    return edit->text();
}



void InsertLabelDialog::setFocus()
{
    edit->setFocus();
}



void InsertLabelDialog::setLabel( const QString& text )
{
    edit->setText( text );
}
