/*
 * $Id: PaperFormatDialog.h,v 1.2 1998/03/04 21:49:34 kalle Exp $
 */

#ifndef _PAPERFORMATDIALOG_H
#define _PAPERFORMATDIALOG_H

#include <qdialog.h>

class QCheckBox;
class QComboBox;
class QLabel;
class QLineEdit;
class QPushButton;
class QRadioButton;

class LyXView;

class PaperFormatDialog : public QDialog
{
friend void MenuLayoutPaper();

  Q_OBJECT

public:
	PaperFormatDialog ( LyXView* view, QWidget * parent=0, 
						const char * name=0, WFlags f=0 );

  void checkMarginValues();
  void activate();
  void deactivate();
  void enable();
  void disable();

private slots:
  void okClicked();
  void cancelClicked();
  void papersizeSelected( int );
  void specialSelected( int );
  void widthReturn();
  void heightReturn();
  void leftReturn();
  void rightReturn();
  void topReturn();
  void bottomReturn();
  void headheightReturn();
  void headsepReturn();
  void footskipReturn();

private:
  LyXView* _view;

  QComboBox* papersizeCO;
  QComboBox* specialCO;

  QCheckBox* geometrypackageCB;

  QRadioButton* portraitRB;
  QRadioButton* landscapeRB;

  QLineEdit* topED;
  QLineEdit* bottomED;
  QLineEdit* leftED;
  QLineEdit* rightED;
  
  QLineEdit* widthED;
  QLineEdit* heightED;

  QLineEdit* headheightED;
  QLineEdit* headsepED;
  QLineEdit* footskipED;

  QLabel* warningLA;
  
  QPushButton* okPB;
};

#endif

/*
 * $Log: PaperFormatDialog.h,v $
 * Revision 1.2  1998/03/04 21:49:34  kalle
 * More Qt-ified
 *
 * Revision 1.1  1998/02/09 22:26:23  kalle
 *  - added PaperFormatDialog
 * - added QuotesDialog
 *
 */
