#include <config.h>

#include <kapp.h>
#include <klocale.h>
#include <qchkbox.h>
#include <qradiobt.h>

#include <stdlib.h>
#include "definitions.h"
#include "lyx_main.h"
#include "lyxrc.h"
#include "LString.h"
#include "filetools.h"
#include "buffer.h"
#include "minibuffer.h"
#include "vspace.h"
#include "lyx_gui_misc.h"
#include "BufferView.h"
#include "PaperFormatDialog.h"
#include "LyXView.h"

// 	$Id: PaperLayout.C,v 1.4 1999/01/05 11:16:45 kulow Exp $	

#if !defined(lint) && !defined(WITH_WARNINGS)
static char vcid[] = "$Id: PaperLayout.C,v 1.4 1999/01/05 11:16:45 kulow Exp $";
#endif /* lint */

/* Prototypes */
extern BufferView *current_view;

void MenuLayoutPaper()
{
  if (!current_view->available())
	return;

  BufferParams * params = &current_view->currentBuffer()->params;

  if( !klyxdialogs->paper )
	klyxdialogs->paper = new PaperFormatDialog( current_view->getOwner() );

  klyxdialogs->paper->papersizeCO->setCurrentItem( params->papersize2 );
  klyxdialogs->paper->specialCO->setCurrentItem( params->paperpackage );
  klyxdialogs->paper->geometrypackageCB->setChecked( params->use_geometry );
  if( params->orientation == ORIENTATION_LANDSCAPE )
	klyxdialogs->paper->landscapeRB->setChecked( true );
  else
	klyxdialogs->paper->portraitRB->setChecked( true );
  klyxdialogs->paper->widthED->setText( params->paperwidth.c_str() );
  klyxdialogs->paper->heightED->setText( params->paperheight.c_str() );
  klyxdialogs->paper->topED->setText( params->topmargin.c_str() );
  klyxdialogs->paper->bottomED->setText( params->bottommargin.c_str() );
  klyxdialogs->paper->leftED->setText( params->leftmargin.c_str() );
  klyxdialogs->paper->rightED->setText( params->rightmargin.c_str() );
  klyxdialogs->paper->headheightED->setText( params->headheight.c_str() );
  klyxdialogs->paper->headsepED->setText( params->headsep.c_str() );
  klyxdialogs->paper->footskipED->setText( params->footskip.c_str() );
  klyxdialogs->paper->warningLA->hide();
  if( current_view->currentBuffer()->isReadonly() ) {
	klyxdialogs->paper->disable();
	klyxdialogs->paper->warningLA->setText( i18n("Document is read-only.  No changes to layout permitted.") );
	klyxdialogs->paper->warningLA->show();
  }
  else
	klyxdialogs->paper->enable();
      
  (void)klyxdialogs->paper->exec();
}

