/* -*- mode: C++; c-file-style: "Stroustrup" -*-
 *
 * This file is part of KLyX, the High Level Word Processor
 *
 * Copyright (C) 1997-1999 Matthias Ettrich and the KLyX Team
 */


#include <qcombo.h>
#include <qlabel.h>
#include <qgrpbox.h>

#include <kapp.h>

#include "ScreenToolbarsDialog.h"


ScreenToolbarsDialog::ScreenToolbarsDialog ( QWidget * parent=0, const char * name=0, WFlags f=0 )
    : QWidget( parent, name, f )
{
//  QGroupBox* toolbarsGB = new QGroupBox( i18n( "Toolbars" ), this );
//  toolbarsGB->setGeometry( 10, 10, 210, 190 );

  QLabel* generalLA = new QLabel( i18n( "General" ), this );
  generalLA->setGeometry( 10, 10, 70, 30 );
  generalLA->setAlignment( AlignRight | AlignVCenter );

  generalCB = new QComboBox( false, this );
  generalCB->setGeometry( 90, 10, 120, 30 );
  generalCB->insertItem( i18n( "Always visible" ) );
  generalCB->insertItem( i18n( "Never visible" ) );
//   generalCB->insertItem( i18n( "Automatic" ) );

  QLabel* mathLA = new QLabel( i18n( "Math" ), this );
  mathLA->setGeometry( 10, 50, 70, 30 );
  mathLA->setAlignment( AlignRight | AlignVCenter );

  mathCB = new QComboBox( false, this );
  mathCB->setGeometry( 90, 50, 120, 30 );
  mathCB->insertItem( i18n( "Always visible" ) );
  mathCB->insertItem( i18n( "Never visible" ) );
  mathCB->insertItem( i18n( "Automatic" ) );

  QLabel* tablesLA = new QLabel( i18n( "Tables" ), this );
  tablesLA->setGeometry( 10, 90, 70, 30 );
  tablesLA->setAlignment( AlignRight | AlignVCenter );

  tablesCB = new QComboBox( false, this );
  tablesCB->setGeometry( 90, 90, 120, 30 );
  tablesCB->insertItem( i18n( "Always visible" ) );
  tablesCB->insertItem( i18n( "Never visible" ) );
  tablesCB->insertItem( i18n( "Automatic" ) );

  QLabel* characterLA = new QLabel( i18n( "Character" ), this );
  characterLA->setGeometry( 10, 130, 70, 30 );
  characterLA->setAlignment( AlignRight | AlignVCenter );

  characterCB = new QComboBox( false, this );
  characterCB->setGeometry( 90, 130, 120, 30 );
  characterCB->insertItem( i18n( "Always visible" ) );
  characterCB->insertItem( i18n( "Never visible" ) );
//   characterCB->insertItem( i18n( "Automatic" ) );
  characterCB->setCurrentItem( ScreenToolbarsDialog::NEVER_VISIBLE );

}


void ScreenToolbarsDialog::setData( ScreenToolbarsDialogData* _data )
{
    generalCB->setCurrentItem( _data->general_toolbar );
    mathCB->setCurrentItem( _data->math_toolbar );
    tablesCB->setCurrentItem( _data->tables_toolbar );
    characterCB->setCurrentItem( _data->character_toolbar );
}


static ScreenToolbarsDialogData tempdata;

ScreenToolbarsDialogData* ScreenToolbarsDialog::data() const
{
    tempdata.general_toolbar = static_cast< Visibility >( generalCB->currentItem() );
    tempdata.math_toolbar = static_cast< Visibility >( mathCB->currentItem() );
    tempdata.tables_toolbar = static_cast< Visibility >( tablesCB->currentItem() );
    tempdata.character_toolbar = static_cast< Visibility >( characterCB->currentItem() );

  return &tempdata;
}

