/*
 * $Id: SpellcheckerOptionsDialog.C,v 1.6 1999/01/05 11:16:54 kulow Exp $
 */

#include "SpellcheckerOptionsDialog.h"

#include <kapp.h>
#include <klocale.h>

#include <qbttngrp.h>
#include <qchkbox.h>
#include <qlined.h>
#include <qpushbt.h>
#include <qradiobt.h>

SpellcheckerOptionsDialog::SpellcheckerOptionsDialog( QWidget * parent=0, 
													  const char * name=0, 
													  WFlags f=0 ) :
  QDialog( parent, name, true, f )
{
  QButtonGroup* dictionaryBG = new QButtonGroup( i18n( "Dictionary" ), this );
  dictionaryBG->setGeometry( 10, 10, 320, 130 );

  usedocumentlanguageRB = new QRadioButton( i18n( "Use language of &document" ), this );
  dictionaryBG->insert( usedocumentlanguageRB );
  usedocumentlanguageRB->setGeometry( 20, 30, 180, 30 );

  usealternatelanguageRB = new QRadioButton( i18n( "&Use alternate language" ), this );
  dictionaryBG->insert( usealternatelanguageRB );
  usealternatelanguageRB->setGeometry( 20, 70, 160, 30 );

  alternatelanguageED = new QLineEdit( this );
  alternatelanguageED->setGeometry( 40, 100, 270, 30 );
  QObject::connect( usealternatelanguageRB, SIGNAL( toggled( bool ) ),
					alternatelanguageED, SLOT( setEnabled( bool ) ) );

  QButtonGroup* optionsBG = new QButtonGroup( i18n( "Options" ), 
											  this );
  optionsBG->setGeometry( 10, 160, 320, 250 );

  runtogetherlegalCB = new QCheckBox( i18n( "&Treat run-together words as legal" ), this );
  runtogetherlegalCB->setGeometry( 20, 180, 260, 30 );

  inputencodingswitchCB = new QCheckBox( i18n( "&Input Encoding xswitch to ispell" ), this );
  inputencodingswitchCB->setGeometry( 20, 220, 260, 30 );

  alternatedictCB = new QCheckBox( i18n( "Use alternate &personal dictionary:" ), this );
  alternatedictCB->setGeometry( 20, 260, 260, 30 );

  alternatedictED = new QLineEdit( this );
  alternatedictED->setGeometry( 40, 290, 270, 30 );
  QObject::connect( alternatedictCB, SIGNAL( toggled( bool ) ),
					alternatedictED, SLOT( setEnabled( bool ) ) );

  extraspecialcharsCB = new QCheckBox( i18n( "&Extra special chars allowed in words" ), this );
  extraspecialcharsCB->setGeometry( 20, 340, 270, 30 );

  extraspecialcharsED = new QLineEdit( this );
  extraspecialcharsED->setGeometry( 40, 370, 270, 30 );
  connect( extraspecialcharsCB, SIGNAL( toggled( bool ) ),
		   extraspecialcharsED, SLOT( setEnabled( bool ) ) );

  QPushButton* okPB = new QPushButton( i18n( "OK" ), this );
  okPB->setGeometry( 10, 420, 100, 30 );
  okPB->setDefault( true );
  connect( okPB, SIGNAL( clicked() ), SLOT( accept() ) );

  QPushButton* cancelPB = new QPushButton( i18n( "Cancel" ), 
										   this );
  cancelPB->setGeometry( 220, 420, 100, 30 );
  connect( cancelPB, SIGNAL( clicked() ), SLOT( reject() ) );
}


void SpellcheckerOptionsDialog::setData( SpellcheckerOptionsDialogData* data )
{
  switch( data->dictionary )
	{
	case SpellcheckerOptionsDialogData::Document:
	  usedocumentlanguageRB->setChecked( true );
	  usealternatelanguageRB->setChecked( false );
	  alternatelanguageED->setEnabled( false );
	  break;
	case SpellcheckerOptionsDialogData::Alternate:
	  usealternatelanguageRB->setChecked( true );
	  usedocumentlanguageRB->setChecked( false );
	  alternatelanguageED->setEnabled( true );
	  break;
	default:
	  lyxerr_debug( "Unknown enum for SpellcheckerOptionsDialogData::Dictionary" );
	};

  alternatelanguageED->setText( data->alternate_language );
  runtogetherlegalCB->setChecked( data->runtogether_words_legal );
  inputencodingswitchCB->setChecked( data->input_encoding_ispell );
  alternatedictCB->setChecked( data->use_alternate_personal_dictionary );
  alternatedictED->setEnabled( data->use_alternate_personal_dictionary );
  alternatedictED->setText( data->alternate_personal_dictionary );
  extraspecialcharsCB->setChecked( data->allow_extra_special_chars );
  extraspecialcharsED->setEnabled( data->allow_extra_special_chars );
  extraspecialcharsED->setText( data->extra_special_chars_allowed );
}


static SpellcheckerOptionsDialogData tempdata;

SpellcheckerOptionsDialogData* SpellcheckerOptionsDialog::data() const
{
  if( usedocumentlanguageRB->isChecked() )
	tempdata.dictionary = SpellcheckerOptionsDialogData::Document;
  else if( usedocumentlanguageRB->isChecked() )
	tempdata.dictionary = SpellcheckerOptionsDialogData::Alternate;
  else
	lyxerr_debug( "Cannot determine value for SpellcheckerOptionsDialogData::dictionary" );

  tempdata.alternate_language = alternatelanguageED->text();
  tempdata.runtogether_words_legal = runtogetherlegalCB->isChecked();
  tempdata.input_encoding_ispell = inputencodingswitchCB->isChecked();
  tempdata.use_alternate_personal_dictionary = alternatedictCB->isChecked();
  tempdata.alternate_personal_dictionary = alternatedictED->text();
  tempdata.allow_extra_special_chars = extraspecialcharsCB->isChecked();
  tempdata.extra_special_chars_allowed = extraspecialcharsED->text();

  return &tempdata;
}


void SpellcheckerOptionsDialog::setFocusAlternateLanguage()
{
  alternatelanguageED->setFocus();
}


/*
 * $Log: SpellcheckerOptionsDialog.C,v $
 * Revision 1.6  1999/01/05 11:16:54  kulow
 * s/klocale->translate/i18n
 * updated po files with the newly i18ned file dialogs
 *
 * Revision 1.5  1998/05/17 15:58:05  schreter
 *
 *
 * Changed label widths to fit in Slovak translations (mainly).
 * Also added character set autodetection (from /opt/kderc, General Font,
 * Charset). It only accepts iso8859-1,2,7, since only these do have
 * .cdef files for them. Use DEFCHARSET (defined in klyx.h) for defaults
 * in config reads, etc. I've changed string "iso8859-1" to DEFCHARSET
 * where appropriate.
 * TODO: fix autodetection, use some locale functions instead of kderc.
 *
 * Revision 1.4  1998/03/04 21:49:52  kalle
 * More Qt-ified
 *
 * Revision 1.3  1997/12/26 23:27:44  kalle
 * Kalle:
 * - klyx now supports Drag-and-Drop of local files!!!
 *
 * Revision 1.2  1997/12/26 22:39:59  kalle
 * Kalle:
 * - Changed ScreenOptions dialog to KDE/Qt version
 * - Changed SpellcheckerOptions dialog to KDE/Qt version
 * - Removed old toolbar
 *
 * Revision 1.1.1.1  1997/12/14 21:19:34  kalle
 * Imported current version. Does not compile...
 *
 * Revision 1.1  1997/11/26 16:11:15  kalle
 * Kalle: First dialogs for LyX
 *
 * Revision 1.3  1997/11/16 22:07:29  kalle
 * added CharacterStyleDialog
 *
 * Revision 1.2  1997/11/15 22:11:54  kalle
 * ParagraphExtraDialog added
 *
 * Revision 1.1.1.1  1997/11/15 18:53:14  kalle
 * SpellcheckerOptionsDialog and testbed
 *
 */
