/* This file is part of
 * ======================================================
 *
 *           LyX, the High Level Word Processor
 * 	
 *	    Copyright (C) 1995 Matthias Ettrich
 *
 *======================================================*/

#include <config.h>

#include <kapp.h>
#include <klocale.h>

#include <ctype.h>
#include "insetinfo.h"
#include "lyxparagraph.h"
#include "error.h"
#include "lyxdraw.h"
#include "buffer.h"
#include "lyx_gui_misc.h"
#include "InsertInfoDialog.h"
#include "LyXView.h"

// 	$Id: insetinfo.C,v 1.7 1999/01/05 11:17:12 kulow Exp $	

#if !defined(lint) && !defined(WITH_WARNINGS)
static char vcid[] = "$Id: insetinfo.C,v 1.7 1999/01/05 11:17:12 kulow Exp $";
#endif /* lint */

extern BufferView *current_view;


/* Info, used for the Info boxes */

InsetInfo::InsetInfo()
{
}


InsetInfo::InsetInfo(LString const & string)
	: contents(string)
{
}


InsetInfo::~InsetInfo()
{
}


int InsetInfo::Ascent(LyXFont const &font) const
{
  return font.maxAscent()+1;
}


int InsetInfo::Descent(LyXFont const &font) const
{
  return font.maxDescent()+1;
}


int InsetInfo::Width(LyXFont const &font) const
{
  return 8 + font.textWidth(i18n("Note"), strlen(klocale->translate("Note")));
}


void InsetInfo::Draw(LyXFont font, LyXScreen &scr,
		     int baseline, float &x)
{
  /* Info-insets are never LaTeX, so just correct the font */
  font.setLatex(LyXFont::OFF);

  // Draw as "Note" in a yellow box
  x += 2;
  scr.fillRectangle(gc_note,
					int(x), baseline - Ascent(font)+1,
					Width(font)-4, Ascent(font)+Descent(font)-2);
  scr.drawRectangle(gc_note_frame,
					int(x), baseline- Ascent(font)+1,
					Width(font)-4, Ascent(font)+Descent(font)-2);

  scr.drawString(font, i18n("Note"), baseline, int(x+2));
  x +=  Width(font) - 2;
}


void InsetInfo::Write(FILE *file)
{
  fprintf(file, "Info %s", contents.c_str());
}


void InsetInfo::Read(LyXLex &lex)
{
  LString tmp = lex.GetString(); // should be "Info"
  if (tmp != "Info")
		lyxerr.print("ERROR (InsetInfo::Read): "
					 "consistency check 1 failed.");

  while (lex.IsOK()) {
	if (!lex.EatLine())
	  // blank line in the file being read
	  // should we skip blank lines?
	  continue;
	
	LString const token = lex.GetString().strip();
	lyxerr.debug("Note: " + token, Error::LEX_PARSER);
	
	if (token != "\\end_inset") {
	  contents += token + '\n';
	}
	else // token == "\\end_inset"
	  break;
	}
  // now remove the last '\n's
  contents.strip('\n');
}


int InsetInfo::Latex(FILE *, signed char /*fragile*/)
{
  return 0;
}


int InsetInfo::Latex(LString &, signed char /*fragile*/)
{
  return 0;
}


unsigned char InsetInfo::Editable() const
{
  return EDITABLE;
}


void InsetInfo::Edit(int, int)
{
  if( current_view->currentBuffer()->isReadonly() )
	WarnReadonly();
	
  if( !klyxdialogs->insertinfo )
	klyxdialogs->insertinfo = new InsertInfoDialog( current_view->getOwner() );

  klyxdialogs->insertinfo->setContents( contents.c_str() );

  (void)klyxdialogs->insertinfo->exec();
  
  const char* tmp = klyxdialogs->insertinfo->contents();
  contents = klyxdialogs->insertinfo->contents();
  delete [] tmp;
}


Inset* InsetInfo::Clone()
{
  InsetInfo *result = new InsetInfo(contents);
  return result;
}


Inset::Code InsetInfo::LyxCode() const
{
  return Inset::IGNORE_CODE;
}
