/* -*- mode: C++; c-file-style: "Stroustrup" -*-
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <kapp.h>
#include <klocale.h>

#include <cstdlib>

#include "insetref.h"
#include "buffer.h"
#include "error.h"
#include "LyXView.h"
#include "lyxfunc.h"
#include "commandtags.h"


extern BufferView *current_view;

InsetRef::InsetRef(LString const & cmd, Buffer *bf)
	: master(bf)
{
	scanCommand(cmd);
	if (getCmdName() == "ref")
		flag = InsetRef::REF;
	else
		flag = InsetRef::PAGE_REF;
}


InsetRef::InsetRef(InsetCommand const &inscmd, Buffer *bf)
	: master(bf)
{
	setCmdName(inscmd.getCmdName());
	setContents(inscmd.getContents());
	setOptions(inscmd.getOptions());
	if (getCmdName() == "ref")
		flag = InsetRef::REF;
	else
		flag = InsetRef::PAGE_REF;
}


InsetRef::~InsetRef()
{
}


void InsetRef::Edit(int, int)
{
  current_view->getOwner()->getLyXFunc()->Dispatch( LFUN_REFGOTO, getContents().c_str() );
}


LString InsetRef::getScreenLabel() const
{
    LString temp;
    if (flag == InsetRef::PAGE_REF)
	temp += i18n( "Page: " );
    else 
	temp += i18n( "Ref: " );
    temp += getContents();
    return temp;
}


int InsetRef::Latex(FILE *file, signed char /*fragile*/)
{
	fprintf(file, "%s", escape(getCommand()).c_str());
	return 0;
}


int InsetRef::Latex(LString &file, signed char /*fragile*/)
{
	file += escape(getCommand());
	return 0;
}


// This function escapes 8-bit characters and other problematic characters
// It's exactly the same code as in insetlabel.C.
LString InsetRef::escape(LString const & lab) const {
	char hexdigit[16] = { '0', '1', '2', '3', '4', '5', '6', '7',
			      '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };
	LString enc;
	for (int i=0; i<lab.length(); i++) {
		unsigned char c=lab[i];
		if (c >= 128 || c=='=' || c=='%') {
			enc += '=';
			enc += hexdigit[c>>4];
			enc += hexdigit[c & 15];
		} else {
			enc += (char) c;
		}
	}
	return enc;
}
