#include <kapp.h>
#include <klocale.h>

#include <config.h>

#include "lyxvc.h"
#include "error.h"
#include "lyx_gui_misc.h"
#include "bufferlist.h"
#include "syscall.h"
#include "pathstack.h"
#include "filetools.h"
#include "FileInfo.h"
#include "LyXView.h"
#include "lyxfunc.h"
#include "VCLogDialog.h"

extern BufferList bufferlist;
extern bool gsworking();
extern BufferView* current_view;

LyXVC::LyXVC()
{
  backend = UNKNOWN_VCS;
  _owner = 0;
}


LyXVC::~LyXVC()
{
#warning Arrgglkl! I cannot seem to get this to work (Kalle)
  //  if( klyxdialogs->vclog && klyxdialogs->vclog->isVisible() )
  //	klyxdialogs->vclog->hide();
}


bool LyXVC::file_found_hook(LString const & fn)
{
  LString tmp(fn);
  FileInfo f;
  // Check if *,v exists.
  tmp += ",v";
  lyxerr.debug(LString("Checking if file is under vc: ") + tmp, Error::LYXVC);
  if (f.newFile(tmp).readable()) {
	lyxerr.debug("Yes it is under vc.", Error::LYXVC);
	master = tmp;
	backend = RCS_VCS;
	scanMaster();
	return true;
  } else {
	// Check if RCS/*,v exists.
	tmp = AddName(AddPath(OnlyPath(fn), "RCS"), fn);
	tmp += ",v";
	lyxerr.debug("Checking if file is under vc: " + tmp, Error::LYXVC);
	if (f.newFile(tmp).readable()) {
	  lyxerr.debug("Yes it is under vc.", Error::LYXVC);
	  master = tmp;
	  backend = RCS_VCS;
	  scanMaster();
	  return true;
	}
  }
  // If either one, return true
  
  // file is not under any VCS.
  return false;
}


bool LyXVC::file_not_found_hook(LString const &)
{
  // file is not under any VCS.
  return false;
}


void LyXVC::scanMaster()
{
  lyxerr.debug("LyXVC: This file is a VC file.", Error::LYXVC);
  
  LyXLex lex(NULL, 0);
  lex.setFile(master);
  
  LString token;
  bool read_enough = false;
  while (lex.IsOK() && !read_enough) {
	lex.next();
	token = lex.GetString();
	
	lyxerr.debug("LyXVC::scanMaster: current lex text: `"
				 +token+"'", Error::LYXVC);
	
	if (token.empty())
	  continue;
	else if (token == "head") {
	  // get version here
	  lex.next();
	  LString tmv = lex.GetString();
	  tmv.strip(';');
	  version = tmv;
	} else if (token.contains("access")
			   || token.contains("symbols")
			   || token.contains("strict")) {
	  // nothing
	} else if (token.contains("locks")) {
	  // get locker here
	  if (token.contains(";")) {
		locker = "Unlocked";
		vcstat = UNLOCKED;
		continue;
	  }
	  LString tmpt, s1, s2;
	  do {
		lex.next();
		tmpt = lex.GetString();
		s1 = tmpt;
		s1.strip(';');
		// tmp is now in the format <user>:<version>
		s1.split(s2, ':');
		// s2 is user, and s1 is version
		if (s1 == version) {
		  locker = s2;
		  vcstat = LOCKED;
		  break;
		}
	  } while (!tmpt.contains(";"));
	  
	} else if (token == "comment") {
	  // we don't need to read any further than this.
	  read_enough = true;
	} else {
	  // unexpected
	  lyxerr.debug("LyXVC::scanMaster(): unexpected token", Error::LYXVC);
	}
  }
}


void LyXVC::setBuffer(Buffer *buf)
{
  _owner = buf;
}


//
// I will probably add some backend_xxxx functions later to perform the
// version control system specific commands. Something like:
// void backend_revert(<params>) {
//        if (backend == "RCS") {
//        } else if (backend == "CVS") {
//        } else if (backend == "SCCS") {
//        }
//
// But for 0.12 we will only support RCS.
//

void LyXVC::registrer()
{
  lyxerr.debug("LyXVC: registrer", Error::LYXVC);
  LString tmp = askForText(i18n("LyX VC: Initial description"),"");
  LString cmd = "ci -q -u -i -t-\"";
  cmd += tmp;
  cmd += "\" ";
  cmd += OnlyFilename(_owner->getFileName());
  doVCCommand(cmd);
  _owner->getUser()->getOwner()->getLyXFunc()->Dispatch("buffer-reload");
}


void LyXVC::checkIn()
{
  lyxerr.debug("LyXVC: checkIn", Error::LYXVC);
  _owner->getUser()->getOwner()->getLyXFunc()->Dispatch(LFUN_MENUWRITE);
  LString tmp = askForText(i18n("LyX VC: Log Message"));
  doVCCommand("ci -q -u -m\"" + tmp + "\" "
			  + OnlyFilename(_owner->getFileName()));
  _owner->getUser()->getOwner()->getLyXFunc()->Dispatch("buffer-reload");
}


void LyXVC::checkOut()
{
  lyxerr.debug("LyXVC: checkOut", Error::LYXVC);
  doVCCommand("co -q -l "
			  + OnlyFilename(_owner->getFileName()));
  _owner->getUser()->getOwner()->getLyXFunc()->Dispatch("buffer-reload");
}


void LyXVC::revert()
{
  lyxerr.debug("LyXVC: revert", Error::LYXVC);
  // Here we should check if the buffer is dirty. And if it is
  // we should warn the user that reverting will discard all
  // changes made since the last check in.
  if (AskQuestion("LyX VC:",
				  i18n("When reverting you will lose all changes made"
									 " to the document since the last check-in."),
				  i18n("Do you still want to do it?"))) {
	
	doVCCommand("co -f -u" + getVersion() + ' '
			    + OnlyFilename(_owner->getFileName()));
	_owner->getUser()->getOwner()->
	  getLyXFunc()->Dispatch("buffer-reload");
  }
}


void LyXVC::undoLast()
{
  lyxerr.debug("LyXVC: undoLast", Error::LYXVC);
  doVCCommand("rcs -o" + getVersion() + ' '
			  + OnlyFilename(_owner->getFileName()));
}


void LyXVC::toggleReadOnly()
{
  switch (vcstat) {
  case UNLOCKED:
	checkOut();
	break;
  case LOCKED:
	checkIn();
	break;
  }
}


bool LyXVC::inUse()
{
  if (!master.empty())
	return true;
  return false;
}


LString const LyXVC::getVersion() const
{
  return version;
}


LString const LyXVC::getLocker() const
{
  return locker;
}


void LyXVC::viewLog(LString const & fil)
{
  if( !klyxdialogs->vclog )
	klyxdialogs->vclog = new VCLogDialog( current_view->getOwner() );

  klyxdialogs->vclog->setVC( this );
  klyxdialogs->vclog->loadFile( fil.c_str() );

  if( klyxdialogs->vclog->isVisible() )
	klyxdialogs->vclog->raise();
  else
	klyxdialogs->vclog->show();
}


void LyXVC::showLog()
{
  // This I really don't like, but we'll look at this problem
  // in 0.13. Then we can make a clean solution.
  if (gsworking()) {
	WriteAlert(i18n("Sorry, can't do this while"
								  " pictures are being rendered."),
			   i18n("Please wait a few seconds for"
								  " this to finish and try again."),
			   i18n("(or kill runaway gs processes"
								  " by hand and try again.)"));
	return;
  }
  extern pid_t isp_pid; // from spellchecker.C
  if(isp_pid != -1) {
	WriteAlert(i18n("Can't do this while the"
								  " spellchecker is running."),
			   i18n("Stop the spellchecker first."));
	return;
  }
  LString tmpf = tmpnam(NULL);
  doVCCommand("rlog "
			  + OnlyFilename(_owner->getFileName()) + " > " + tmpf);
  viewLog(tmpf);
  unlink(tmpf.c_str());
}


int LyXVC::doVCCommand(LString const & cmd)
{
  lyxerr.debug("doVCCommand: " + cmd, Error::LYXVC);
  Systemcalls one;
  PathPush(_owner->filepath);
  int ret = one.Startscript(Systemcalls::System, cmd);
  PathPop();
  return ret;
}
