/-*- C++ -*-

int NPT::FeedForward(int y, int d)
{
  int i;
  Action *a;
  /* eval ebt */
  for (i=0; i<size ; i++)
    if ((a=GetProc(i,y))) {
      if (a && d >= a->Get_ebt()) 
         a->Set_ebt(d);
      if (d>pd) 
         pd=d;
      if (y>=maxy && i>maxx) {
         maxy=y;
         maxx=i;
      }
      FeedForward(i, dur->Get(i,y)+d);      
    }
  return d;
}

int NPT::FeedBackward(int y, int d, Action *a)
{
  int i;

  if (d<0 || y<0 || !a) return 0;
  /* eval let */
  for(i=0; i<max_act; i++)
    if (act[i] && act[i]->getSucc()==a->getPred()) { /* pred found! */
      if (d-a->getDur() < act[i]->Get_let()) act[i]->Set_let(d-a->getDur());
      FeedBackward(act[i]->getPred(), d-a->getDur(), act[i]);
    }
  return d;
}

int NPT::CalcTimes() 
{
  int d, i;
  pd=0L;
  dist->ResetMatrix();

  maxx=0;
  maxy=0;
  d=FeedForward(0,0);/* calc ebt */
  printf("Top node: %d, %d\n", maxx, maxy);
  for(i=0;i<max_act; i++)
    if (act[i]) {
      act[i]->Set_lbt(act[i]->Get_ebt()+act[i]->getDur());
      if (act[i]->Get_lbt()>pd) pd =act[i]->Get_lbt();
    }
  for(i=0;i<max_act; i++)
    if (act[i]) 
      act[i]->Set_let(pd);


  d=FeedBackward(size-2,pd, GetProc(maxx, maxy));

  for(i=0;i<max_act; i++)
    if (act[i]) {
      act[i]->Set_eet(act[i]->Get_let()-act[i]->getDur());
    }

  return 0;
}
