#include "ksiag_app.h"
#include "ksiag_dialogs.h"
#include <stdio.h>
#include <qcombobox.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <kseparator.h>

KSiagFileDialog::KSiagFileDialog(char *path, char *patterns[], char *fmt)
    : KFileDialog(0, 0, 0, 0, true, false)
{
    int i;
    char tmp1[64], tmp2[64];
    char filter[1024];

    // Convert the pattern list to a filter
    if (!patterns)
        return;
    *filter = 0;
    for (i=0; patterns[i]; ++i){
        strcpy(tmp1, patterns[i]); // store a copy for descriptive name
        strcpy(tmp2, tmp1); // make a copy. Can't play with the pointer
        strtok(tmp2, "("); // get the wildcard
        strcat(filter, strtok(NULL, ")"));
        strcat(filter, "|");
        strcat(filter, tmp1);
        strcat(filter, "\n");
    }
    setFilter(filter);
}

bool KSiagFileDialog::getShowFilter()
{
    return(true);
}

int KSiagFileDialog::getFilterIndex()
{
    return(((QComboBox*)filterWidget)->currentItem());
}

KSiagPluginDialog::KSiagPluginDialog(KSiagPluginManager *mgr)
    :KFileDialog(0, 0, 0, 0, true, false)
{
    char *d;
    char filter[1024];
    char line[128];

    *filter = 0;
    for (d=mgr->hd_descs.first(); d; d=mgr->hd_descs.next()){
        sprintf(line, "*.%s|%s (*.%s)\n", mgr->hd_exts.at(mgr->hd_descs.at()),
                d, mgr->hd_exts.at(mgr->hd_descs.at()));
        strcat(filter, line);
    }
    setFilter(filter);
}

bool KSiagPluginDialog::getShowFilter()
{
    return(true);
}

int KSiagPluginDialog::getFilterIndex()
{
    return(((QComboBox *)filterWidget)->currentItem());
}
        
// I had a cooler dialog that returned the result via done, but it segfaulted
// for some reason inside QDialog...
KSiagList::KSiagList (char *text, char *choices[], int nchoices, QWidget *parent,
                      const char *name)
    : QDialog (parent, name, true)
{
    int i;
    QHBoxLayout *buttons = new QHBoxLayout();
    QVBoxLayout *layout = new QVBoxLayout(this, 3);
    KSeparator *sep = new KSeparator(QFrame::HLine, this);
    okay = new QPushButton ("Ok", this);
    cancel = new QPushButton ("Cancel", this);
    head = new QLabel (text, this);
    items = new QListBox (this);
    
    for (i=0; i < nchoices; ++i)
        items->insertItem(choices[i], i);

    cancel->setFixedSize(cancel->fontMetrics().width("Cancel")+16,
                           cancel->fontMetrics().height()+10);
    okay->setFixedSize(cancel->width(), cancel->height());
    head->setMinimumSize(head->fontMetrics().width(text),
                         head->fontMetrics().height());
    this->resize(200, 250); // Otherwise we get a really big dialog.
    layout->addWidget(head, 0);
    layout->addSpacing(3);
    layout->addWidget(items, 1);
    layout->addSpacing(2);
    layout->addWidget(sep, 0);
    layout->addLayout(buttons, 0);
    layout->addSpacing(3);
    
    buttons->addStretch(1);
    buttons->addWidget(okay, 0);
    buttons->addSpacing(5);
    buttons->addWidget(cancel, 0);

    layout->activate();
    this->setCaption("KSiag Request");

    connect (cancel, SIGNAL(clicked()), SLOT(reject()));
    connect (okay, SIGNAL(clicked()), SLOT(accept()));

}

int KSiagList::item()
{
    return(items->currentItem());
}

