
#include "ksiag_form.h"
#include "../common/common.h"
#include "ksiag_logwindow.h"
#include <stdlib.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <kseparator.h>

KSiagForm::KSiagForm (QWidget *parent, const char *name)
    : QDialog(parent, name, true)
{
    // I was having problems using QDialog as the form layout parent, so we
    // use a QWidget instead
    form = new QWidget(this);
    mainlayout = new QVBoxLayout(form, 2);
    curlayout = new QHBoxLayout();
    mainlayout->addLayout(curlayout);
    last = NULL;
    def_focus = NULL;
    sep = 0;
}

KSiagForm::~KSiagForm()
{
    ;
}

void KSiagForm::begin()
{
    ;
}

void KSiagForm::label(char *text)
{
    QLabel *lbl = new QLabel(text, this);
    lbl->setMinimumSize(lbl->sizeHint());
    curlayout->addWidget(lbl);
    last = lbl;
}

void KSiagForm::text(char *text)
{
    QLineEdit *ledit = new QLineEdit(this);
    ledit->setMinimumSize(ledit->sizeHint());
    curlayout->addWidget(ledit);
    last = ledit;
    edits.append(ledit);
    editids.append(text);
    connect(ledit, SIGNAL(returnPressed()), SLOT(accept()));
    if (!def_focus)
        def_focus = ledit;
}

void KSiagForm::menu(char *text)
{
    QComboBox *mnu = new QComboBox(this);
    mnu->setMinimumSize(mnu->sizeHint());
    curlayout->addWidget(mnu);
    last = mnu;
    menus.append(mnu);
    menuids.append(text);
}

void KSiagForm::menuEntry(char *text)
{
    QComboBox *b = (QComboBox *)last;
    b->insertItem(text);
}

void KSiagForm::okButton(char *text)
{
    QPushButton *btn = new QPushButton(text, this);
    btn->setMinimumSize(btn->sizeHint());
    if (!sep){
        KSeparator *line = new KSeparator(QFrame::HLine, this);
        line->setMinimumHeight(line->sizeHint().height()+6);
        curlayout->addWidget(line);
        newline();
        curlayout->addStretch(1);
        sep = 1;
    }
    curlayout->addWidget(btn);
    connect(btn, SIGNAL(clicked()), SLOT(accept()));
    last = btn;
    if (!def_focus)
        def_focus = btn;
}

void KSiagForm::cancelButton(char *text)
{
    QPushButton *btn = new QPushButton(text, this);
    btn->setMinimumSize(btn->sizeHint());
    if (!sep){
        KSeparator *line = new KSeparator(QFrame::HLine, this);
        line->setMinimumHeight(line->sizeHint().height()+6);
        curlayout->addWidget(line);
        newline();
        curlayout->addStretch(1);
        sep = 1;
    }
    curlayout->addWidget(btn);
    connect(btn, SIGNAL(clicked()), SLOT(reject()));
    last = btn;
}

void KSiagForm::property(char *prop, LISP value)
{
    long val;
    
    // Ulric uses Xt names.. no big deal, we just check a few. One so far.
    if (cstrcasecmp(prop, "XtNWidth")){
        if (FLONUMP(value)){
            val = get_c_long(value);
            if (last && val > 5){
                last->setMinimumWidth(val);
            }
        }
    }
}

void KSiagForm::newline()
{
    curlayout = new QHBoxLayout();
    mainlayout->addLayout(curlayout);
}

LISP KSiagForm::end()
{
    QComboBox *box;
    QLineEdit *edit;
    const char *str;
    LISP value;
    
    value = NIL;
    setCaption("KSiag Form");
    mainlayout->activate();
    form->move(0,0);
    if (def_focus)
        def_focus->setFocus();
    if (exec() == Rejected)
        return(NIL);
    for (edit=edits.first(), str=editids.first(); edit ;
         edit=edits.next(), str=editids.next()){
        value = cons(cons(strcons(strlen(str), str),
                          strcons(strlen(edit->text()), edit->text())),
                     value);
    }
    for (box=menus.first(), str=menuids.first(); box ;
         box=menus.next(), str=menuids.next()){
        value = cons(cons(strcons(strlen(str), str),
                          strcons(strlen(box->currentText()),
                                  box->currentText())), value);
    }
    return(value);
}

    
