#include "ksiag_popupmenu.h"

#include <stdio.h>
#include "../siag/calc.h"

KSiagPopupMenu::KSiagPopupMenu (QWidget *parent, const char *name)
    : QPopupMenu (parent, name)
{
    connect (this, SIGNAL(activated(int)), this,
             SLOT(execLispFunction(int)));
}

void KSiagPopupMenu::copy(KSiagPopupMenu *mnu)
{
    char *func;
    KSiagPopupMenu *tmp;
    subnames = mnu->subnames;
    functions = mnu->functions;

    mnu->submenus.first();
    subnames.first();
    for(func=functions.first(); func ; func = functions.next()){
        if (func[0] == '-')
            insertSeparator();
        else if (func[0] == '*'){
            tmp = new KSiagPopupMenu;
            tmp->copy(mnu->submenus.current());
            submenus.append(tmp);
            insertItem(subnames.current(), tmp);
            mnu->submenus.next();
            subnames.next();
        }
        else
            insertItem(mnu->text(mnu->idAt(functions.at())));
    }
}

void KSiagPopupMenu::addLispFunction (const char *name, const char *function)
{
    if (!strcmp (name, "-")){
        insertSeparator();
        functions.append("-"); // Keep functions in sync w/ id's
    }
    else
        functions.insert (insertItem (name), function);
}

void KSiagPopupMenu::execLispFunction (int id)
{
    execute(functions.at(id));
}


void KSiagPopupMenu::insertSubmenu(const char *name)
{
    KSiagPopupMenu *menu = new KSiagPopupMenu();

    insertItem(name, menu);
    submenus.append(menu);
    subnames.append(name);
    functions.append("*"); // We use a * to represent submenus for copies
}

KSiagPopupMenu* KSiagPopupMenu::findSubmenu(const char *name)
{
    int i = subnames.find(name);

    if (i == -1)
        return (0);
    else
        return(submenus.at(subnames.find(name)));
}
