/* addstock.h
 *
 * Andreas Wst
 *
 */

#ifndef ADDSTOCK_H
#define ADDSTOCK_H

#include <stdio.h>
#include <stdlib.h>

#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qframe.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qdialog.h>
#include <qregexp.h>
#include <qcombobox.h>

#include <kmsgbox.h>


#include "stock.h"


/**
 * This a dialog the configure the colors used by MyWidget
 * It's an extension to QWidget and isn't very difficult to understand.
 *
 */

class AddStock : public QDialog
{

        Q_OBJECT

public:

  AddStock ( QWidget *, const char *name);
  ~AddStock();



public slots:

  // OK Button gedrckt
  void okPressed ();

  // RadioButton angewhlt
  void comboSelected (int);

  // Aktie in listbox ausgewhlt
  void getSelectedStock (int);

signals:

  void E_Stock (Stock);
  void E_noErrors ();
  void E_added (bool);


protected:

  // entfernt in einem String die letzten leerzeichen
  char * removeSpaces (char *);

  // ldt liste der Aktien entsprechend des Markets
  void loadList (const char *);


  void paintEvent (QPaintEvent *);


  QButtonGroup *bgstock, *bgmarket, *bgselect, *bglogo;
  QComboBox *combo;
  QLineEdit *le [4];
  QListBox *lb;
  QPushButton *ok, *cancel;
  Stock *stock;

  QString file;

  QString *stockdata;
 
  
  int selected; 
  int radioactivated;


};

#endif		
