/* importdlg.cpp
 *
 * Andreas Wst
 *
 */

#include "importdlg.moc"

ImportDlg::ImportDlg ( QWidget *parent, const char *name )
                : QDialog ( parent, name, TRUE ), date (0), format (0)
{
  setCaption ("Import Data");

  // Import filename

  bgimport = new QButtonGroup ("Import Filename", this, "bgimport");
  bgimport->setGeometry (10, 10, 300, 100);

  browse = new QPushButton("Import from ...", bgimport, "PushButton_1" );
  browse->setGeometry( 20, 30, 100, 20 );
  connect (browse, SIGNAL (clicked ()), SLOT (openFileDlg ()));

  le = new QLineEdit( bgimport, "LineEdit_1" );
  le->setGeometry( 130, 30, 150, 20 );
  le->setMaxLength(100 );

  
  QLabel *l = new QLabel ("Company/Index :", bgimport, "l");
  l->setGeometry (20, 60, 100, 20);
  l->setAlignment (290);

  combo = new QComboBox (TRUE, bgimport, "combo");
  combo->setGeometry (130, 60, 150, 20);
  combo->setInsertionPolicy (QComboBox::NoInsertion);

  // l.list ffnen und stocknamen in combo eintragen
  FILE *in;
  char daten [80], sname [31];
  QString s (getenv ("KDEDIR"));
  s = s + "/share/apps/kstocks/l.list";

  if ((in = fopen (s.data (), "rt")) == NULL)
  {
    fprintf (stderr, "Error opening l.list - file !");
  }
  else
  {
    while (fgets (daten, 78, in) != NULL)
    {
      memset (sname, 0, sizeof (sname));
      memcpy (&sname, &daten [37], 30);
      strcpy (sname, removeSpaces (sname));
      combo->insertItem (sname);
    }
  }
  fclose (in);
 

  
  // Format

  bgdate = new QButtonGroup ("Date", this, "ButtonGroup_2" );
  bgdate->setGeometry( 10, 230, 300, 100 );
  bgdate->setFrameStyle( 49 );
  connect (bgdate, SIGNAL (clicked (int)), SLOT (updateDate (int)));

  bgformat = new QButtonGroup ("Format", this, "ButtonGroup_1" );
  bgformat->setGeometry( 10, 120, 300, 100 );
  bgformat->setFrameStyle( 49 );
  connect (bgformat, SIGNAL (clicked (int)), SLOT (updateFormat (int)));


  f1 = new QRadioButton( bgformat, "RadioButton_1" );
  f1->setGeometry( 10, 20, 270, 20 );
  f1->setText( "DATE,OPEN,HIGH,LOW,CLOSE,VOLUME" );
  f1->setAutoRepeat( FALSE );
  f1->setAutoResize( FALSE );
  f1->setChecked (TRUE);

  d1 = new QRadioButton ("DD-MMM-YY", bgdate, "RadioButton_2" );
  d1->setGeometry( 10, 20, 130, 20 );
  d1->setAutoRepeat( FALSE );
  d1->setAutoResize( FALSE );
  d1->setChecked (TRUE);

  d2 = new QRadioButton ("DD-MMM-YYYY", bgdate, "RadioButton_2" );
  d2->setGeometry( 10, 40, 130, 20 );
  d2->setAutoRepeat( FALSE );
  d2->setAutoResize( FALSE );


  cancel = new QPushButton ("Cancel", this, "PushButton_2" );
  cancel->setGeometry( 130, 340, 70, 30 );
  connect (cancel, SIGNAL (clicked ()), SLOT (reject ()));

  ok = new QPushButton ("OK", this, "PushButton_3" );
  ok->setGeometry( 240, 340, 70, 30 ); 
  connect (ok, SIGNAL (clicked ()), SLOT (okPressed ()));

  resize( 320, 380 );
}    

ImportDlg::~ImportDlg()
{
}


char * ImportDlg::removeSpaces (char *s)
{
  debug (s);
  int i = strlen (s);
  while (s [i - 1] == ' ')
  {
    s [i] = 0;
    i--;
  }
  s [i] = 0;
  return s;
}


void ImportDlg::updateDate (int i)
{
  debug ("date : %d", i);
  date = i;
}

void ImportDlg::updateFormat (int i)
{
  debug ("format : %d", i);
  format = i;
}

void ImportDlg::openFileDlg ()
{
  debug ("open file dlg");
   

  QString fileStr = QFileDialog::getOpenFileName ("$HOME", "*", this);
  if (!fileStr.isEmpty ())
  {
    le->setText (fileStr.data ());
  }

}

void ImportDlg::okPressed ()
{
  QString st1, st2;
  
  char msg [100];

  // in st1 steht dateiname aus der importiert wird
 // in st2 steht name der company,/ind

  st1 = le->text ();
  st2 = combo->currentText ();

  if (st1.length () == 0) 
  {
    sprintf (msg, "You have to enter a \ninput data - file !");
    KMsgBox::message (this, "Error", msg);
    return;
  }
  
  if (st2.length () == 0)
  {
    sprintf (msg, "You have to enter the\n index or company name !");
    KMsgBox::message (this, "Error", msg);
    return;
  }

  QFile f (st1.data ());
  if (f.exists () == FALSE)
  {
    sprintf (msg, "Could not open file\n%s", st1.data ());
    KMsgBox::message(this, "Error", msg);
    return;
  }


  emit (emitData (st1, st2, format, date));

  accept ();
  //  emit (doneOk ());
}
