/* showchart.cpp
 *
 * Andreas Wst
 *
 */

#include "showchart.moc"

ShowChart::ShowChart (QWidget *parent, const char *name, QColor c1, QColor c2,
                      QColor c3) : QDialog ( parent, name, TRUE ), 
                      minkurs (-1), maxkurs (-1), zoom (4), anzkurse (0), 
                      startx (0), pm (10, 10), maxvol (0), col1 (c1), 
                      col2 (c2), col3 (c3)
{
  sbar = new QScrollBar (this, "sbar");
  sbar->setGeometry (79, 540, 500, 20);
  sbar->setOrientation (QScrollBar::Horizontal);
  connect (sbar, SIGNAL (valueChanged (int)), SLOT (getSbPos (int)));

  l = new QLabel (this, "label");
  l->setGeometry (79, 565, 500, 30);
  l->setFrameStyle (QFrame::Panel | QFrame::Sunken);
  l->setAlignment (AlignVCenter | AlignLeft);

  // menu erzeugen 
  charts = new QPopupMenu ();
  charts->insertItem (klocale->translate ("Import Data"), this,
                      SLOT (importDialog ()));
  charts->insertSeparator (-1);
  charts->insertItem (klocale->translate ("Work with chart"), this, 
                      SLOT (workWithDataDialog ()));
  charts->insertSeparator (-1); 
  charts->insertItem (klocale->translate ("Quit Charts"), this, 
                      SLOT (accept ()));

  // tage linien popup menu erzeugen
  lines = new QPopupMenu ();
  lines->setCheckable (TRUE);
  lines->insertItem (klocale->translate ("50-Day-average"));
  lines->insertItem (klocale->translate ("100-Day-average"));
  lines->insertItem (klocale->translate ("200-Day-average"));
  connect (lines, SIGNAL (activated (int)), this, SLOT (getActivated (int)));

  menu = new QMenuBar (this, "chartmenu");
  menu->insertItem ("&Charts", charts);
  menu->insertItem ("&Lines", lines);

  // wenn false (def.) mousemoveevent nur bei pressevent
  setMouseTracking (TRUE);





  pm.resize (800, 600);
  resize (800, 600);
}



ShowChart::~ShowChart()
{       
}


void ShowChart::getSbPos (int i)
{
  debug ("in getsbpos");
  startx = i;
  repaint (FALSE);
}


long ShowChart::getMaxVolume ()
{
  long max = kurse [0].volume;
  for (unsigned int i = 1; i < anzkurse; i++)
    if (kurse [i].volume > max) max = kurse [i].volume;
  return (max);
}
  

double ShowChart::getMax ()
{
  double max = kurse [0].kurs;
  for (unsigned int i = 1; i < anzkurse; i++)
    if (kurse [i].kurs > max) max = kurse [i].kurs;
  return (max);
}

double ShowChart::getMin ()
{
  double min = kurse [0].kurs;
  //  debug ("kleinster : %d - %f", kurse [0].kurs, min);
 
  for (unsigned int i = 1; i < anzkurse; i++)
    if (kurse [i].kurs < min)
    { 
      min = kurse [i].kurs;
      //      debug ("kleinster : %d - %f", i, min);
    }
  return (min);
}




void ShowChart::calcTage (int n, double *ptage)
{
  memset (ptage, 0, sizeof (double) * anzkurse);
  double summe = 0;
  int i;
  for (i = 0; i < n; i++)
  {
    summe += kurse [i].kurs;
    ptage [i] = -1;
  }

  for (unsigned i = n; i < anzkurse; i++)
  {
    summe = summe + kurse [i].kurs - kurse [i - n].kurs;
    ptage [i] = summe / n;
  }
}

char * ShowChart::removeSpaces (char *s)
{
  //  debug (s);
  int i = strlen (s);
  while (s [i - 1] == ' ')
  {
    s [i] = 0;
    i--;
  }
  s [i] = 0; 
  return s;
}

void ShowChart::loadData (QString s)
{
  FILE *in;

  if ((in = fopen (s.data (), "rb")) == NULL)
  {
    fprintf (stderr, "Could not read file %s !", s.data ());
  }
  else
  {
    memset (wkn, 0, sizeof (wkn));
    memset (ticker, 0, sizeof (ticker));    

    // wenn datei lesbar, dateiname + pfad in titel schreiben
    setCaption (s.data ());

    fread (&anzkurse, sizeof (anzkurse), 1, in);
    fread (&kurse [0], sizeof (chart_daten), anzkurse, in);
    //    debug ("%d", anzkurse);
    fclose (in);
    
    // extrema bestimmen
    minkurs = getMin ();
    maxkurs = getMax ();
    maxvol = getMaxVolume (); 
  
    debug ("volume max : %ld", maxvol);
    //    debug ("min : %lf", minkurs);
    //    debug ("max : %lf", maxkurs);


    // 50, 100, 200 tage linie berechnen
    calcTage (50, tage1);
    calcTage (100, tage2);
    calcTage (200, tage3);

    // scroll bar neu ausrichten und alles zurcksetzen
    zoom = 4;
    sbar->setValue (0);
    // ------------ WIDTH NDERN (400)------------------
    sbar->setRange (0, anzkurse - ( (500) / zoom));   


    // l.list ffnen und namen in file suchen -> wkn , ticker
    // in cname (QString) steht company name
    FILE *in2;
    char daten [80], sname [31];
    QString s (getenv ("KDEDIR"));
    s = s + "/share/apps/kstocks/l.list";

    if ((in2 = fopen (s.data (), "rt")) == NULL)
    {
      fprintf (stderr, "Error opening l.list - file !");
    }
    else
    { 
      while (fgets (daten, 78, in2) != NULL)
      {
        memset (sname, 0, sizeof (sname));
        memcpy (&sname, &daten [37], 30);
        strcpy (sname, removeSpaces (sname));
        // sname in cname enthalten -> ticker und wkn auslesen
	QString found (sname);
        debug ("-%s-%s-", found.data (), cname.data ());
        if (found.contains (cname, FALSE) != 0)  
	{
          memcpy (wkn, daten, 7);
          memcpy (ticker, &daten [69], 6);
          strcpy (ticker, removeSpaces (ticker));
          debug ("gefunden : -%s- -%s- -%s-", daten, wkn, ticker);
          break;
	}
      } 
    }
    fclose (in2);

    repaint (FALSE);
  }
  debug ("ende loaddata");
} 

void ShowChart::getChartFile (QString s)
{
  //  debug ("load file %s", s.data ());
  loadData (s.data ());
}

void ShowChart::getChartName (QString s)
{
  cname = s;
}


void ShowChart::workWithDataDialog ()
{
 WWDialog *w;
 w = new WWDialog (this, "wwdialog");
 connect (w, SIGNAL (returnChartFile (QString)), this, 
             SLOT (getChartFile (QString)));
 connect (w, SIGNAL (returnChartName (QString)), this,
             SLOT (getChartName (QString)));
 w->exec ();
 delete w;
}


void ShowChart::importDialog ()
{
  ImportDlg *idlg;
  idlg = new ImportDlg (this, "importdlg");
  connect (idlg, SIGNAL (
            emitData (QString, QString, unsigned char, unsigned char)), this,
            SLOT (getData (QString, QString, unsigned char, unsigned char)));
  int exitcode = idlg->exec ();
  delete idlg;

  if (exitcode != 0)
    startTimer (500);
}

void ShowChart::timerEvent (QTimerEvent *)
{
  //  debug ("im timer");
  switch (format)
  {
    case 0 : switch (date)  // YAHOO - Daten
             {
               case 0 : importDataFromCSV (file.data ());
                        break;
               case 1 : importDataFromCSV2 (file.data ());
                        break;
	     }
             break;
  }

  repaint (FALSE);

  killTimers ();
}

void ShowChart::getActivated (int i)
{
  debug ("lines %d", i);
  if (lines->isItemChecked (i) == TRUE)
    lines->setItemChecked (i, FALSE);
  else
    lines->setItemChecked (i, TRUE);
  repaint (FALSE);
}

void ShowChart::getData (QString s1, QString s2, unsigned char i1,unsigned char i2)
{
  // s1 = filename
  // s2 = index/company

  //  debug ("file2open : %s", s1.data ());

  fileout = s2;
   
  //  debug ("filename %s", fileout.data ());

  file = s1;
  format = i1;
  date = i2;

  //  debug ("data : %s, %s, %d, %d ", s1.data (), s2.data (), i1, i2);
}

void ShowChart::saveData (unsigned int anz, QString st)
{
  FILE *out;
  st.replace (QRegExp (" "), "_");
 
  QString dummy (getenv ("HOME"));
  dummy += "/stocks/data/" + st + ".data";

  
  if ((out = fopen (dummy.data (), "wb")) == NULL)
  {
    fprintf (stderr, "Could not write file %s !", dummy.data ());
  }
  else
  {
    fwrite (&anz, sizeof (anz), 1, out);
    fwrite (&kurse [0], sizeof (chart_daten), anzkurse, out);
    fclose (out);
    // Datei noch mit gzip komprimieren !
    // spter hinzufgen, 

    /* sh: /root/stocks/data .... permission denied
    QString s = "gzip -9v " + dummy;  
    debug ("%s", s.data ());
    system (dummy.data ()); 
    */
  }  
}

void ShowChart::importDataFromCSV (const char *filename)
{
  char st [80], date [20], dummy [20];
 
  // anzahl der kommas pro zeile
  unsigned char kommas;
  // pos der kommas
  unsigned char pos [10], len;
  

  FILE *in = stdin;


  // ******************************************************************* //
  // ANFANG - Importfilter fr                                           //
  //                                                                     //
  //        date, open, high, low, close, volume                         //
  //        DD-MMM-YY                                                    //  
  //                                                                     //
  // ******************************************************************* //
  
  if (( in = fopen (filename, "rt")) == NULL)
  {
    fprintf (stderr, "Could not import data from %s", filename);
  }
  else
  {
    int i = 0;
    while (fgets (st, 79, in) != NULL) 
      i++;
 
    anzkurse = i - 1;

    debug ("anzkurse : %d", anzkurse);

    // progress dialog erstellen
    QProgressDialog progress ("Importing Data", "Cancel", anzkurse, this);


    // auf anfang stellen
    fseek (in, 0, SEEK_SET);

    // erste zeile einlesen , bis ende
    int zaehler = 0;
    while (fgets (st, 79, in) != NULL)
    {
      // position und anzahl der kommas bestimmen
      // alle pos auf 0, anzahl kommas = 0
      memset (pos, 0, sizeof (pos));
      for (i = 0, kommas = 0; i < (int) strlen (st); i++)
      {
        if (st [i] == ',')
	{
          pos [kommas] = i;
	  //          debug ("pos : %d", i);
          kommas++;
	}
      }
    
      // erste zeile bei daten enthlt format -> berspringen
      if (zaehler != 0) 
      {
 
        // datum kopieren
        memcpy (date, st, pos [0]); 
        date [pos [0]] = 0;
         
        // tag besteht aus zwei zahlen
        if (strlen (date) == 9)
	{
          // tag kopieren
          memcpy (dummy, date, 2);
          dummy [2] = 0;
          kurse [anzkurse - zaehler].tag = atoi (dummy);

          // jahr kopieren, von anfang bis komma
          memcpy (dummy, &date [7], 2);
          dummy [2] = 0;
          kurse [anzkurse - zaehler].jahr = atoi (dummy);

          // monat kopieren
          memcpy (dummy, &date [3], 3);
          dummy [3] = 0;

	} 
        else  // tag besteht aus einer zahl
	{
          // tag kopieren
          memcpy (dummy, date, 1);
          kurse [anzkurse - zaehler].tag = dummy [0] - 48;

          // jahr kopieren, von anfang bis komma
          memcpy (dummy, &date [6], 2);
          dummy [2] = 0;
          kurse [anzkurse - zaehler].jahr = atoi (dummy);
    
          // monat kopieren
          memcpy (dummy, &date [2], 3);
          dummy [3] = 0;

	}
        
        // jahr 2000 umgehen       
        if (kurse [anzkurse - zaehler].jahr < 10)
          kurse [anzkurse - zaehler].jahr += 2000;
        else
          kurse [anzkurse - zaehler].jahr += 1900;	


        // monat von string in zahl
        if (strcmp (dummy, "Jan") == 0)
          kurse [anzkurse - zaehler].monat = 1;
        if (strcmp (dummy, "Feb") == 0)
          kurse [anzkurse - zaehler].monat = 2;
        if (strcmp (dummy, "Mar") == 0)
          kurse [anzkurse - zaehler].monat = 3;
        if (strcmp (dummy, "Apr") == 0)
          kurse [anzkurse - zaehler].monat = 4;
        if (strcmp (dummy, "May") == 0)
          kurse [anzkurse - zaehler].monat = 5;
        if (strcmp (dummy, "Jun") == 0)
          kurse [anzkurse - zaehler].monat = 6;
        if (strcmp (dummy, "Jul") == 0)
          kurse [anzkurse - zaehler].monat = 7;
        if (strcmp (dummy, "Aug") == 0)
          kurse [anzkurse - zaehler].monat = 8;
        if (strcmp (dummy, "Sep") == 0)
          kurse [anzkurse - zaehler].monat = 9;
        if (strcmp (dummy, "Oct") == 0)
          kurse [anzkurse - zaehler].monat = 10;
        if (strcmp (dummy, "Nov") == 0)
          kurse [anzkurse - zaehler].monat = 11;
        if (strcmp (dummy, "Dec") == 0)
          kurse [anzkurse - zaehler].monat = 12;


        // open kopieren
        len = pos [1] - pos [0];
        memcpy (dummy, &st [pos [0] + 1], len - 1);
        dummy [len - 1] = 0;
        kurse [anzkurse - zaehler].open = atof (dummy);

        // high kopieren
        len = pos [2] - pos [1];
        memcpy (dummy, &st [pos [1] + 1], len - 1);
        dummy [len - 1] = 0;
        kurse [anzkurse - zaehler].high = atof (dummy);
     
        // low kopieren
        len = pos [3] - pos [2];
        memcpy (dummy, &st [pos [2] + 1], len - 1);
        dummy [len - 1] = 0;
        kurse [anzkurse - zaehler].low = atof (dummy);

        // close kopieren
        len = pos [4] - pos [3];
        memcpy (dummy, &st [pos [3] + 1], len - 1);
        dummy [len - 1] = 0;
        kurse [anzkurse - zaehler].kurs = atof (dummy);

        // volume kopieren 
        len = strlen (st) - pos [4];
        memcpy (dummy, &st [pos [4] + 1], len - 1);
        dummy [len - 2] = 0;
        kurse [anzkurse - zaehler].volume = atol (dummy);
 
      }    
      zaehler++;
      progress.setProgress (zaehler);
    }
    

    fclose (in);
  }   

  // ******************************************************************* //
  // ENDE - Importfilter fr                                             //
  //                                                                     //
  //        date, open, high, low, close, volume                         //    
  //                                                                     //
  // ******************************************************************* //

  saveData (anzkurse, fileout);

  // zeichnen unterdrcken
  anzkurse = 0;
}



void ShowChart::importDataFromCSV2 (const char *filename)
{
  char st [80], date [20], dummy [20];
 
  // anzahl der kommas pro zeile
  unsigned char kommas;
  // pos der kommas
  unsigned char pos [10], len;
  

  FILE *in = stdin;


  // ******************************************************************* //
  // ANFANG - Importfilter fr                                           //
  //                                                                     //
  //        date, open, high, low, close, volume                         //    
  //        DD-MMM-YYYY                                                  //
  //                                                                     //
  // ******************************************************************* //
  
  if (( in = fopen (filename, "rt")) == NULL)
  {
    fprintf (stderr, "Could not import data from %s", filename);
  }
  else
  {
    int i = 0;
    while (fgets (st, 79, in) != NULL) 
      i++;
 
    anzkurse = i - 1;

    //    debug ("anzkurse : %d", anzkurse);

    // progress dialog erstellen
    QProgressDialog progress ("Importing Data", "Cancel", anzkurse, this);


    // auf anfang stellen
    fseek (in, 0, SEEK_SET);

    // erste zeile einlesen , bis ende
    int zaehler = 0;
    while (fgets (st, 79, in) != NULL)
    {
      // position und anzahl der kommas bestimmen
      // alle pos auf 0, anzahl kommas = 0
      memset (pos, 0, sizeof (pos));
      for (i = 0, kommas = 0; i < (int) strlen (st); i++)
      {
        if (st [i] == ',')
	{
          pos [kommas] = i;
	  //          debug ("pos : %d", i);
          kommas++;
	}
      }
    
      // erste zeile bei daten enthlt format -> berspringen
      if (zaehler != 0) 
      {
 
        // datum kopieren
        memcpy (date, st, pos [0]); 
        date [pos [0]] = 0;
         
        // tag besteht aus zwei zahlen
        if (strlen (date) == 11)
	{
          // tag kopieren
          memcpy (dummy, date, 2);
          dummy [2] = 0;
          kurse [anzkurse - zaehler].tag = atoi (dummy);

          // jahr kopieren, von anfang bis komma
          memcpy (dummy, &date [7], 4);
          dummy [4] = 0;
          kurse [anzkurse - zaehler].jahr = atoi (dummy);
	  //          debug ("2jahr : %d", kurse [anzkurse - zaehler].jahr);


          // monat kopieren
          memcpy (dummy, &date [3], 3);
          dummy [3] = 0;

	} 
        else  // tag besteht aus einer zahl
	{
          // tag kopieren
          memcpy (dummy, date, 1);
          kurse [anzkurse - zaehler].tag = dummy [0] - 48;

          // jahr kopieren, von anfang bis komma
          memcpy (dummy, &date [6], 4);
          dummy [4] = 0;
          kurse [anzkurse - zaehler].jahr = atoi (dummy);
	  //          debug ("1jahr : %d", kurse [anzkurse - zaehler].jahr);
    
          // monat kopieren
          memcpy (dummy, &date [2], 3);
          dummy [3] = 0;

	}
        

        // monat von string in zahl
        if (strcmp (dummy, "Jan") == 0)
          kurse [anzkurse - zaehler].monat = 1;
        if (strcmp (dummy, "Feb") == 0)
          kurse [anzkurse - zaehler].monat = 2;
        if (strcmp (dummy, "Mar") == 0)
          kurse [anzkurse - zaehler].monat = 3;
        if (strcmp (dummy, "Apr") == 0)
          kurse [anzkurse - zaehler].monat = 4;
        if (strcmp (dummy, "May") == 0)
          kurse [anzkurse - zaehler].monat = 5;
        if (strcmp (dummy, "Jun") == 0)
          kurse [anzkurse - zaehler].monat = 6;
        if (strcmp (dummy, "Jul") == 0)
          kurse [anzkurse - zaehler].monat = 7;
        if (strcmp (dummy, "Aug") == 0)
          kurse [anzkurse - zaehler].monat = 8;
        if (strcmp (dummy, "Sep") == 0)
          kurse [anzkurse - zaehler].monat = 9;
        if (strcmp (dummy, "Oct") == 0)
          kurse [anzkurse - zaehler].monat = 10;
        if (strcmp (dummy, "Nov") == 0)
          kurse [anzkurse - zaehler].monat = 11;
        if (strcmp (dummy, "Dec") == 0)
          kurse [anzkurse - zaehler].monat = 12;


        // open kopieren
        len = pos [1] - pos [0];
        memcpy (dummy, &st [pos [0] + 1], len - 1);
        dummy [len - 1] = 0;
        kurse [anzkurse - zaehler].open = atof (dummy);

        // high kopieren
        len = pos [2] - pos [1];
        memcpy (dummy, &st [pos [1] + 1], len - 1);
        dummy [len - 1] = 0;
        kurse [anzkurse - zaehler].high = atof (dummy);
     
        // low kopieren
        len = pos [3] - pos [2];
        memcpy (dummy, &st [pos [2] + 1], len - 1);
        dummy [len - 1] = 0;
        kurse [anzkurse - zaehler].low = atof (dummy);

        // close kopieren
        len = pos [4] - pos [3];
        memcpy (dummy, &st [pos [3] + 1], len - 1);
        dummy [len - 1] = 0;
        kurse [anzkurse - zaehler].kurs = atof (dummy);

        // volume kopieren 
        len = strlen (st) - pos [4];
        memcpy (dummy, &st [pos [4] + 1], len - 1);
        dummy [len - 2] = 0;
        kurse [anzkurse - zaehler].volume = atol (dummy);
 
      }    
      zaehler++;
      progress.setProgress (zaehler);
    }
    

    fclose (in);
  }   

  // ******************************************************************* //
  // ENDE - Importfilter fr                                             //
  //                                                                     //
  //        date, open, high, low, close, volume                         //    
  //                                                                     //
  // ******************************************************************* //

  saveData (anzkurse, fileout);

  // zeichnen unterdrcken
  anzkurse = 0;
}

void ShowChart::mouseMoveEvent (QMouseEvent *e)
{
  //  debug ("in move event");
  if (anzkurse < 1)
    return;

  char st [70];
  char *mon [12] = {"January", "February", "March", "April", "May", "June",
                    "July", "August", "September", "October", "November",
                    "December" };  

  if (QRect (79, 70, 500 - zoom, 440).contains (e->pos (), FALSE) == TRUE)
  {
    int x = e->pos ().x () - 79;
 
    long index = startx;
    index += (int) (x / zoom);

    sprintf (st, "  %.4f US $  -  Volume : %ld    ( %s %d, %d )", 
             kurse [index].kurs, kurse [index].volume,
             mon [kurse [index].monat - 1], kurse [index].tag, 
             kurse [index].jahr);
    l->setText (st);
  }
  else
    l->setText ("");
}

void ShowChart::mousePressEvent (QMouseEvent *e)
{
  if (anzkurse == 0)
    return;

  if (e->button () == LeftButton)
    zoom--;
  if (e->button () == RightButton)
    zoom++;
  if (zoom < 1) zoom = 1;
  if (zoom > 6) zoom = 6;

  sbar->setRange (0, anzkurse - (500 / zoom));

  repaint (FALSE);
}





void ShowChart::paintEvent (QPaintEvent *)
{
  //  debug ("in paintevent");
  char texte [6] [7] = {"TICKER", "WKN", "LAST", "HIGH", "LOW"};
  char st [10];
  int i;
  QPainter p;
  p.begin (&pm);
  //  p.setBackgroundColor (QColor (192, 192, 192));
  p.fillRect (0, 0, 800, 600, QColor (192, 192, 192));

  // --------- oben -----------------

  // linkes Feld, Kursangaben
  p.drawRect (10, 70, 70, 320);
  p.drawText (30, 87, "US $", 4);

  // Skalierung linkes Feld und rechtes Feld
  for (i = 0; i < 10; i++)
  {
    // links
    p.drawLine (75, 105 + i * 30, 75 + 9, 105 + i * 30);
    // rechts
    p.drawLine (574, 105 + i * 30, 574 + 9, 105 + i * 30);
  }

  // feld fr kursdarstellung
  p.drawRect (79, 70, 500, 320);
  
  // rechts Feld, Kursangaben
  p.drawRect (578, 70, 70, 320);
  p.drawText (598, 87, "US $", 4);


  // --------- unten --------------------

  // links unten, Umsatzangabe
  p.drawRect (10, 389, 70, 120);
  p.drawText (17, 406, "VOLUME", 6);

  // Skalierung VOLUME links und rechts
  p.setFont (QFont ("helvetica", 10));
  for (i = 0; i < 4; i++)
  {
    p.drawLine (75, 508 - i * 25, 75 + 9, 508 - i * 25);
    p.drawLine (574, 508 - i * 25, 574 + 9, 508 - i * 25);
  }

  // feld fr umsatzdarstellung
  p.drawRect (79, 389, 500, 120);

  // rechtes Feld, Umsatzangabe
  p.drawRect (578, 389, 70, 120);  
  p.drawText (585, 406, "VOLUME", 6);


  // ----------- ganz rechts -----------------

  // ganz rechts, feld fr diverse angaben
  p.drawRect (647, 70, 80, 439);

  p.setFont (QFont ("helvetica", 16, QFont::Bold));

  for (i = 0; i < 6; i++)
  {
    p.drawLine (647, 70 + i * 73, 647 + 80, 70 + i * 73);
    p.drawText (647, 70 + i * 73 + 5, 80, 20, AlignCenter, 
                texte [i], strlen (texte [i]));
  }

 
  // ----------- ganz unten -----------------

  // Quartalsangabe
  p.drawRect (79, 508, 500, 30);


  if (anzkurse > 0)  
  {
    p.setFont (QFont ("times", 12));

    // 1. feld
    p.drawText (647, 70 + 0 * 73 + 35, 80, 20, AlignCenter, ticker, 
                strlen (ticker));
 
    // 2. feld
    p.drawText (647, 70 + 1 * 73 + 35, 80, 20, AlignCenter, wkn, 
                strlen (wkn));

    // 3. feld
    sprintf (st, "%.4f", kurse [anzkurse - 1].kurs);
    p.drawText (647, 70 + 2 * 73 + 35, 80, 20, AlignCenter, st, strlen (st));

    // 4. feld
    sprintf (st, "%.4f", maxkurs);
    p.drawText (647, 70 + 3 * 73 + 35, 80, 20, AlignCenter, st, strlen (st));

    // 5. feld
    sprintf (st, "%.4f", minkurs);
    p.drawText (647, 70 + 4 * 73 + 35, 80, 20, AlignCenter, st, strlen (st));

  
    p.setFont (QFont ("times", 12));
    p.drawText (647, 70 + 5 * 73, 80, 20, AlignCenter, " 50 Day avg.",12);
    p.drawText (647, 70 + 5 * 73 + 22, 80, 20, AlignCenter, "100 Day avg.",12);
    p.drawText (647, 70 + 5 * 73 + 44, 80, 20, AlignCenter, "200 Day avg.",12);

    p.setPen (col1);
    p.drawLine (657, 70 + 5 * 73 + 22, 657 + 60, 70 + 5 * 73 + 22);

    p.setPen (col2);
    p.drawLine (657, 70 + 5 * 73 + 44, 657 + 60, 70 + 5 * 73 + 44);
  
    p.setPen (col3);
    p.drawLine (657, 70 + 5 * 73 + 66, 657 + 60, 70 + 5 * 73 + 66);

    p.setPen (black);

    
 

    // Chartdarstellung 
    int breite = 500;
    double walt, wneu;
    double xdiff = maxkurs - minkurs;
    double dx = xdiff / 9;
    double dy = xdiff / (375 - 105);
    bool first = TRUE;

    // Beschriftung vom Chartfeld
    // von 105 bis 375
  
    // Beschriftung Volume 
    // von 508 bis 508 - 75
    for (i = 0; i < 10; i++)
    {
      // links
      sprintf (st, "%d", (int) (minkurs + i * dx));
      p.drawText (40, 380 - i * 30, st, strlen (st));
      // rechts
      p.drawText (594, 380 - i * 30, st, strlen (st));
    }

    for (i = 0; i < 4; i++)
    {
      if (i != 0)
      {
        sprintf (st, "%d", (int) (maxvol * i / 3 ));
        p.drawText (20, 488 + 25 - i * 25, st, strlen (st));
        p.drawText (594, 488 + 25 - i * 25, st, strlen (st));
      }
    }







    first = TRUE;
   
    // font setzen
    p.setFont (QFont ("times", 16));    

 
    for (i = startx + 1; i < (breite / zoom) + startx ; i++)
    {
      p.setPen (black);
      walt = kurse [i - 1].kurs;
      wneu = kurse [i].kurs;

      // hier noch quartale einfgen
      int x;


      //  trennstrich fr quartale
      // 12/1  3/4  6/7   9/10   monate bzw quartale
      if (  ((kurse [i - 1].monat) % 3 == 0) && 
            (kurse [i - 1].monat != kurse [i].monat) )
      {
        char st [20];
        p.setPen (black);
          
        x = ((i - startx - 1) * zoom);

        // erstes quartal schreiben wenn sb nicht am anfang      
        if (first == TRUE) // && startx != 0)  
        {
          // jahr und quartal des vorhergehenden quartals bestimmen
          first = FALSE;
          int quart = (kurse [i].monat - 1) / 3;
          int jahr  = (kurse [i].jahr);
          if (quart == 0) 
	  {
            quart = 4;
            jahr--;
          }

          if (zoom < 2)
            sprintf (st, "%d.' %d", quart, jahr);
          else
            sprintf (st, "%d.Quart. %d", quart, jahr);
 
          // zurckprojektion des quartals
          int dummy = i - 1;
          if (dummy != 0)
          while ( ((kurse [dummy - 1].monat) % 3 != 0) ||
                   (kurse [dummy - 1].monat == kurse [dummy].monat)) dummy--;

  	//        debug ("dummy : %d", dummy);
	//        debug ("diff : %d", i - dummy);
         
          if (startx != 0)
          p.drawText (79 + x + 5 - ( (i - dummy) * zoom), 
                      527, st, strlen (st));
          else
            p.drawText (79 + 5, 527, st, strlen (st));
 
        }  

        // beschriftung welches quartal
        // 1 - 1.   4 - 2.   7 - 3.   10 - 4.  
        if (zoom < 2)
          sprintf (st,"%d.' %d", (kurse [i].monat - 1) / 3+1, kurse [i].jahr); 
        else
          sprintf (st, "%d.Quart. %d", (kurse [i].monat - 1) / 3 + 1, 
                   kurse [i].jahr);
        p.drawText (79 + x + 5, 527, st, strlen (st));

        // vorhergehend und nachfolgend berstehender text lschen
        p.fillRect (0, 509, 79, 509 + 30, QBrush (QColor (192, 192, 192)));
        p.fillRect (579, 509, 579 + 100, 509 + 30, 
                    QBrush (QColor (192, 192, 192)));
	

        //      debug ("x : %d", x);

        // strich zwischen kurse von quartalen  
        p.drawLine (80 + x - 1, 508, 80 + x - 1, 508 + 29);
        // erster strich, wenn ganz am anfang
        if (startx == 0)
          p.drawLine (79, 508, 79, 508 + 29);
      }


      
      // Chart Kurslinie
      walt = (walt - minkurs) / dy;
      wneu = (wneu - minkurs) / dy; 

      p.drawLine (80 + (i - startx - 1) * zoom, 375 - (walt),
                  80 + (i - startx) * zoom, 375 - (wneu) );

      // Umsatzbalken
      p.fillRect (80 + (i - startx - 1) * zoom, 507, zoom,  
                  - ((kurse [i - 1].volume / (double) maxvol) * 75), 
                  QBrush (blue)); 


      // tage linien 50
      if (lines->isItemChecked (0) == TRUE)
      {    
        p.setPen (col1);
        walt = tage1 [i - 1];
    
        if (walt > 0.001)
        {
          wneu = tage1 [i];
   
          walt = (walt - minkurs) / dy;
          wneu = (wneu - minkurs) / dy;
  
          p.drawLine (80 + (i - startx - 1) * zoom, 375 - (walt),
                      80 + (i - startx) * zoom, 375 - (wneu) );
        }
      }

      // tage linien 100
      if (lines->isItemChecked (1) == TRUE)
      {    
        p.setPen (col2);
        walt = tage2 [i - 1];
    
        if (walt > 0.001)
        {
          wneu = tage2 [i];
   
          walt = (walt - minkurs) / dy;
          wneu = (wneu - minkurs) / dy;
 
          p.drawLine (80 + (i - startx - 1) * zoom, 375 - (walt),
                      80 + (i - startx) * zoom, 375 - (wneu) );
        }
      }

      // tage linien 200
      if (lines->isItemChecked (2) == TRUE)
      {    
        p.setPen (col3);
        walt = tage3 [i - 1];
    
        if (walt > 0.001)
        {
          wneu = tage3 [i];
   
          walt = (walt - minkurs) / dy;
          wneu = (wneu - minkurs) / dy;
 
          p.drawLine (80 + (i - startx - 1) * zoom, 375 - (walt),
                      80 + (i - startx) * zoom, 375 - (wneu) );
        }
      }


    }

    
    // stock name im obersten feld ausgeben
    p.setPen (QColor (black));
    p.setFont (QFont ("helvetica", 24, QFont::Bold));
    p.drawText (15, 60, cname.data (), strlen (cname.data ()));
    
  }

  p.end ();
  
  bitBlt (this, 0, 0, &pm);
}
