/* showchart.h
 *
 * Andreas Wst
 *
 */

#ifndef SHOWCHART_H
#define SHOWCHART_H

#include <qdialog.h>
#include <qpushbutton.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qscrollbar.h>
#include <qprogressdialog.h>
#include <stdio.h>
#include <qrect.h>
#include <qlabel.h>
#include <qfiledlg.h>
#include <qregexp.h>
#include <qmenudata.h>
#include <qpopupmenu.h>
#include <qmenubar.h>


#include <kmenubar.h>
#include <kapp.h>

#include <unistd.h>

#include "importdlg.h"
#include "wwdialog.h"


class ShowChart : public QDialog
{

        Q_OBJECT

public:

  ShowChart (QWidget *, const char *name, QColor, QColor, QColor);
  ~ShowChart();


public slots: 

  // wird von lines menu aufgerufen
  void getActivated (int);

  // bekommt data aus importdialog
  void getData (QString, QString, unsigned char, unsigned char);
 
  // erhlt den stock name aus workdialog
  void getChartName (QString);

  // erhlt den filenamen + pfad aus workdialog
  void getChartFile (QString);

  // importdialog ffnen
  void importDialog ();

  // wwdatadialog ffnen
  void workWithDataDialog ();
 
  // wenn scrollbar verandert wurde, neu zeichnen
  void getSbPos (int);


private:

  QPushButton *ok, *cancel;
  QScrollBar *sbar;

  // Rckgabewerte vom ImportDialog
  QString file;
  unsigned char date, format;
 

protected:

  // entfernt string nachfolgende leerzeichen
  char * removeSpaces (char *);

  // kurse importieren aus csv datei dd-mmm-yy
  void importDataFromCSV (const char *);

  // kurse importieren aus csv datei dd-mmm-yyyy 
  void importDataFromCSV2 (const char *);

  // importierte Daten sichern in ./data verzeichnis
  void saveData (unsigned int, QString); 
 
  // kurse mit zufallswerten initialisieren
  void initKurse ();

  // maximalkurs bestimmen
  double getMax ();
 
  // minimalkurs bestimmen
  double getMin ();

  // maximales volumen bestimmen
  long getMaxVolume ();

  // gesicherte (importierte daten laden)
  void loadData (QString);

  // tagelinien berechnen
  void calcTage (int n, double *ptage);

  // Tastendruck zum zoomen
  void mousePressEvent (QMouseEvent *);
  
  // Mausbewegung fr akt. Kurs
  void mouseMoveEvent (QMouseEvent *);

  // neuzeichnen des charts
  void paintEvent (QPaintEvent *);

  void timerEvent (QTimerEvent *);
  




  // Menubar fr Charts
  QPopupMenu *charts, *lines;
  QMenuBar *menu;

  // Label fr anzeige kurs, date, volumne
  QLabel *l;

  // arrays fr tage linien
  double tage1 [20000], tage2 [20000], tage3 [20000];

 // struktur fr chart-daten
  struct chart_daten
  {
    // kurs = close
    double kurs;
    double open, high, low;
    long volume;
    unsigned char tag, monat;
    int jahr;
  } kurse [20000];

  double minkurs, maxkurs;

  // wieviel pixel fr einen kurs
  unsigned char zoom;

  // anzahl der kurse
  unsigned int anzkurse;
 
  // pos ab der kurse gezeichnet werden
  int startx;

  // pixmap fr double buffering
  QPixmap pm;
  
  // company name
  QString cname;
  QString fileout;
  
  // wkn und ticker symbol
  char wkn [8], ticker [7];

  // maximales umsatzvolumen (bentigt fr skalierung
  long maxvol;

  // Farben fr dayaverage lines
  QColor col1, col2, col3;

};

#endif		
