/* stockdata.cpp
 *
 * Andreas Wst
 *
 */

#include "stockdata.moc" 

StockData::StockData (QWidget *parent, const char *name) 
          : QWidget (parent, name, FALSE)
{
}

StockData::~StockData ()
{
}


void StockData::startBrowser (int index)
{
  QString browser ("Starting ");
  QString br;
  QString brend;

  switch (config_data.browser)
  {
    case 0 : browser += "Netscape !";
             br = "netscape http://";
             brend = "";
             break;
    case 1 : browser += "KFM !";
             br = "kfmclient openURL 'http://";
             brend = "'";
             break;
    case 2 : browser += "Opera !";
             br = "opera http://";
             brend = "";
             break;
  }
  KMsgBox::message (this, "KStocks", browser.data ());
  
  switch (index)
  {
    case 1 : debug ("%squote.yahoo.com/q?s=%s&d=t%s &", br.data (), 
                     currentStock->getKurzel (), brend.data ());
             break;
    case 2 : debug ("%sbiz.yahoo.com/c/%c/%s.html%s &", br.data (),
                     currentStock->getKurzel () [0], 
                     currentStock->getKurzel (), brend.data ());
             break;
    case 3 : debug ("%swww.quicken.com/investments/snapshot/?symbol=%s%s &", 
                     br.data (), currentStock->getKurzel (), brend.data ());
             break;
    case 4 : debug ("%swww.quicken.com/investments/quotes/?symbol=%s%s &",
                     br.data (), currentStock->getKurzel (), brend.data ());
             break;
    case 5 : debug ("%scbs.marketwatch.com/http2_data/squote.htx?"
                    "source=htx%2Fhttp2_mw&tables=table&TICKER=%s%s &", 
                     br.data (), currentStock->getKurzel (), brend.data ());
             break;
    case 6 : debug ("%swww.marketwatch.newsalert.com/bin/headlines?"
                    "Query=%s&SearchOption=ticker%s &", br.data (),
                     currentStock->getKurzel (), brend.data ());
             break;
    case 7 : debug ("%sqs2.cnnfn.com/tq/stockquote?symbols=%s%s &", br.data (),
                     currentStock->getKurzel (), brend.data ());
             break;
    case 8 : debug ("%sorca.zacks.com/plsql/freser/zbrc?"
                    "tick=%s&comp_id=main&search=5%s &", br.data (),
                     currentStock->getKurzel (), brend.data ());
  }

}


void StockData::openBrowserWithZacks ()
{
  startBrowser (8);
}

void StockData::openBrowserWithCNNFN ()
{
  startBrowser (7);
}

void StockData::openBrowserWithCBSMarketWatchNews ()
{
  startBrowser (6);
}

void StockData::openBrowserWithCBSMarketWatchHome ()
{
  startBrowser (5);
}

void StockData::openBrowserWithYahooHome ()
{
  startBrowser (1);
}

void StockData::openBrowserWithYahooGrades ()
{
  startBrowser (2);
}

void StockData::openBrowserWithQuickenSnapshot ()
{
  startBrowser (3);
} 


void StockData::openBrowserWithQuickenQuote ()
{
  startBrowser (4);
} 


void StockData::openPopupInListView (QListViewItem *, const QPoint &, int)
{  
  QString s;

  debug ("in open popupinlistview");

  // prfen, ob aktien gewhlt und gltiger tickername
  if (strcmp (currentStock->getKurzel (), "NONE") == 0)
  {
    // kein gltiger name
    debug ("identisch NONE");
    return;
  }

  debug ("111111");

  // POPUP QUICKEN
  popquicken = new QPopupMenu (NULL, "popquicken");
  s.sprintf ("%s SNAPSHOT", currentStock->getKurzel ());
  popquicken->insertItem (s.data (), this,
                          SLOT (openBrowserWithQuickenSnapshot ()));
  s.sprintf ("%s QUOTES", currentStock->getKurzel ()),
  popquicken->insertItem (s.data (), this,
                          SLOT (openBrowserWithQuickenQuote ()));

  // POPUP YAHOO
  popyahoo = new QPopupMenu (NULL, "popyahoo");
  s.sprintf ("%s HOME", currentStock->getKurzel ());
  popyahoo->insertItem (s.data (), this, 
                        SLOT (openBrowserWithYahooHome ()));
  s.sprintf ("%s UPGRADES & DOWNGRADES", currentStock->getKurzel ());
  popyahoo->insertItem (s.data (), this, 
                        SLOT (openBrowserWithYahooGrades ()));

  // POPUP CBS MARKET WATCH
  popcbs = new QPopupMenu (NULL, "popcbs");
  s.sprintf ("%s HOME", currentStock->getKurzel ());
  popcbs->insertItem (s.data (), this,
                      SLOT (openBrowserWithCBSMarketWatchHome ()));
  s.sprintf ("%s NEWS", currentStock->getKurzel ());
  popcbs->insertItem (s.data (), this,
                      SLOT (openBrowserWithCBSMarketWatchNews ()));

  // POPUP Container
  popup = new QPopupMenu (NULL, "popup");
  s.sprintf ("Ticker Symbol : %s", currentStock->getKurzel ());
  popup->insertItem (s.data ());
  popup->insertSeparator ();

  popup->insertItem ("Visit at YAHOO", popyahoo);

  popup->insertItem ("Visit at Quicken", popquicken);

  popup->insertItem ("Visit at CBS Market Watch", popcbs);

  popup->insertItem ("Stock Quote CNNFN", this,
                     SLOT (openBrowserWithCNNFN ())); 
 
  popup->insertItem ("Zacks' Company News", this,
                     SLOT (openBrowserWithZacks ()));


  debug ("vor ende");

  popup->exec (QCursor::pos ());

  delete popup;
  delete popyahoo;
  delete popcbs;
}
