/***************************************************************************
                          DetailsData.h  -  description
		This Class handles the Details Data fields and Tab
                             -------------------
    begin                : Tue Jan 25 2000
    copyright            : (C) 2000 by Yoan Adida
    email                : yoan.adida@lip6.fr
 ***************************************************************************/
#include <qdialog.h>
#include <qdatetm.h>
#include <qpixmap.h>
#include <qlayout.h>
#include <kdatepik.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qstring.h>
#include <kwizard.h>
#define MAX_DETAILS 23

class DetailsData : public QWidget
{
    Q_OBJECT

public:

    DetailsData
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );

    virtual ~DetailsData();

signals :
	void signal_detailsdata_apply(QString);

public slots:
	void slot_detailsdata_receivedetails(QString);

protected slots:

    virtual void slot_details_responsable_textchanged(const char*);
    virtual void slot_details_service_returnpressed();
    virtual void slot_details_weddingday_dateselected(QDate);
    virtual void slot_details_spouse_returnpressed();
    virtual void slot_details_birthday_returnpressed();
    virtual void slot_details_birthday_textchanged(const char*);
    virtual void slot_details_nickname_textchanged(const char*);
    virtual void slot_details_job_textchanged(const char*);
    virtual void slot_details_kid_activatedint(int);
    virtual void slot_details_assistant_textchanged(const char*);
    virtual void slot_details_icq_returnpressed();
    virtual void slot_details_closestbirthday_textchanged(const char*);
    virtual void slot_details_assistant_returnpressed();
    virtual void slot_details_kid_returnpressed();
    virtual void slot_details_weddingday_returnpressed();
    virtual void slot_details_birthday_dateselected(QDate);
    virtual void slot_details_kidbirthday_textchanged(const char*);
    virtual void slot_details_weddingday_textchanged(const char*);
    virtual void slot_details_internetbook_returnpressed();
    virtual void slot_details_internetbook_textchanged(const char*);
    virtual void slot_details_nickname_returnpressed();
    virtual void slot_details_responsable_returnpressed();
    virtual void slot_details_kidbirthday_dateselected(QDate);
    virtual void slot_details_icq_textchanged(const char*);
    virtual void slot_details_kid_textchanged(const char*);
    virtual void slot_details_kidbirthday_clicked();
    virtual void slot_details_spousebirthday_clicked();
    virtual void slot_details_office_textchanged(const char*);
    virtual void slot_details_office_returnpressed();
    virtual void slot_details_kidbirthday_returnpressed();
    virtual void slot_details_kid_highlightedint(int);
    virtual void slot_details_birthday_clicked();
    virtual void slot_details_service_textchanged(const char*);
    virtual void slot_details_alias_textchanged(const char*);
    virtual void slot_details_job_returnpressed();
    virtual void slot_details_spousebirthday_dateselected(QDate);
    virtual void slot_details_spousebirthday_returnpressed();
    virtual void slot_details_weddingday_clicked();
    virtual void slot_details_spousebirthday_textchanged(const char*);
    virtual void slot_details_spouse_textchanged(const char*);
    virtual void slot_details_alias_returnpressed();
    virtual void slot_details_closestbirthday_returnpressed();
    void slot_detailsdata_apply();

protected:
	QLabel *Label_Service;
	QLabel *Label_Office;
	QLabel *Label_Assistant;
	QLabel *Label_Job;
	QLabel *Label_Responsable;
	QLabel *Label_NickName;
	QLabel *Label_Alias;
	QLabel *Label_Internet_Book;
	QLabel *Label_Birthday;
	QLabel *Label_Spouse;
	QLabel *Label_Spouse_Birthday;
	QLabel *Label_Wedding_Day;
	QLabel *Label_Kid_BirthDay;
	QLabel *Label_Closest_Birthday;
	QLabel *Label_ICQ;
	QLineEdit *LineEdit_Service;
	QLineEdit *LineEdit_Office;
	QLineEdit *LineEdit_Assistant;
	QLineEdit *LineEdit_Job;
	QLineEdit *LineEdit_Responsable;
	QLineEdit *LineEdit_Nickname;
	QLineEdit *LineEdit_Alias;
	QLineEdit *LineEdit_Internetbook;
	QLineEdit *LineEdit_Birthday;
	QLineEdit *LineEdit_Spouse;
	QLineEdit *LineEdit_Spousebirthday;
	QLineEdit *LineEdit_Weddingday;
	QLineEdit *LineEdit_Kid;
	QLineEdit *LineEdit_Kidbirthday;
	QLineEdit *LineEdit_Closestbirthday;
	QLineEdit *LineEdit_ICQ;
	QComboBox *ComboBox_Kid;
	QPushButton *PushButton_Birthday;
	QPushButton *PushButton_Spousebirthday;
	QPushButton *PushButton_Weddingday;
	QPushButton *PushButton_Kidbirthday;
	KDialog *Dialog_Date;
	QString *Strings[MAX_DETAILS];
	QString	String_Details;
	int kidnumber;
};
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
