/*  pcl727-driver.h
 *  (c) 1997,98 Samuel Kvasnica
 * 
 *  This is the Linux PCL-727 driver.
 * 
 * 
 *  Code of MLP-16 driver written by Sebastian Kuzminsky used
 */



#ifndef __PCL727_DRIVER_H
#define __PCL727_DRIVER_H


#define  PCL727_VERSION  "Linux PCL-727 driver 0.0.1, May 1 1997"
#define  PCL727_ID       "pcl727: "


#define  PCL727_MAJOR  (40)            /*  The device major number.           */

#define  PCL727_MINOR_LARGEST  (12)   /*  The largest minor number used.      */
#define  PCL727_MINOR_RANGE    (32)   /*  Number of minor numbers allocated   */
                                     /*  per card.                           */
#define  PCL727_MINOR_DAC0     (0)    /*  These minor numbers are added to    */
#define  PCL727_MINOR_DAC1     (1)    /*  the appropriate base minor number   */
#define  PCL727_MINOR_DAC2     (2)    /*  of a card to find the actual minor  */
#define  PCL727_MINOR_DAC3     (3)    /*  minor number.                       */
#define  PCL727_MINOR_DAC4     (4)    /*                                      */
#define  PCL727_MINOR_DAC5     (5)    /*                                      */
#define  PCL727_MINOR_DAC6     (6)    /*                                      */
#define  PCL727_MINOR_DAC7     (7)    /*                                      */
#define  PCL727_MINOR_DAC8     (8)    /*                                      */
#define  PCL727_MINOR_DAC9     (9)    /*                                      */
#define  PCL727_MINOR_DAC10    (10)   /*                                      */
#define  PCL727_MINOR_DAC11    (11)   /*                                      */
#define  PCL727_MINOR_DIO      (12)   /*                                      */

/*
#define  PCL727_ADC_GETL(cardnum)  \
   (inb(pcl727_card[cardnum].baseaddress + PCL727_ADC_IN)>>4)

#define  PCL727_ADC_GETH(cardnum)  \
   (inb(pcl727_card[cardnum].baseaddress + PCL727_ADC_IN + 1))
*/

#define  PCL727_DAC_SET(val, dac_num)  \
outb((val&0xf00)>>8, pcl727_card.baseaddress + dac_num*2); \
outb((val&0xff), pcl727_card.baseaddress + dac_num*2 + 1)

/*
#define  PCL727_DIGITAL_GET(cardnum)  \
   inb(pcl727_card[cardnum].baseaddress + PCL727_DIGITAL_IN)

#define  PCL727_DIGITAL_SET(val, cardnum)  \
   pcl727_card[cardnum].diglines = val;  \
   outb((pcl727_card[cardnum].diglines & 0xff), pcl727_card[cardnum].baseaddress + PCL727_DIGITAL_OUT); \
   outb(((pcl727_card[cardnum].diglines & 0xff00) >> 8), pcl727_card[cardnum].baseaddress + PCL727_DIGITAL_OUT2)
*/

/*  Miscellaneous constants.                                                 */
#define  PCL727_FALSE  (0)
#define  PCL727_TRUE   (!PCL727_FALSE)

struct pcl727_data {
   unsigned short baseaddress;   /*  Base address of card.                   */

   unsigned int diglines;       /*  Value currently on the digital lines.   */

   unsigned int dac[12];          /* Value currently on the dacs       */

   unsigned long read_in_use;    /*  Bitfield, minor numbers opened for      */
                                 /*  reading are 1's.                        */
   unsigned long write_in_use;   /*  Bitfield, minor numbers opened for      */
                                 /*  writing are 1's.                        */

//   struct semaphore sem;         /*  Block use of card (waiting for ADC).    */
//   struct wait_queue *wait_q;    /*  Sleep while waiting for interrupt.      */
};




#endif /* __PCL727_DRIVER_H */


