/**************************************************************************
 * $Id: DeviceGPIB.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef DeviceGPIB_included
#define DeviceGPIB_included

#include "dlg/DeviceGPIBData.h"

class DeviceGPIB : public DeviceGPIBData
{
    Q_OBJECT

public:

    DeviceGPIB
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );

   virtual ~DeviceGPIB();

   void setAddress(const char *str){input_address->setText(str);}   
//   void setInit(const char *str){input_init->setText(str);}   
//   void setEos(const char *str){input_eos->setText(str);}   
//   void setDCL(const bool c){input_DCL->setChecked(c);}
//   void setLLO(const bool c){input_LLO->setChecked(c);}
   void setMaster(const bool c){input_master->setChecked(c);}

   const char *getAddress(void){return(input_address->text());}   
//   const char *getInit(void){return(input_init->text());}   
//   const char *getEos(void){return(input_eos->text());}   
//   bool getDCL(void){return(input_DCL->isChecked());}
//   bool getLLO(void){return(input_LLO->isChecked());}   
   bool getMaster(void){return(input_master->isChecked());}
};
#endif // DeviceGPIB_included
