#ifdef RPC_HDR
%/**************************************************************************
% * $Id: rserial.x 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
% * $ReleaseVersion: 1.3.1 $
% *
% * RPC Protocol definition for remote device control
% *
% * This file is part of SampLin data acquisition software
% * Copyright (C) 1997,98 Samuel Kvasnica
% *
% * SampLin is free software; you can redistribute it and/or modify it
% * under the terms of the version 2 of GNU General Public License as
% * published by the Free Software Foundation.
% *
% * SampLin is distributed in the hope that it will be useful, but WITHOUT
% * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
% * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
% * for more details.
% *
% * You should have received a copy of the GNU General Public License
% * (see the file LICENSE) along with SampLin package; if not, write to the
% * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
% *
% **************************************************************************/
%
%#if DEBUG_SERVER
%#define DB(a) a
%#else
%#define DB(a)
%#endif
#endif

%#define REQ_WRITE 1
%#define REQ_READ_STR 2
%#define REQ_READ_BIN 4
%#define REQ_TEST 8
%#define REQ_OPEN 1
%#define REQ_CLOSE 2
%#define REQ_SETFL 16
%#define REQ_TCSET 32
%#define REQ_IOCTL 64

struct serial_request {
	int request;
        int handle;

	int count;
        int arg;
        int ret;
	
	string client<512>;
	string device<256>;
	opaque buffer<>;
	
};


/* the program services description */

program RSERIALPROG {
   version RSERIALVERS {
        /*
         * empty request
         *
         */	

  	 void 
         RSERIAL_NULL(void) = 0;

	/*
         * get serial remote handle (ud of remote device)
         *
         *
         */

         int
         RSERIAL_GETHANDLE(serial_request) = 1;

	/*
         * do gpib_request
         *
         *
         */

	 serial_request
         RSERIAL_DOREQUEST(serial_request) = 2;

   } = 1;
} = 0x20004321;    /* hope this has not been used by others */



