/**************************************************************************
 * $Id: rgpib.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef _RGPIB_H_RPCGEN
#define _RGPIB_H_RPCGEN

#include <rpc/rpc.h>

#define DB(a) if(debug)a

#define REQ_OPEN 0
#define REQ_CLOSE 1

extern int debug;

struct gpib_request {
	int request;
	int handle;
	int count;
	int arg;
	int pad;
	int ret;
	int ibsta;
	int iberr;
	int ibcnt;
	char *client;
	struct {
		u_int buf_len;
		char *buf_val;
	} buf;
};
typedef struct gpib_request gpib_request;

void init_gpib_request(gpib_request *);
#ifdef __cplusplus 
extern "C" bool_t xdr_gpib_request(XDR *, gpib_request*);
#elif __STDC__ 
extern  bool_t xdr_gpib_request(XDR *, gpib_request*);
#else /* Old Style C */ 
bool_t xdr_gpib_request();
#endif /* Old Style C */ 


#define RGPIBPROG ((u_long)0x20004322)
#define RGPIBVERS ((u_long)1)

#ifdef __cplusplus
#define RGPIB_NULL ((u_long)0)
extern "C" void * rgpib_null_1(void *, CLIENT *);
extern "C" void * rgpib_null_1_svc(void *, struct svc_req *);
#define RGPIB_GETHANDLE ((u_long)1)
extern "C" int * rgpib_gethandle_1(gpib_request *, CLIENT *);
extern "C" int * rgpib_gethandle_1_svc(gpib_request *, struct svc_req *);
#define RGPIB_DOREQUEST ((u_long)2)
extern "C" gpib_request * rgpib_dorequest_1(gpib_request *, CLIENT *);
extern "C" gpib_request * rgpib_dorequest_1_svc(gpib_request *, struct svc_req *);

#elif __STDC__
#define RGPIB_NULL ((u_long)0)
extern  void * rgpib_null_1(void *, CLIENT *);
extern  void * rgpib_null_1_svc(void *, struct svc_req *);
#define RGPIB_GETHANDLE ((u_long)1)
extern  int * rgpib_gethandle_1(gpib_request *, CLIENT *);
extern  int * rgpib_gethandle_1_svc(gpib_request *, struct svc_req *);
#define RGPIB_DOREQUEST ((u_long)2)
extern  gpib_request * rgpib_dorequest_1(gpib_request *, CLIENT *);
extern  gpib_request * rgpib_dorequest_1_svc(gpib_request *, struct svc_req *);

#else /* Old Style C */ 
#define RGPIB_NULL ((u_long)0)
extern  void * rgpib_null_1();
extern  void * rgpib_null_1_svc();
#define RGPIB_GETHANDLE ((u_long)1)
extern  int * rgpib_gethandle_1();
extern  int * rgpib_gethandle_1_svc();
#define RGPIB_DOREQUEST ((u_long)2)
extern  gpib_request * rgpib_dorequest_1();
extern  gpib_request * rgpib_dorequest_1_svc();
#endif /* Old Style C */ 

#endif /* !_RGPIB_H_RPCGEN */
