/**************************************************************************
 * $Id: GraphOptions.cpp 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include "GraphOptions.h"

#include "GraphOptions.moc"

#define Inherited GraphOptionsData

GraphOptions::GraphOptions
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
   setCaption( "Graph properties" );
   button_ok->setDefault(TRUE);

   dlayout = new GraphLayout(tab,"Common");
   dgrid = new GraphGrid(tab,"Grid & Axes");
   dlegend = new GraphLegend(tab,"Legend");
   
   tab -> addTab(dlayout,"Common");
   tab -> addTab(dgrid,"Grid & Axes");
   tab -> addTab(dlegend,"Legend");
}


GraphOptions::~GraphOptions()
{
}

void GraphOptions::setData(SamplinPlot *data)
{
   series=data;
   dlayout->setData(data);
   dgrid->setData(data);
   dlegend->setData(data);
}

void GraphOptions::ok()
{
   if(series!=NULL){
      dlayout->loadBack();
      dgrid->loadBack();
      dlegend->loadBack();
      emit update();
   }
   accept();
}

void GraphOptions::apply()
{
   
   if(series!=NULL){
      dlayout->loadBack();
      dgrid->loadBack();
      dlegend->loadBack();
      emit update();
   }
   
}

void GraphOptions::cancel()
{
   if(series!=NULL){
      dlayout->loadOld();
      dgrid->loadOld();
      dlegend->loadOld();
      emit update();
   }
   reject();
}
