/**************************************************************************
 * $Id: SamplinGrid.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3 beta $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef SAMPLIN_GRID_H
#define SAMPLIN_GRID_H

#include <qwt.h>
#include <qpen.h>
#include <qwt_dimap.h>
#include <qwt_scldiv.h>
#include <qpainter.h>
#include <qdstream.h>

class SamplinGrid
{

protected:

   int d_xAxis;
   int d_yAxis;
   
   bool d_xEnabled;
   bool d_yEnabled;
   bool d_xMinEnabled;
   bool d_yMinEnabled;
   
   QwtScaleDiv d_sdx;
   QwtScaleDiv d_sdy;
   
   QPen d_majPen;
   QPen d_minPen;

public:

    SamplinGrid();
    ~SamplinGrid();

   void setXAxis(int axis){d_xAxis=verifyXAxis(axis);}
   void setYAxis(int axis){d_yAxis=verifyYAxis(axis);}
   int xAxis(void) const {return d_xAxis;}
   int yAxis(void) const {return d_yAxis;}
   
   void enableX(bool tf);
   void enableY(bool tf);
   void enableXMin(bool tf);
   void enableYMin(bool tf);
   
   void setXDiv(const QwtScaleDiv &sx);
   void setYDiv(const QwtScaleDiv &sy);
   
   void setPen(const QPen &p);
   void setMajPen(const QPen &p);
   void setMinPen(const QPen &p);

   void draw(QPainter *p, const QRect &r, const QwtDiMap &mx, const QwtDiMap &my);
   
   const QPen& majPen() const { return d_majPen; }
   const QPen& minPen() const { return d_minPen; }
   
   bool xMinEnabled() const { return d_xMinEnabled; }
   bool yMinEnabled() const {return d_yMinEnabled; }
   bool xEnabled() const{ return d_xEnabled; }
   bool yEnabled() const { return d_yEnabled; }

   const QwtScaleDiv &xScaleDiv() const { return d_sdx; }
   const QwtScaleDiv &yScaleDiv() const { return d_sdy; }

};

QDataStream &operator<<( QDataStream &, const SamplinGrid &);
QDataStream &operator>>( QDataStream &, SamplinGrid &);


#endif
