#ifndef QWT_AUTOSCL_H
#define QWT_AUTOSCL_H

#include <qwt_scldiv.h>
class QwtAutoScale 
{

public:
    
    enum {None = 0, IncludeRef = 1, Symmetric = 2, Floating = 4,
	  Logarithmic = 8, Inverted = 16 };
    
protected:

    QwtScaleDiv d_scldiv;
    
    double d_minValue;			// smallest input value
    double d_maxValue;			// greatest input value

    double d_scaleMin;			// scale minimum
    double d_scaleMax;			// scale maximum
    
    double d_step;			// user-defined step size
    int d_maxMajor;			// max. no. of scale divisions
    int d_maxMinor;			// max. number of minor intervals

    int d_scaleOpt;			// scale options
    bool d_autoScale;			// autoscale mode
    
    double d_loMargin;			// margins
    double d_hiMargin;

    int d_reset;			// d_minValue and d_maxValue are invalid
    double d_ref;			// reference point
    double d_lref;			// special reference point for logarithmic scales

    bool d_autoRebuild;			// rebuild scale automatically with
					// call to 'adjust'
   bool d_scaleInv;
   void buildLinScale();
    void buildLogScale();
    void setRange(double x1, double x2);
   virtual void update(void);
   
public:
    
    QwtAutoScale();
   virtual ~QwtAutoScale();
    
    void setMaxMajor( int n );
    void setMaxMinor(int n);

    void setScale(double xmin, double xmax, double step = 0.0);
    void setAutoScale();
   void setAutoScale(bool val);
    
    void adjust( double *arr, int n, int reset = 0);
    void adjust( double x1, double x1, int reset = 0);
    void reset();
   bool isReset(void)const {return d_reset;}
   bool option(int opt) const;
    void setOptions(int opt);
    void changeOptions(int opt, bool tf);
    void setMargins(double m1, double m2);
    void setMargins(double m);
    void setReference(double r);
    void setAdjustRebuild(bool tf) { d_autoRebuild = tf; }
    void build();
    
    const QwtScaleDiv &scaleDiv() const { return d_scldiv; };
    bool autoScale() const { return d_autoScale; }
    int options() const { return d_scaleOpt; }
    int maxMajor() const { return d_maxMajor; }
    int maxMinor() const { return d_maxMinor; }

   double scaleRef(void) const {return d_ref;}
   double scaleMin(void) const {return d_scaleMin;}
   double scaleMax(void) const {return d_scaleMax;}
   double scaleStep(void) const {return d_step;}
};



#endif








