#ifndef QWT_DBLRANGE_H
#define QWT_DBLRANGE_H

class QwtDblRange
{
  
 private:
    
   double d_minValue;
   double d_maxValue;
   double d_step;
   double d_value;
   double d_exactValue;
   double d_exactPrevValue;
   double d_prevValue;
   int d_log;
   bool d_periodic;

    void setNewValue(double,int);
    
 public:

   static const double MinRelStep;
   static const double DefaultRelStep;
   static const double MinEps;
   
    QwtDblRange();
    
    void setRange(double, double, double);
    void setStep(double);
    void setPeriodic(bool);
    void setValue(double);
    void fitValue(double);
    void incValue(int);
    
    double value();
    double exactValue();
    double exactPrevValue();
    double minValue();
    double maxValue();
    double step();
    bool periodic();
    
  protected:
    
    double prevValue();
    virtual void valueChange();
    virtual void stepChange();
    virtual void rangeChange();
    
};


inline double QwtDblRange::value()
{
  return d_value;
}

inline double QwtDblRange::prevValue()
{
  return d_prevValue;
}

inline double QwtDblRange::minValue()
{
  return d_minValue;
}

inline double QwtDblRange::maxValue() 
{
  return d_maxValue;
}

inline double QwtDblRange::step()
{
  return d_step;
}

inline double QwtDblRange::exactValue() 
{
  return d_exactValue;
}

inline double QwtDblRange::exactPrevValue()
{
  return d_exactPrevValue;
}

inline bool QwtDblRange::periodic()
{
  return d_periodic;
}

inline void QwtDblRange::setPeriodic (bool x)
{
  d_periodic = x;
}

#endif

