/**************************************************************************
 * $Id: config.cpp 1.2 Thu, 18 Feb 1999 16:48:37 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include <qmessagebox.h>
#include <qdir.h>
#include "cnflib.h"
#include <kapp.h>
#include <kconfig.h>
#include <config.h>
#include "samplin.h"
#include <script.h>

struct configstruct cnf;

void createDirs(void)
{
   QString kstr,rstr;
   
   kstr=kapp->localkdedir().copy()+"/share/apps";
   
   QDir kdir(kstr);
   if(kdir.exists()==FALSE){
      QMessageBox::information(NULL,"Information","SampLin will create directory "+kstr);
      kdir.mkdir(kstr);
   }

   kstr+="/"+QString(PACKAGE)+"/";
   kdir.setPath(kstr);
   if(kdir.exists()==FALSE){
     QMessageBox::information(NULL,"Information","SampLin will create directory "+kstr);
     kdir.mkdir(kstr);
   }
  
   cnf.cnf_dir=kstr;
   
   rstr=cnf.root_dir;
   
   QDir rdir(rstr);
   if(rdir.exists()==FALSE){
      QMessageBox::information(NULL,"Information","SampLin will create base directory "+rstr);
      rdir.mkdir(rstr);
   }
   
   QDir datadir(rstr+cnf.data_dir);
   if(datadir.exists()==FALSE){
     QMessageBox::information(NULL,"Information","SampLin will create data directory "+rstr+cnf.data_dir);
     datadir.mkdir(rstr+cnf.data_dir);
   }
   
   QDir scriptsdir(rstr+cnf.scripts_dir);
   if(scriptsdir.exists()==FALSE){
     QMessageBox::information(NULL,"Information","SampLin will create script directory "+rstr+cnf.scripts_dir);
     scriptsdir.mkdir(rstr+cnf.scripts_dir);
   }
   
}

void writeConfig(void)
{
   KConfig *config;
   config=kapp->getConfig();
   
   config->setGroup("Directories");
   config->writeEntry("root_dir",cnf.root_dir);
   config->writeEntry("data_subdir",cnf.data_dir);
   config->writeEntry("scripts_subdir",cnf.scripts_dir);
   config->writeEntry("devices_file",cnf.devices_file);
   
   config->setGroup("Interpreter");
   config->writeEntry("info_level",cnf.info_level);
   config->writeEntry("mesg_window",cnf.mesg_win);
   config->writeEntry("mesg_time",cnf.mesg_time);
   config->writeEntry("auto_save",cnf.auto_save);
   config->writeEntry("interpreter_command",cnf.interpreter);
   
   config->sync();
}

void readConfig(void)
{
   KConfig *config;
   config=kapp->getConfig();

   config->reparseConfiguration();
   
   config->setGroup("Directories");
   cnf.root_dir=config->readEntry("root_dir",QDir::homeDirPath()+"/SampLin/");
   cnf.data_dir=config->readEntry("data_subdir","Data/");
   cnf.scripts_dir=config->readEntry("scripts_subdir","Scripts/");
   cnf.devices_file=config->readEntry("devices_file",DEVICES_FILE);
   
   config->setGroup("Interpreter");
   cnf.info_level=config->readNumEntry("info_level",WARNING);
   cnf.mesg_win=config->readNumEntry("mesg_window",TRUE);
   cnf.mesg_time=config->readNumEntry("mesg_time",FALSE);
   cnf.auto_save=config->readNumEntry("auto_save",FALSE);
   cnf.interpreter=config->readEntry("interpreter_command","SampLinExec");   
//   cnf.edit_command=config->readEntry("editor_command","xterm -e jed %f");
}
