%name SamplinParser
%{


/**************************************************************************
 * $Id: script.bison.y 1.2 Thu, 18 Feb 1999 16:48:37 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include "script_all.h"     /* definitions of yabasic */

%}

%define ERROR_BODY=0;
%define DEBUG 1
%define LEX_BODY = 0
%define CONSTRUCTOR_CODE \
cmp_flag=0; \
//yydebug=1;

%define MEMBERS \
public: \
virtual void yyunput(int)=0; \
virtual void create_goto(char *)=0; \
virtual void create_negate(void)=0; \
virtual void create_pushdblsymptr(char *)=0; \
virtual void create_pushdblsym(char *, int )=0; \
virtual void create_pushdblsym2(char *)=0; \
virtual void create_popdblsym(char *, int )=0; \
virtual void create_popdblsym2(char *, int)=0; \
virtual void create_pushdbl(double)=0; \
virtual void create_pushdblp(double *)=0; \
virtual void create_popdbl(double *)=0; \
virtual void create_unaryassign(int,int)=0; \
virtual void create_binop(int)=0; \
virtual void create_relop(int)=0; \
virtual void create_pushstrsym(char *)=0; \
virtual void create_popstrsym(char *)=0; \
virtual void create_concat(void)=0; \
virtual void create_pushstr(char *)=0; \
virtual void create_strrelop(int)=0; \
virtual void create_print(char)=0; \
virtual void create_myread(char)=0; \
virtual void create_myreaddlg(char)=0; \
virtual void create_prompt(char *)=0; \
virtual void create_myopen(double,char *)=0; \
virtual void create_myclose(double)=0; \
virtual void create_myswitch(double)=0; \
virtual void create_gosub(char *)=0; \
virtual void create_label(char *)=0; \
virtual void create_return(void)=0; \
virtual void create_skipper(void)=0; \
virtual void create_nop(void)=0; \
virtual void create_myend(void)=0; \
virtual void create_decide(void)=0; \
virtual void create_function(int, char *)=0; \
virtual void create_doarray(char *,int)=0; \
virtual void create_dim(char *,char)=0; \
virtual void create_restore(char *)=0; \
virtual void create_dbldata(double)=0; \
virtual void create_strdata(char *)=0; \
virtual void create_readdata(char)=0; \
virtual void create_mywait()=0; \
virtual void create_bell()=0; \
virtual void create_devopen(char *)=0; \
virtual void create_devclose(char *)=0; \
virtual void create_devrd(char *,int)=0; \
virtual void create_devrdb(char *, char *)=0; \
virtual void create_devwr(char *,int)=0; \
virtual void create_devwrb(char *, char *)=0; \
virtual void create_devctl(char *)=0; \
virtual void create_devflush(char *)=0; \
virtual void create_devseek(char *,int)=0; \
virtual void create_message(char)=0; \
virtual void create_plotfnc(int,char*,char*)=0;\
virtual void create_graphfnc(int,int,char*,char*)=0;\
virtual void create_addgraph()=0; \
virtual void create_delgraph()=0; \
virtual void create_loadgraph(int)=0; \
virtual void create_savegraph(int)=0; \
virtual void create_exportgraph(int)=0; \
virtual void create_printgraph()=0; \
virtual void create_adddlg(char *)=0; \
virtual void create_deldlg(char *)=0; \
virtual void create_hidedlg(char *)=0; \
virtual void create_showdlg(char *)=0; \
virtual void create_progressdlg(int,int)=0; \
virtual void create_addwidget(char *, int, char *, char * )=0; \
virtual void create_mysleep()=0; \
virtual void create_multi(int )=0; \
virtual void create_timer(int )=0; \
virtual void create_cursor(int )=0;\
virtual void inccounter(void)=0; \
virtual void pushdummy(void)=0; \
virtual void pushlabel(void)=0; \
virtual void poplabel(void)=0; \
virtual void swap(void)=0; \
virtual struct stackentry *pop(void)=0; \
virtual void pushgoto(void)=0; \
virtual void popgoto(void)=0;\
virtual void pushcopy(void)=0; \
virtual void pushcounter(void)=0; \
virtual void pushname(char *)=0; \
virtual void error(int, const char*,...)=0; \
virtual void pushint(int)=0; \
char const *tname(int token);\
\
enum functions { \
   MYRAN2,MYINKEY,MYREADY,MYSPOLL,MYACTIVE,MYDATE,MYTIME,ZEROARGS,MYABS,MYSGN,MYSIN,MYASIN,MYCOS,MYACOS,MYTAN,MYATAN, \
   MYEXP,MYLOG,MYLEN,MYSTR,MYCHR,MYSQRT,MYFRAC,MYRAN,MYINT,MYVAL,MYASC, \
   ONEARGS,MYATAN2,MYLEFT,MYRIGHT,TWOARGS,MYMID \
}; \
enum arraymode { \
   CALLARRAY,ASSIGNARRAY,CALLSTRINGARRAY,ASSIGNSTRINGARRAY, CALLPTRARRAY, \
   CALLPTRSTRARRAY \
}; \
enum stackmode { \
   SINGLE, ARRAY, PUSHBACK=0x0100, PUSHBEFORE=0x0200, PUSHAFTER=0x0400 \
}; \
enum plotfnc { \
PLOTADD,PLOTDEL,PLOTSETDATA,PLOTSETDATAX,PLOTSETDATAY, \
PLOTSETDATAL,PLOTSETDATAXL,PLOTSETDATAYL,PLOTGETDATA,PLOTAXES,PLOTSTYLE,\
PLOTPEN, PLOTSYMBOL\
}; \
enum graphfnc { \
GRAPHCOLORS, GRAPHAXISTITLE, GRAPHTITLE, GRAPHCOMMENT, GRAPHLEGEND, GRAPHAXISSTYLE, GRAPHAXISFLAGS, \
GRAPHAXISSCALE \
}; \
int errorlevel; \
int myflag;\
struct command *lastcommand; \
int yylineno; \
int cmp_flag;\

%union {
  double number;        /* double number */
  int token;            /* token of command */
  char *string;         /* quoted string */
  char *symbol;         /* general symbol */
  char *strsym;         /* string symbol */
  char *arraysym;       /* array symbol */
  char *arraystrsym;
  char sep;
//  int unaryop;
//  int binaryop;
}

%type <number> step_part
%type <number> const
%type <number> hashed_number
%type <symbol> dsymbol
//%type <unaryop>  unaryop

//%token_table

//%token <number> NUMBER
%token <number> DECNUMBER
%token <number> HEXNUMBER
%token <symbol> SYMBOL
%token <strsym> STRSYM
%token <string> STRING
%token <arraysym> ARRAYSYM
%token <arraystrsym> ARRAYSTRSYM
%token <sep> SEP SPC

%token FOR TO STEP NEXT GOTO GOSUB LABEL ON 
%token IF THEN ELSE ENDIF WHILE DO BREAK
%token PRINT INPUT RETURN DIM END

%token PLUSPLUS MINUSMINUS LEFTOP RIGHTOP
%token MULEQ PLUSEQ MINUSEQ DIVEQ ANDEQ OREQ XOREQ ISEQ
%token POWEQ LEFTEQ RIGHTEQ 

%token PLS MNS DVD MLP PWR AND OR XOR

%token ANDAND OROR NOT NE LE GE LT GT EQ

%token READ DATA RESTORE
%token OPEN CLOSE
%token WINDOW DOT LINE CIRCLE TEXT CLEAR PRINTER
%token WAIT BELL EOFILE

%token SIN ASIN COS ACOS TAN ATAN EXP LOG SQRT ABS SGN
%token INT FRAC RAN LEN VAL LEFT_ RIGHT_ MID STR LEN CHR INKEY ASC

%token DEVRD DEVWR DEVOPEN DEVCLOSE DEVCTL DEVSPOLL DEVSEEK DEVFLUSH

%token START CURRENT

%token MESSAGE M_INFO M_WARNING M_ERROR

%token ADDXPLOT ADDYPLOT ADDXYPLOT UPDATEXPLOT UPDATEYPLOT UPDATEXYPLOT DELPLOT TITLEGRAPH

%token ADDGRAPH DELGRAPH LOADGRAPH SAVEGRAPH EXPORTGRAPH PRINTGRAPH

%token ADDPLOT SETPLOTDATA GETPLOTDATA SETPLOTAXES SETPLOTSTYLE SETPLOTPEN SETPLOTSYMBOL
%token SETGRAPHTITLE SETGRAPHCOMMENT SETAXISTITLE SETAXISFLAGS SETAXISSCALE SETAXISSTYLE
%token SETGRAPHLEGEND SETGRAPHCOLORS
%token AUTO REF INV SYM FLT

%token LEFT, RIGHT, TOP, BOTTOM

%token ADDDLG DELDLG HIDEDLG SHOWDLG PROGRESSDLG ADDWIDGET TEXT BUTTON SWITCH LCD LED

%token DLGACTIVE INPUTDLG

%token FRAME WHEEL SELECT GRAPH KNOB LEVEL SLIDER

%token SLEEP

%token MULTI OFF IDLE DEVREADY CURSOR DEFAULT TIMER DATE TIME

%nonassoc LOWER_THAN_ELSE
%nonassoc ELSE
%nonassoc SEP SPC

%left EQ



%left OROR
%left ANDAND
%left NOT

%left ISEQ NE
%left LT LE GT GE
%left LEFTOP RIGHTOP

%left PLS MNS
%left DVD MLP
%left PWR
%left AND OR XOR

%left PLUSEQ MINUSEQ MULEQ DIVEQ ANDEQ OREQ XOREQ POWEQ LEFTEQ RIGHTEQ
%left PLUSPLUS MINUSMINUS

//%left '-' '+'
//%left '*' '/'
//%left '^'
//%left '|' '&' '~'


%nonassoc UMINUS
%nonassoc '(' ')'

%%

program: {cmp_flag=0;pushdummy();} statement_list EOFILE {poplabel();YYACCEPT;}
  ;

statement_list: statement {if (errorlevel<=ERROR) {YYABORT;}}
  | statement {if (errorlevel<=ERROR) {YYABORT;}}
    statement_list
  ;

sep_or_spc: SPC {}
  | SEP {}
  ;

statement:  sep_or_spc /* empty */ {}
  | BREAK {poplabel();pushlabel();} sep_or_spc
  | string_assignment sep_or_spc
  | assignment sep_or_spc
  | for_loop sep_or_spc
  | for_loop_c
  | if_clause
  | while_loop
  | do_while_loop
  | GOTO SYMBOL {create_goto($2);} sep_or_spc
  | GOSUB SYMBOL {create_gosub($2);} sep_or_spc
  | ON SYMBOL {create_pushdblsym($2,SINGLE);} GOTO {create_skipper();} 
    goto_list {create_nop();} sep_or_spc
  | ON SYMBOL {create_pushdblsym($2,SINGLE);} GOSUB {create_skipper();} 
    gosub_list {create_nop();} sep_or_spc
  | LABEL SYMBOL {create_label($2);} sep_or_spc
  | OPEN hashed_number ',' string_expression ',' STRING
    {create_myopen($2,$6);} sep_or_spc
  | OPEN hashed_number ',' string_expression
    {create_myopen($2,"a");} sep_or_spc
  | CLOSE hashed_number {create_myclose($2);} sep_or_spc
  | PRINT stream printlist maybecolon {} sep_or_spc
  | INPUT inputparams  {lastcommand->args=TRUE;} sep_or_spc
  | INPUTDLG inputdlgparams  {lastcommand->args=TRUE;} sep_or_spc
  | READ readlist sep_or_spc
  | DATA datalist sep_or_spc
  | RESTORE {create_restore("");} sep_or_spc
  | RESTORE SYMBOL {create_restore($2);} sep_or_spc
  | RETURN {create_return();} sep_or_spc
  | DIM dimlist sep_or_spc
  | WAIT expression {create_mywait();} sep_or_spc
  | BELL {create_bell();} sep_or_spc
  | END {create_myend();} sep_or_spc
  | DEVWR devwrparams sep_or_spc
  | DEVRD devrdparams sep_or_spc
  | DEVOPEN devopenparams sep_or_spc
  | DEVCLOSE devcloseparams sep_or_spc
  | DEVCTL devctlparams sep_or_spc
  | DEVSEEK devseekparams sep_or_spc
  | DEVFLUSH devflushparams sep_or_spc
  | MESSAGE messageparams sep_or_spc
  | SLEEP expression {create_mysleep();} sep_or_spc
  | ADDGRAPH addgraphparams sep_or_spc
  | DELGRAPH delgraphparams sep_or_spc
  | LOADGRAPH loadgraphparams sep_or_spc
  | SAVEGRAPH savegraphparams sep_or_spc
  | EXPORTGRAPH exportgraphparams sep_or_spc
  | PRINTGRAPH printgraphparams sep_or_spc
  | ADDPLOT addplotparams sep_or_spc
  | DELPLOT delplotparams sep_or_spc
  | SETPLOTDATA setplotdataparams sep_or_spc
  | GETPLOTDATA getplotdataparams sep_or_spc
  | SETPLOTAXES setplotaxesparams sep_or_spc
  | SETAXISTITLE setaxistitleparams sep_or_spc
  | SETAXISSCALE setaxisscaleparams sep_or_spc
  | SETAXISFLAGS setaxisflagsparams sep_or_spc
  | SETAXISSTYLE setaxisstyleparams sep_or_spc
  | SETGRAPHTITLE setgraphtitleparams sep_or_spc
  | SETGRAPHCOMMENT setgraphcommentparams sep_or_spc
  | SETGRAPHLEGEND setgraphlegendparams sep_or_spc
  | SETGRAPHCOLORS setgraphcolorsparams sep_or_spc
  | SETPLOTSTYLE setplotstyleparams sep_or_spc
  | SETPLOTPEN setplotpenparams sep_or_spc
  | SETPLOTSYMBOL setplotsymbolparams sep_or_spc
  | ADDDLG adddlgparams sep_or_spc
  | DELDLG deldlgparams sep_or_spc
  | HIDEDLG hidedlgparams sep_or_spc
  | SHOWDLG showdlgparams sep_or_spc
  | PROGRESSDLG progressdlgparams sep_or_spc
  | ADDWIDGET addwidgetparams sep_or_spc
  | MULTI multiparams sep_or_spc
  | IDLE {;} sep_or_spc
  | TIMER timerparams sep_or_spc
  | CURSOR cursorparams sep_or_spc
;

string_assignment: STRSYM EQ string_expression {create_popstrsym($1);}
  | STRSYM '[' {pushcounter();} indexlist ']' EQ string_expression {create_doarray($1,ASSIGNSTRINGARRAY);}
  ;

string_expression: STRSYM {create_pushstrsym($1);}
  | string_function;
  | STRING {if (errorlevel<=ERROR) {YYABORT;} create_pushstr($1);}
  | string_expression PLS string_expression {create_concat();}
  | STRSYM '[' {pushcounter();} indexlist ']' {create_doarray($1,CALLSTRINGARRAY);}
  | '(' string_expression ')'
  ;

string_function: LEFT_ '(' string_expression ',' expression ')' {create_function(MYLEFT,0);}
  | RIGHT_ '(' string_expression ',' expression ')' {create_function(MYRIGHT,0);}
  | MID '(' string_expression ',' expression ',' expression ')' {create_function(MYMID,0);}
  | STR '(' expression ')' {create_function(MYSTR,0);}
  | CHR '(' expression ')' {create_function(MYCHR,0);}
  | INKEY {create_function(MYINKEY,0);}
  | DATE {create_function(MYDATE,0);}
  | TIME {create_function(MYTIME,0);}
;

assignment: 
    dsymbol EQ expression {create_popdblsym2($1,0);}
  | unaryassign {}
;

unaryassign: 
    PLUSPLUS  dsymbol {create_pushdblsymptr($2);create_pushdbl(1);create_unaryassign(PLUSEQ,0);}
  | dsymbol PLUSPLUS {create_pushdblsymptr($1);create_pushdbl(1);create_unaryassign(PLUSEQ,0);}
  | MINUSMINUS  dsymbol {create_pushdblsymptr($2);create_pushdbl(1);create_unaryassign(MINUSEQ,0);}
  | dsymbol MINUSMINUS {create_pushdblsymptr($1);create_pushdbl(1);create_unaryassign(MINUSEQ,0);}
//  | dsymbol {create_pushdblsymptr($1);} unaryop expression {create_unaryassign($3,0);}
  | dsymbol {create_pushdblsymptr($1);} PLUSEQ expression {create_unaryassign(PLUSEQ,0);}
  | dsymbol {create_pushdblsymptr($1);} MINUSEQ expression {create_unaryassign(MINUSEQ,0);}
  | dsymbol {create_pushdblsymptr($1);} MULEQ expression {create_unaryassign(MULEQ,0);}
  | dsymbol {create_pushdblsymptr($1);} DIVEQ expression {create_unaryassign(DIVEQ,0);}
  | dsymbol {create_pushdblsymptr($1);} POWEQ expression {create_unaryassign(POWEQ,0);}
  | dsymbol {create_pushdblsymptr($1);} ANDEQ expression {create_unaryassign(ANDEQ,0);}
  | dsymbol {create_pushdblsymptr($1);} OREQ expression {create_unaryassign(OREQ,0);}
  | dsymbol {create_pushdblsymptr($1);} XOREQ expression {create_unaryassign(XOREQ,0);}
  | dsymbol {create_pushdblsymptr($1);} LEFTEQ expression {create_unaryassign(LEFTEQ,0);}
  | dsymbol {create_pushdblsymptr($1);} RIGHTEQ expression {create_unaryassign(RIGHTEQ,0);}
;

//unaryop: 
//    PLUSEQ  {$$=$1}
//  | MINUSEQ {$$=$1}
//  | MULEQ   {$$=$1}
//  | DIVEQ   {$$=$1}
//  | POWEQ   {$$=$1}
//  | ANDEQ   {$$=$1}
//  | OREQ    {$$=$1}
//  | XOREQ   {$$=$1}
//  | LEFTEQ  {$$=$1}
//  | RIGHTEQ {$$=$1}
//;

//binaryop:
//    '+' {$$='+'}
//  | '-' {$$='-'}
//  | '*' {$$='*'}
//  | '/' {$$='/'}
//  | '^' {$$='^'}
//  | '&' {$$='&'}
//  | '|' {$$='|'}
//  | '~' {$$='~'}
//   LEFTOP  {$$=$1}
//  | RIGHTOP {$$=$1}
//  | ISEQ {$$=$1}
//  | NE {$$=$1}
//  | LT {$$=$1}
//  | LE {$$=$1}
//  | GT {$$=$1}
//  | GE {$$=$1}
//  | OR {$$=$1}
//  | AND {$$=$1}
//;

dsymbol: SYMBOL {pushint(SINGLE);$$=$1}
    | SYMBOL '[' {pushcounter();} indexlist ']'{pushint(ARRAY);$$=$1}
;

expression: 
    DECNUMBER {create_pushdbl($1);}
  | HEXNUMBER {create_pushdbl($1);}
  | function
  | dsymbol {create_pushdblsym2($1);}
  | dsymbol EQ expression {create_popdblsym2($1,PUSHBACK);
      if(cmp_flag)error(WARNING,"Possible incorrect assignment");}
  | '(' expression ')' 
//  | expression binaryop expression {create_binop($2);}
  | expression PLS expression {create_binop(PLS);}
  | expression MNS expression {create_binop(MNS);}
  | expression MLP expression {create_binop(MLP);}
  | expression DVD expression {create_binop(DVD);}
  | expression PWR expression {create_binop(PWR);}
  | expression AND expression {create_binop(AND);}
  | expression OR  expression {create_binop(OR);}
  | expression XOR expression {create_binop(XOR);}
  | expression LEFTOP  expression {create_binop(LEFTOP);}
  | expression RIGHTOP expression {create_binop(LEFTOP);}
  | MNS expression %prec UMINUS {create_negate();}
  | PLUSPLUS  dsymbol {create_pushdblsymptr($2);create_pushdbl(1);create_unaryassign(PLUSEQ,PUSHAFTER);}
  | MINUSMINUS  dsymbol {create_pushdblsymptr($2);create_pushdbl(1);create_unaryassign(MINUSMINUS,PUSHAFTER);}
//  | dsymbol unaryop {create_pushdblsymptr($1);create_pushdbl(1);create_unaryassign($2,PUSHBEFORE);}
  | dsymbol PLUSPLUS {create_pushdblsymptr($1);create_pushdbl(1);create_unaryassign(PLUSEQ,PUSHBEFORE);}
  | dsymbol MINUSMINUS {create_pushdblsymptr($1);create_pushdbl(1);create_unaryassign(MINUSMINUS,PUSHBEFORE);}
  | dsymbol PLUSEQ {create_pushdblsymptr($1);} expression {create_unaryassign(PLUSEQ,PUSHAFTER);}
  | dsymbol MINUSEQ {create_pushdblsymptr($1);} expression {create_unaryassign(MINUSEQ,PUSHAFTER);}
  | dsymbol MULEQ {create_pushdblsymptr($1);} expression {create_unaryassign(MULEQ,PUSHAFTER);}
  | dsymbol DIVEQ {create_pushdblsymptr($1);} expression {create_unaryassign(DIVEQ,PUSHAFTER);}
  | dsymbol POWEQ {create_pushdblsymptr($1);} expression {create_unaryassign(POWEQ,PUSHAFTER);}
  | dsymbol ANDEQ {create_pushdblsymptr($1);} expression {create_unaryassign(ANDEQ,PUSHAFTER);}
  | dsymbol OREQ {create_pushdblsymptr($1);} expression {create_unaryassign(OREQ,PUSHAFTER);}
  | dsymbol XOREQ {create_pushdblsymptr($1);} expression {create_unaryassign(XOREQ,PUSHAFTER);}
  | dsymbol LEFTEQ {create_pushdblsymptr($1);} expression {create_unaryassign(LEFTEQ,PUSHAFTER);}
  | dsymbol RIGHTEQ {create_pushdblsymptr($1);} expression {create_unaryassign(RIGHTEQ,PUSHAFTER);}
  | expression OROR expression {create_binop(OROR);}
  | expression ANDAND expression {create_binop(ANDAND);}
  | NOT expression {create_binop(NOT);}
  | string_expression ISEQ string_expression {create_strrelop(ISEQ);}
  | string_expression EQ string_expression {create_strrelop(ISEQ);}
  | string_expression NE string_expression {create_strrelop(NE);}
  | string_expression LT string_expression {create_strrelop(LT);}
  | string_expression GT string_expression {create_strrelop(GT);}
  | string_expression LE string_expression {create_strrelop(LE);}
  | string_expression GE string_expression {create_strrelop(GE);}
  | expression ISEQ expression {create_relop(ISEQ);}
  | expression NE expression {create_relop(NE);}
  | expression LT expression {create_relop(LT);}
  | expression LE expression {create_relop(LE);}
  | expression GT expression {create_relop(GT);}
  | expression GE expression {create_relop(GE);}
;

function: SIN '(' expression ')' {create_function(MYSIN,0)}
  | ASIN '(' expression ')' {create_function(MYASIN,0)}
  | COS '(' expression ')' {create_function(MYCOS,0)}
  | ACOS '(' expression ')' {create_function(MYACOS,0)}
  | TAN '(' expression ')' {create_function(MYTAN,0)}
  | ATAN '(' expression ')' {create_function(MYATAN,0)}
  | ATAN '(' expression ',' expression  ')' {create_function(MYATAN2,0)}
  | EXP '(' expression ')' {create_function(MYEXP,0)}
  | LOG '(' expression ')' {create_function(MYLOG,0)}
  | SQRT '(' expression ')' {create_function(MYSQRT,0)}
  | INT '(' expression ')' {create_function(MYINT,0)}
  | FRAC '(' expression ')' {create_function(MYFRAC,0)}
  | RAN '(' expression ')' {create_function(MYRAN,0)}
  | RAN '(' ')' {create_function(MYRAN2,0)}
  | LEN '(' string_expression ')' {create_function(MYLEN,0)}
  | VAL '(' string_expression ')' {create_function(MYVAL,0)}
  | DEVREADY '(' SYMBOL ')' {create_function(MYREADY,$3)}
  | DLGACTIVE '(' SYMBOL ')' {create_function(MYACTIVE,$3)}
  | DEVSPOLL '(' SYMBOL ')' {create_function(MYSPOLL,$3)}
  | ASC '(' string_expression ')' {create_function(MYASC,0)}
  | ABS '(' expression ')' {create_function(MYABS,0)}
  | SGN '(' expression ')' {create_function(MYSGN,0)}
;

const: DECNUMBER {$$=$1}
  | PLS DECNUMBER {$$=$2}
  | MNS DECNUMBER {$$=-$2;}
  | HEXNUMBER {$$=$1}
  | PLS HEXNUMBER {$$=$2}
  | MNS HEXNUMBER {$$=-$2;}  
  ;

dimlist: SYMBOL '[' {pushcounter();} indexlist ']' {create_dim($1,'d');}
  | dimlist ',' SYMBOL '[' {pushcounter();} indexlist ']' {create_dim($3,'d');}
  | STRSYM '[' {pushcounter();} indexlist ']' {create_dim($1,'s');}
  | dimlist ',' STRSYM '[' {pushcounter();} indexlist ']' {create_dim($3,'s');}
  ;

indexlist: expression {inccounter();}
  | indexlist ',' expression {inccounter();}
  ;
 
for_loop: FOR SYMBOL EQ expression 
          {pushname($2);create_popdblsym($2,SINGLE);pushgoto();create_pushdblsym($2,SINGLE);}
	  TO expression
	  step_part {
	     create_relop(($8>0)? LE:GE );
             create_decide();
             pushlabel();} sep_or_spc
	  
          statement_list {
             create_pushdbl($8);
	     create_pushdblsym($2,SINGLE);	
             create_binop(PLS);
	     create_popdblsym($2,SINGLE);
             swap();popgoto();poplabel();}
          next_or_eofile next_symbol
;

for_loop_c: FOR ignore_spc '(' assignment SEP {pushgoto();} expression 
            {create_decide();pushlabel();swap();pushdummy();} SEP assignment ')' ignore_spc
            for_body {swap();popgoto();swap();poplabel();poplabel();}
;

for_body: statement
  | '{' statement_list '}'
;


while_loop: WHILE {pushgoto();} '(' expression ')' {create_decide();
            pushlabel();swap();pushdummy();} 
            ignore_spc  while_body {swap();popgoto();swap();poplabel();poplabel();}
;

while_body: statement
  | '{' statement_list '}'

;

do_while_loop: DO {pushgoto();pushdummy();} while_body {swap();} ignore_spc WHILE '(' expression ')' 
               {create_decide();pushlabel();swap();popgoto();poplabel();poplabel();} sep_or_spc
;


next_or_eofile: NEXT
  | EOFILE {error(ERROR,"'next'-statement is missing"); YYABORT;}

step_part: {$$=1.0;} /* can be omitted */
  | STEP const {$$=$2;}
  ;

next_symbol:  {pop();}/* can be omitted */
  | SYMBOL {if (strcmp((char *)(pop()->pointer),$1)) {error(ERROR,"'for' and 'next' do not match"); YYABORT;}}
  ;

if_clause: IF {cmp_flag=1;} '(' expression ')'{error(DIAGNOSTIC,"begin of else-if statement");cmp_flag=0;}
           if_clause2
;


if_clause2: /*IF comparison*/ {create_decide();pushlabel();swap();}
           THEN statement_list {swap();pushlabel();swap();poplabel();swap();}
           else_part {swap();poplabel();}
           endif_or_eof
	|  //IF '(' {cmp_flag=1;error(DIAGNOSTIC,"begin of else-if statement");} expression {cmp_flag=0;} ')'
	   ignore_spc {create_decide();pushlabel();swap();}
           if_part_c {swap();pushlabel();swap();poplabel();swap();}
	   ignore_spc else_part_c {swap();poplabel();
	   error(DIAGNOSTIC,"end of else-if statement");
	   /*YYBACKUP(SEP,yylval);*/}
;

if_part_c: 
    '{' statement_list '}'
  | statement
;

else_part_c: /* empty */ %prec LOWER_THAN_ELSE {error(DIAGNOSTIC,"got if without else\n");}
    | ELSE if_part_c {error(DIAGNOSTIC,"got if with else\n");}
//    | /*SEP*/ ignore_sep ELSE ignore_sep if_part_c {error(DIAGNOSTIC,"got if with else\n");}
;

ignore_spc: /* empty */  %prec LOWER_THAN_ELSE
 |  SPC ignore_spc  {}
;

//end_of_group: {error(ERROR,"Right parenthesis } missing");YYABORT;}
//    |'}'
//    | '{' {error(ERROR,"Right parenthesis } missing");YYABORT;}
//    | EOFILE {error(ERROR,"Right parenthesis } missing");YYABORT;}
//;

endif_or_eof: ENDIF
  | EOFILE {error(ERROR,"'endif'-statement is missing"); YYABORT;}

//comparison: /* '(' comparison ')'*/
//   comparison OR comparison {create_boole('|');}
//  | comparison AND comparison {create_boole('&');}
//  | NOT comparison {create_boole('!');}
//  | string_expression EQ string_expression {create_strrelop('=');}
//  | string_expression NE string_expression {create_strrelop('!');}
//  | expression EQ expression {create_relop('=');}
//  | expression NE expression {create_relop('!');}
//  | expression LT expression {create_relop('<');}
//  | expression LE expression {create_relop('{');}
//  | expression GT expression {create_relop('>');}
//  | expression GE expression {create_relop('}');}
//;

else_part: /* can be omitted */
  | ELSE statement_list
  ;

inputlist: input
  | inputlist ',' input
  ;

input: dsymbol {create_pushdblsymptr($1);create_myread('d');}
  | STRSYM {create_pushstrsym($1);create_myread('s');create_popstrsym($1);}
  | STRSYM '[' {pushcounter();} indexlist ']' 
    {pushcopy();create_doarray($1,CALLSTRINGARRAY);create_myread('s');create_doarray($1,ASSIGNSTRINGARRAY);}
  ;
inputdlglist: inputdlg
  | inputdlglist ',' inputdlg
  ;

inputdlg: dsymbol {create_pushdblsymptr($1);create_myreaddlg('d');}
  | STRSYM {create_pushstrsym($1);create_myreaddlg('s');create_popstrsym($1);}
  | STRSYM '[' {pushcounter();} indexlist ']' 
    {pushcopy();create_doarray($1,CALLSTRINGARRAY);create_myreaddlg('s');create_doarray($1,ASSIGNSTRINGARRAY);}
  ;

readlist: readitem
  | readlist ',' readitem
  ;

readitem: SYMBOL {create_readdata('d');create_popdblsym($1,SINGLE);}
  | SYMBOL '[' {pushcounter();} indexlist ']' 
    {create_readdata('d');create_doarray($1,ASSIGNARRAY);}
  | STRSYM {create_readdata('s');create_popstrsym($1);}
  | STRSYM '[' {pushcounter();} indexlist ']' 
    {create_readdata('s');create_doarray($1,ASSIGNSTRINGARRAY);}
  ;

datalist: STRING {create_strdata($1);}
  | const {create_dbldata($1);}
  | datalist ','  STRING {create_strdata($3);}
  | datalist ',' const {create_dbldata($3);}
  ;

prompt: /* possible empty */ {create_prompt("?");}
  | STRING ',' {create_prompt($1);}
  ;

printlist:  /* possible empty */
  | expression {create_print('d');}
  | printlist ',' expression {create_print('d');} 
  | string_expression {create_print('s');} 
  | printlist ',' string_expression {create_print('s');}
  ;
  
devopenparams: SYMBOL {create_devopen($1);}
  ;

devcloseparams: SYMBOL {create_devclose($1);}
  ;

devwrparams: SYMBOL ',' string_expression {create_devwr($1,0);}
  |  SYMBOL ',' string_expression ',' expression {create_devwr($1,1);}
  |  SYMBOL ',' ARRAYSYM ',' expression ',' expression {create_devwrb($1,$3);}
  ;

devrdparams: SYMBOL ',' STRSYM {create_devrd($1,0);create_popstrsym($3);} 
  |  SYMBOL ',' STRSYM ',' expression {create_devrd($1,1);create_popstrsym($3);} 
  |  SYMBOL ',' ARRAYSYM ',' expression ',' expression {create_devrdb($1,$3);}
  ;

devctlparams: SYMBOL ',' expression ',' expression {create_devctl($1);}
  |  SYMBOL ',' expression ',' '&' dsymbol {create_pushdblsymptr($6);create_devctl($1);}
;
  
devflushparams: SYMBOL {create_devflush($1);}
  ;
devseekparams: SYMBOL ',' START ',' expression {create_devseek($1,SEEK_SET);}
| SYMBOL ',' CURRENT ',' expression {create_devseek($1,SEEK_CUR);}
| SYMBOL ',' END ',' expression {create_devseek($1,SEEK_END);}
  ;

addplotparams: string_expression ',' string_expression {create_plotfnc(PLOTADD,0,0);}
;
setplotdataparams: string_expression ',' string_expression ',' ARRAYSYM ','
  ARRAYSYM {create_plotfnc(PLOTSETDATA,$5,$7);}
|  string_expression ',' string_expression ',' ARRAYSYM ','
  ARRAYSYM ',' expression {create_plotfnc(PLOTSETDATAL,$5,$7);}
| string_expression ',' string_expression ',' ARRAYSYM ',' expression ',' expression
  {create_plotfnc(PLOTSETDATAX,$5,0);}
| string_expression ',' string_expression ',' ARRAYSYM ',' expression ',' expression ',' expression
  {create_plotfnc(PLOTSETDATAXL,$5,0);}
| string_expression ',' string_expression ',' expression ',' expression ',' ARRAYSYM
  {create_plotfnc(PLOTSETDATAY,$9,0);}
| string_expression ',' string_expression ',' expression ',' expression ',' ARRAYSYM ','
  expression {create_plotfnc(PLOTSETDATAYL,$9,0);}
;
getplotdataparams: string_expression ',' string_expression ',' ARRAYSYM ','
ARRAYSYM {create_plotfnc(PLOTGETDATA,$5,$7);}
;
setplotaxesparams: string_expression ',' string_expression ',' SYMBOL ',' SYMBOL
{create_plotfnc(PLOTAXES,$5,$7);}
;
setaxistitleparams: string_expression ',' SYMBOL ',' string_expression
{create_graphfnc(GRAPHAXISTITLE,0,$3,0);}
;
setaxisscaleparams: string_expression ',' SYMBOL ',' AUTO
  {create_graphfnc(GRAPHAXISSCALE,0,$3,0);}
| string_expression ',' SYMBOL ',' AUTO ',' expression
  {create_graphfnc(GRAPHAXISSCALE,1,$3,0);}
| string_expression ',' SYMBOL ',' AUTO ',' expression ',' expression 
  {create_graphfnc(GRAPHAXISSCALE,2,$3,0);}
| string_expression ',' SYMBOL ',' expression ',' expression ',' expression
  {create_graphfnc(GRAPHAXISSCALE,3,$3,0);}
| string_expression ',' SYMBOL ',' expression ',' expression
  ',' expression ',' expression {create_graphfnc(GRAPHAXISSCALE,4,$3,0);}
| string_expression ',' SYMBOL ',' expression ',' expression ',' expression
  ',' expression ',' expression {create_graphfnc(GRAPHAXISSCALE,5,$3,0);}
;
setaxisflagsparams:  string_expression ',' SYMBOL ',' {myflag=0;} axisflaglist
{create_graphfnc(GRAPHAXISFLAGS,myflag,$3,0);}
;

axisflaglist:
   axisflag
 | axisflaglist ',' axisflag
;

axisflag:
  | LOG {myflag|=8;}
  | SYM {myflag|=2;}
  | INV {myflag|=16;}
  | REF {myflag|=1;}
  | FLT {myflag|=4;}
;

setaxisstyleparams: string_expression ',' SYMBOL ',' SYMBOL ',' expression
{create_graphfnc(GRAPHAXISSTYLE,0,$3,$5);}
|string_expression ',' SYMBOL ',' SYMBOL
{create_graphfnc(GRAPHAXISSTYLE,1,$3,$5);}
;

setgraphtitleparams: string_expression ',' string_expression
{create_graphfnc(GRAPHTITLE,0,0,0);}
;
setgraphcommentparams: string_expression ',' SYMBOL
{create_graphfnc(GRAPHCOMMENT,0,0,$3);}
| string_expression ',' SYMBOL ',' string_expression
{create_graphfnc(GRAPHCOMMENT,1,0,$3);}
;
setgraphlegendparams: string_expression ',' SYMBOL
{create_graphfnc(GRAPHLEGEND,0,0,$3);}
;
setgraphcolorsparams: string_expression ',' string_expression ','
string_expression {create_graphfnc(GRAPHCOLORS,0,0,0);}
;

//axesparams: LEFT ',' BOTTOM {create_plotfnc(PLOTAXES,yLeft,xBottom);}
//| LEFT ',' TOP {create_plotfnc(PLOTAXES,yLeft,xTop);}
//| RIGHT ',' BOTTOM {create_plotfnc(PLOTAXES,yRight,xBottom);}
//| RIGHT ',' TOP {create_plotfnc(PLOTAXES,yRight,xTop);}
//;
setplotstyleparams: string_expression ',' string_expression ',' SYMBOL {create_plotfnc(PLOTSTYLE,$5,0);}
;
setplotpenparams: string_expression ',' string_expression ',' SYMBOL ',' expression ',' string_expression {create_plotfnc(PLOTPEN,$5,0);}
;
setplotsymbolparams: string_expression ',' string_expression ',' SYMBOL ','
expression ',' expression ',' string_expression ',' string_expression {create_plotfnc(PLOTSYMBOL,$5,0);}
;

delplotparams: string_expression ',' string_expression {create_plotfnc(PLOTDEL,0,0);}
;

//addyplotparams: string_expression ',' string_expression ','  expression ',' expression ',' ARRAYSYM ',' string_expression {create_addplot(1,$9,0);}
//  ;
//addxplotparams: string_expression ',' string_expression ',' ARRAYSYM ',' expression ',' expression ',' string_expression {create_addplot(2,$5,0);}
//  ;
//addxyplotparams: string_expression ',' string_expression ',' ARRAYSYM ',' ARRAYSYM ',' string_expression {create_addplot(3,$5,$7);}
//  ;

//updateyplotparams: string_expression ',' string_expression ','  expression ',' expression ',' ARRAYSYM ',' string_expression {create_updateplot(1,$9,0);}
//  ;
//updatexplotparams: string_expression ',' string_expression ',' ARRAYSYM ',' expression ',' expression ',' string_expression {create_updateplot(2,$5,0);}
//  ;
//updatexyplotparams: string_expression ',' string_expression ',' ARRAYSYM ',' ARRAYSYM ',' string_expression {create_updateplot(3,$5,$7);}
//  ;

//delplotparams: string_expression ',' string_expression {create_delplot();}
//  ;    
  
addgraphparams: string_expression {create_addgraph();}
  ;
  
delgraphparams: string_expression {create_delgraph();}
  ;  

loadgraphparams: string_expression {create_loadgraph(0);}
  | string_expression ',' string_expression {create_loadgraph(1);}
  ;

savegraphparams: string_expression {create_savegraph(0);}
  | string_expression ',' string_expression {create_savegraph(1);}
  ;
  
exportgraphparams: string_expression {create_exportgraph(0);}
  | string_expression ',' string_expression {create_exportgraph(1);}
  ;
  
printgraphparams: string_expression {create_printgraph();}
  ;  

//titlegraphparams: string_expression ',' string_expression ',' string_expression ',' string_expression {create_titlegraph();}
//  ;    
  
adddlgparams: SYMBOL ',' string_expression {create_adddlg($1);}
  ;
  
deldlgparams: SYMBOL {create_deldlg($1);}
  ;    

hidedlgparams: SYMBOL {create_hidedlg($1);}
  ;    

showdlgparams: SYMBOL {create_showdlg($1);}
  ;    

progressdlgparams: string_expression ',' expression {create_progressdlg(0,0);}
  | expression {create_progressdlg(1,0);}
  ;

addwidgetparams: 
//SYMBOL ',' TEXT ',' expression ',' expression ','
//    expression ',' expression ',' STRSYM
//    {create_addwidget($1,WIDGET_TEXT,$13,0);}
//  |
   SYMBOL ',' TEXT ',' expression ',' expression ','
    expression ',' expression ',' string_expression
    {create_addwidget($1,WIDGET_TEXT,0,0);}    
  | SYMBOL ',' INPUT ',' expression ',' expression ',' expression ','
    expression ',' STRSYM {create_addwidget($1,WIDGET_INPUT,$13,0);} 
  | SYMBOL ',' INPUT ',' expression ',' expression ',' expression ','
    expression ',' STRSYM '[' {pushcounter();} indexlist ']' 
    {create_doarray($13,CALLPTRSTRARRAY);
    create_addwidget($1,WIDGET_INPUTA,$13,0);} 
  | SYMBOL ',' BUTTON ',' expression ',' expression ',' expression ','
    expression ',' string_expression ',' SYMBOL {create_addwidget($1,
    WIDGET_BUTTON, $15,0);}
  | SYMBOL ',' SWITCH ',' expression ',' expression ',' expression ','
    expression ',' string_expression ',' SYMBOL ',' SYMBOL 
    {create_addwidget($1,WIDGET_SWITCH,$15,$17);}
  | SYMBOL ',' LCD ',' expression ',' expression ',' expression ','
    expression ',' expression ',' expression ',' SYMBOL ',' string_expression
    {create_addwidget($1, WIDGET_LCD,$17,0);}
  | SYMBOL ',' LED ',' expression ',' expression ',' expression ','
    expression ',' SYMBOL ',' string_expression ',' string_expression {create_addwidget($1, WIDGET_LED,$13,0);}
  | SYMBOL ',' LED ',' expression ',' expression ',' expression ','
    expression ',' SYMBOL 
    '[' {pushcounter();} indexlist ']' 
    {create_doarray($13,CALLPTRARRAY);}    
    ',' string_expression ',' string_expression
    {create_addwidget($1, WIDGET_LEDA,$13,0);}    
  | SYMBOL ',' FRAME ',' expression ',' expression ',' expression ','
    expression ',' expression ',' expression {create_addwidget($1,
    WIDGET_FRAME,0,0);}

  | SYMBOL ',' WHEEL ',' expression ',' expression ',' expression ','
    expression ',' expression ',' expression ',' expression ',' expression ','
    SYMBOL {create_addwidget($1, WIDGET_WHEEL,0,$21);}    

  | SYMBOL ',' SELECT ',' expression ',' expression ',' expression ','
    expression ',' ARRAYSTRSYM ',' SYMBOL {create_addwidget($1,
    WIDGET_SELECT, $13,$15);}    

  | SYMBOL ',' GRAPH ',' expression ',' expression ',' expression ',' expression
  ',' string_expression
  {create_addwidget($1, WIDGET_GRAPH, 0,0);}

  | SYMBOL ',' KNOB ',' expression ',' expression ',' expression ',' expression
  ',' expression ',' expression ',' expression ',' SYMBOL
  {create_addwidget($1, WIDGET_KNOB, 0, $19);}
  
  | SYMBOL ',' LEVEL ',' expression ',' expression ',' expression ',' expression
  ',' expression ',' expression ',' expression ',' string_expression ','
  SYMBOL ',' expression
  {create_addwidget($1, WIDGET_LEVEL, 0, $21);}

  | SYMBOL ',' SLIDER ',' expression ',' expression ',' expression ',' expression
  ',' expression ',' expression ',' expression ',' SYMBOL ',' expression
  {create_addwidget($1, WIDGET_SLIDER, 0, $19);}
;    

multiparams: ON {create_multi(1);}
  | OFF {create_multi(0);}
;

timerparams: ON {create_timer(1);}
  | OFF {create_timer(0);}
;

cursorparams: WAIT {create_cursor(1);}
  | DEFAULT {create_cursor(0);}
;

messageparams:  /* possible empty */
  | string_expression {create_message('i');}
  | M_INFO ',' string_expression {create_message('i');}
  | M_WARNING ',' string_expression {create_message('w');}
  | M_ERROR ',' string_expression {create_message('e');}
  ;

inputparams: stream  prompt  inputlist

inputdlgparams: prompt inputdlglist

stream: /* possible empty */ {create_myswitch(0.0);}
  | '#' DECNUMBER ',' {create_myswitch($2);}
  ;

hashed_number: '#' DECNUMBER {$$=$2;}
  | DECNUMBER {$$=$1;} /* need not contain hash */
  ;

maybecolon: /* can be left out */ {create_print('n');}
  | ','
  ;

goto_list: SYMBOL {create_goto($1);}
  | goto_list ',' SYMBOL {create_goto($3);}
  ;

gosub_list: SYMBOL {create_gosub($1);}
  | gosub_list ',' SYMBOL {create_gosub($3);}
  ;
 
%%
char const * SamplinParser::tname(int token)\
{ \
return yytname[YYTRANSLATE(token)]; \
}\

