/**************************************************************************
 * $Id: OptionsDlg.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef OptionsDlg_included
#define OptionsDlg_included

#include "dlg/OptionsDlgData.h"

class OptionsDlg : public OptionsDlgData
{
   Q_OBJECT
     
 public:
   
   OptionsDlg
     (
      QWidget* parent = NULL,
      const char* name = NULL
      );

   virtual ~OptionsDlg();

   void setDelay(const char *str){input_delay->setText(str);}   
   void setRead(const bool c){input_read->setChecked(c);}
   void setWrite(const bool c){input_write->setChecked(c);}   
//   void setTimeout(const char *str){input_timeout->setText(str);}      
   void setNTimeout(const char *str){input_ntimeout->setText(str);}   
   void setEndian(const int type){input_endian->setCurrentItem(type);
   }
   void setType(const int type){   input_type->setCurrentItem(type);
   }
   void setEos(const char *str){input_eos->setText(str);
   }
   
   
   const char *getDelay(void){return(input_delay->text());}   
   bool getRead(void){return(input_read->isChecked());}
   bool getWrite(void){return(input_write->isChecked());}      
//   const char *getTimeout(void){return(input_timeout->text());}   
   const char *getNTimeout(void){return(input_ntimeout->text());}   
   int getEndian(void){return(input_endian->currentItem());
   }
   int getType(void){return(input_type->currentItem());
   }
   const char *getEos(void){return(input_eos->text());
   }
   
   
 protected slots:
   void typeSlot(int);

 signals:
   void typeSignal(int);
};
#endif // OptionsDlg_included
