/**************************************************************************
 * $Id: ibSampLin.c 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include "ibSampLin.h"
#include <sys/ioctl.h>
#include <limits.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <stdarg.h>

int iberr = 0;
int ibsta = 0;
int ibcnt = 0;

typedef struct {
   char *devname;
   int fd;
   int count;
} devitem;

devitem *findDev(const char *name);
void printDevs(void);
void init_lib(void);
devitem *addDev(const char *dev, int fd);
int decrDev(int fd);

devitem *opendevs[OPEN_MAX];
int init_flag=FALSE;

int ibOpen(const char *dev, int pad)
{
   int fd;
   devitem *d;
   
   if(init_flag==FALSE)init_lib();
   if(dev==0)return -1;
   
   if((d=findDev(dev))==0){
      if( ( fd = open( dev, O_RDWR )) < 0 ){
	 ibsta =  ERR;
	 iberr = EDVR;
	 ibcnt = errno;
	 return -1;
      }
      
      ibFunc(fd,IBONL,1);
      ibFunc(fd,IBSIC,1);
      ibFunc(fd,IBSRE,1);
      
      d=addDev(dev,fd);
      if(d==0){
	 close(fd);
	 return -1;
      }
   }
   
   ++(d->count);
//   printDevs();
   return(d->fd);
}

int ibClose(int fd, int pad)
{
   int ret;
   
   if(init_flag==FALSE)return(-1);
   
   ret=decrDev(fd);
   
//   printDevs();
   return(ret);
}

void init_lib(void)
{
   memset(opendevs,0,sizeof(opendevs));
   init_flag=TRUE;
}

devitem *findDev(const char *name)
{
   devitem *d;
   char *tmp;
   int i=0;
   
   if(name!=0){
      while(i<OPEN_MAX){
	 d=opendevs[i];
	 if(d!=0){
	    tmp=d->devname;
	    if(tmp!=0)
	      if(!strcmp(tmp,name) && strlen(tmp)==strlen(name))return(d);
	 }
	 ++i;
      }
   }
   return(0);
}

int decrDev(int fd)
{
   int i;
   int ret;
   devitem *d=opendevs[0];

   i=0;
   while(i<OPEN_MAX){
      if(opendevs[i]!=0){
	 d=opendevs[i];
	 if(fd==d->fd){
	    --(d->count);
	    ret=0;
	    if(d->count<=0){
	       ibFunc(fd,IBONL,0);
	       ret=close(d->fd);
	       free(d->devname);
	       opendevs[i]=0;
	       free(d);
	    }
	    return(ret);
	 }
      }
      ++i;
   }
   
   return(-2);
}

devitem *addDev(const char *dev, int fd)
{
   int i;
   devitem *d;
   
   i=0;
   while(opendevs[i]!=0 && i<OPEN_MAX)++i;
   if(i<OPEN_MAX){
      d=malloc(sizeof(devitem));
      d->fd=fd;
      d->devname=strdup(dev);
      d->count=0;
      opendevs[i]=d;
      return d;
   }
   else return 0;   
}

void printDevs(void)
{
   int i;
   printf("%20s, %10s, %10s\n","device","fd","count" );
   i=0;
   while(i<OPEN_MAX){
      if(opendevs[i]!=0){
	 printf("%20s, %10i, %10i\n", opendevs[i]->devname,opendevs[i]->fd, opendevs[i]->count);
      }
      ++i;
   }
   
}

ibarg_t ibargs = {0 };

int ibFunc(int handle, int code, ...)
{
   va_list ap;
   static int arg;
   static char *buf;
   static int cnt;
   
   if(handle<0 )return ERR;

   va_start(ap,code);
   
   switch (code) {
    case IBRD:
    case DVRD:
    case IBWRT:
    case DVWRT:
    case IBAPE:
    case IBCMD:
      arg=va_arg(ap, int);
      buf=va_arg(ap, char *);
      cnt=va_arg(ap, int);
//      printf("ibFunc %s: handle=%i, pad=%i, cnt=%i\n",ibVerbCode(code),handle,arg,cnt);
      break;
    case IBAPRSP:
    case IBRPP:
    case DVRSP:
      arg=va_arg(ap, int);
      buf=va_arg(ap, char *);
      buf[0]=0;
      cnt=1;
      break;
    case IBEOS:
      arg=va_arg(ap, int);
      buf=0;
      cnt=0;
      break;
    default:
      arg=va_arg(ap, int);
      buf=NULL;
      cnt=0;
      break;
   }
   va_end(ap);
   
   switch (code) {
    case IBRD:
    case DVRD:
      memset(buf,0,cnt);
      break;
   }

   ibargs.ib_arg = arg;
   ibargs.ib_buf = (char *) buf;
   ibargs.ib_cnt = cnt;
   if( ioctl( handle, code, (ibarg_t *) &ibargs ) < 0){
      ibsta = ERR;
      iberr = EDVR;
      ibcnt = errno;
   } else {
      ibsta = ibargs.ib_ibsta;
      iberr = ibargs.ib_iberr;
      ibcnt = ibargs.ib_ibcnt;
   }
   
   if(code == IBRD || code==DVRD ){
      memcpy(buf,ibargs.ib_buf,ibcnt);
   }

   return ibsta;
}





