/**************************************************************************
 * $Id: PropBox.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef PROPBOX_H
#define PROPBOX_H

#ifndef QT_H
#include <qtableview.h>
#include <qpixmap.h>
#endif // QT_H


#define LBI_Undefined	0			// list box item types
#define LBI_Text	1
#define LBI_Pixmap	2
#define LBI_UserDefined 1000


class QStrList;
class QLBItemList;

class PropBox;


class PropBoxItem
{
public:
    PropBoxItem();
    virtual ~PropBoxItem();

    virtual const char	  *text()   const { return txt; }
    virtual const QPixmap *pixmap() const { return 0; }

    virtual int	 height( const PropBox * ) const = 0;
    virtual int	 width( const PropBox * )  const = 0;

protected:
    virtual void paint( QPainter * ) = 0;
    void	 setText( const char *text ) { txt = text; }

private:
    QString txt;
    bool selected;

    friend class PropBox;

private:	// Disabled copy constructor and operator=
    PropBoxItem( const PropBoxItem & );
    PropBoxItem &operator=( const PropBoxItem & );
};


class PropBoxText : public PropBoxItem
{
public:
    PropBoxText( const char * = 0 );
   ~PropBoxText();
    void  paint( QPainter * );
    int	  height( const PropBox * ) const;
    int	  width( const PropBox * )  const;
private:	// Disabled copy constructor and operator=
    PropBoxText( const PropBoxText & );
    PropBoxText &operator=( const PropBoxText & );
};


class PropBoxPixmap : public PropBoxItem
{
public:
    PropBoxPixmap( const QPixmap & );
   ~PropBoxPixmap();
    const QPixmap *pixmap() const { return &pm; }
protected:
    void paint( QPainter * );
    int height( const PropBox * ) const;
    int width( const PropBox * ) const;
private:
    QPixmap pm;
private:	// Disabled copy constructor and operator=
    PropBoxPixmap( const PropBoxPixmap & );
    PropBoxPixmap &operator=( const PropBoxPixmap & );
};


class PropBox : public QTableView		// list box widget
{
    Q_OBJECT
public:
    PropBox( QWidget *parent=0, const char *name=0, WFlags f=0  );
   ~PropBox();

    void	setFont( const QFont & );

    uint	count() const;

    void	insertStrList( const QStrList *, int index=-1 );
    void	insertStrList( const char**, int numStrings=-1, int index=-1 );

    void	insertItem( const PropBoxItem *, int index=-1 );
    void	insertItem( const char *text, int index=-1 );
    void	insertItem( const QPixmap &pixmap, int index=-1 );
    void	inSort( const PropBoxItem * );
    void	inSort( const char *text );

    void	removeItem( int index );
    void	clear();

    const char *text( int index )	const;
    const QPixmap *pixmap( int index )	const;

    void	changeItem( const PropBoxItem *, int index );
    void	changeItem( const char *text, int index );
    void	changeItem( const QPixmap &pixmap, int index );

    bool	autoUpdate()	const;
    void	setAutoUpdate( bool );

    int		numItemsVisible() const;
    void	setFixedVisibleLines( int lines );

    int		currentItem()	const;
    void	setCurrentItem( int index );
    void	centerCurrentItem();
    int		topItem()	const;
    void	setTopItem( int index );

    bool	dragSelect()		const;
    void	setDragSelect( bool );
    bool	autoScroll()		const;
    void	setAutoScroll( bool );
    bool	autoScrollBar()		const;
    void	setAutoScrollBar( bool );
    bool	scrollBar()		const;
    void	setScrollBar( bool );
    bool	autoBottomScrollBar()	const;
    void	setAutoBottomScrollBar( bool );
    bool	bottomScrollBar()	const;
    void	setBottomScrollBar( bool );
    bool	smoothScrolling()	const;
    void	setSmoothScrolling( bool );

    int		itemHeight()		const;
    int		itemHeight( int index ) const;

    long	maxItemWidth() const;
    long	maxItemWidth(); // only for bin. compat

    bool	isMultiSelection() const;
    void	setMultiSelection( bool );

    void	setSelected( int, bool );
    bool	isSelected( int ) const;

    QSize	sizeHint() const;

public slots:
    void	clearSelection();

signals:
    void	highlighted( int index );
    void	selected( int index );
    void	highlighted( const char * );
    void	selected( const char * );

    void	selectionChanged();

   void mouseClick(QMouseEvent *e,int item);
   
protected:
    PropBoxItem *item( int index ) const;
    bool	itemVisible( int index );

    int		cellHeight( int index = 0 );
    void	paintCell( QPainter *, int row, int col );

    void	mousePressEvent( QMouseEvent * );
    void	mouseReleaseEvent( QMouseEvent * );
    void	mouseDoubleClickEvent( QMouseEvent * );
    void	mouseMoveEvent( QMouseEvent * );
    void	keyPressEvent( QKeyEvent *e );
    void	focusInEvent( QFocusEvent *e );
    void	focusOutEvent( QFocusEvent *e );
    void	resizeEvent( QResizeEvent * );
    void	timerEvent( QTimerEvent * );

    int		findItem( int yPos ) const;
    bool	itemYPos( int index, int *yPos ) const;
    void	updateItem( int index, bool clear = TRUE );
    void	clearList();
    void	updateCellWidth();

    void	toggleCurrentItem();

private:
    void	updateNumRows( bool );
    void	insert( const PropBoxItem *, int, bool );
    void	change( const PropBoxItem *lbi, int );
    void	setMaxItemWidth( int );
    void	ensureCurrentVisible( int = -1 );

    void	emitChangedSignal( bool );

    uint	doDrag		: 1;
    uint	doAutoScroll	: 1;
    uint	isTiming	: 1;
    uint	scrollDown	: 1;
    uint	stringsOnly	: 1;
    uint	multiSelect	: 1;
    uint	goingDown	: 1;
    int		current;
//protected:
   QLBItemList *itemList;

private:	// Disabled copy constructor and operator=
    PropBox( const PropBox & );
    PropBox &operator=( const PropBox & );
};


inline bool PropBox::isMultiSelection() const
{
    return multiSelect;
}


#endif // PROPBOX_H
