/**************************************************************************
 * $Id: SeriesFit.cpp 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include "SeriesFit.h"

#define Inherited SeriesFitData

#include "SeriesFit.moc"

SeriesFit::SeriesFit
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
   setCaption( "Series fitting" );
   curve=NULL;
   connect(inp_range,SIGNAL(clicked()),SLOT(updateEnabled()));
   fitting=false;
}


SeriesFit::~SeriesFit()
{
}

void SeriesFit::setData(SamplinCurve *crv)
{
   QString tmp;
   
   curve=crv;
   if(crv){
      d_function=crv->d_parser.function();
      inp_function->setText(d_function);

      d_from=crv->d_parser.rangeLow();
      tmp.sprintf("%g",d_from);
      inp_from->setText(tmp);
      d_to=crv->d_parser.rangeHigh();
      tmp.sprintf("%g",d_to);
      inp_to->setText(tmp);
      d_range=crv->d_parser.rangeMan();
      inp_range->setChecked(d_range);
      inp_output->setText(crv->messages());

      d_eps=crv->d_parser.epsilon();
      tmp.sprintf("%g",d_eps);
      inp_epsilon->setText(tmp);

      d_auto=crv->d_parser.autoFit();
      inp_auto->setChecked(d_auto);
      
      connect(&(crv->d_parser),SIGNAL(finished()),SLOT(stop()));
      connect(&(crv->d_parser),SIGNAL(fitting()),SLOT(start()));
   
   }
   updateEnabled();
}

int SeriesFit::loadBack(bool force)
{
   int ret=0;
   
   if(curve){
      curve->d_parser.setAutoFit(inp_auto->isChecked());
      curve->d_parser.setEpsilon(atof(inp_epsilon->text()));

      ret=curve->d_parser.setFunction(inp_function->text(), force);
      curve->d_parser.setRange(inp_range->isChecked(),atof(inp_from->text()),atof(inp_to->text()));
//      curve->setFunctionMan(inp_range->isChecked());
      inp_output->setText(curve->messages());
   }
   return ret;
}

int SeriesFit::loadOld(void)
{
   int ret=0;

   if(curve){
      curve->d_parser.setEpsilon(d_eps);
      curve->d_parser.setAutoFit(d_auto);
      ret=curve->d_parser.setFunction(d_function);
      curve->d_parser.setRange(d_range,d_from,d_to);
//      curve->setFunctionMan(d_range);
   }
   return ret;
}

void SeriesFit::updateEnabled()
{
   bool set=inp_range->isChecked();
   
   inp_from->setEnabled(set);
   inp_to->setEnabled(set);
   
}

void SeriesFit::fit()
{
   //   if(curve->setFunction(d_function)!=-1)
   if(fitting==true){
      curve->d_parser.stopFit();
   }
   else if(curve && loadBack(true)!=-1){
      curve->d_parser.regress(TRUE);
      emit update();
      inp_output->setText(curve->messages());  
   }
}

void SeriesFit::start()
{
   fitting=true;
   button_fit->setText("Stop");   
}

void SeriesFit::stop()
{
   fitting=false;
   button_fit->setText("Fit");
}
