#ifndef QWT_H
#define QWT_H

//
// GLOBAL CONSTANTS
//
class Qwt 
{
public:
    enum Orientation { 
    	Horizontal, 
    	Vertical 
    };
    enum Position { 
    	Left, 
    	Right, 
    	Top, 
    	Bottom, 
    	Center 
    }; 
	enum Errors {
		ErrNone,							/* No Error */
		ErrNoMem,						/* Not enough memory */
		ErrMono							/* Non-monotonic sequence */
	};
};

enum ScalePos {yLeft, yRight, xBottom, xTop, axisCnt
   };


inline int verifyXAxis(int axis)
{
   if ((axis == xBottom) || (axis == xTop))
             return axis;
       else
            return xBottom;
}

inline int verifyYAxis(int axis)
{
   if ((axis == yLeft) || (axis == yRight))
             return axis;
       else
            return yLeft;
}

inline bool axisValid(int axis)
{
       return ((axis >= yLeft) && (axis < axisCnt));
}


#endif
