#ifndef QWT_COUNTER_H
#define QWT_COUNTER_H

#include <qwidget.h>
#include <qpushbt.h>
#include <qlined.h>
#include <qwt_drange.h>
#include <qlabel.h>

class QwtCounter : public QWidget, public QwtDblRange
{
	Q_OBJECT
	   
 public:
	enum CounterStyle { Single = 1, Double = 2, Triple = 3 };

 private:

	int tmrID;
	int d_tmrIntv;
	int d_tick;
	
	QPushButton *btnL[3];
	QPushButton *btnR[3];
	QLabel *lblValue;

	int d_incValue;
	int d_Inc[3];
	int d_nButtons;

	
	void valueChange();
	
	
public:

	QwtCounter(QWidget *parent = 0, char *name = 0);
	~QwtCounter();
	
	void resizeEvent(QResizeEvent *e);
	void timerEvent(QTimerEvent *e);
	
	void setCounterStyle(CounterStyle);
	void setBigInc(int);

private slots:

	void btnL1Dn();
    void btnL2Dn();
    void btnL3Dn();
	void btnR1Dn();
	void btnR2Dn();
	void btnR3Dn();
	void btnUp();


signals:

	void valueChanged(double);

};

#endif
